/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.HashSet;
import java.util.Set;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ExternalGeranCellChangeFrequencyValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ExternalGeranCellChangeFrequencyValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String GERAN_FREQUENCY_TYPE = "GeranFrequency";
    private static final String GERAN_FREQ_GROUP_REF = "geranFreqGroupRef";
    private static final String RESERVED_BY = "reservedBy";
    protected static final String VALIDATION_FAIL_MESSAGE = " must exist in ";

    public ExternalGeranCellChangeFrequencyValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute("geranFrequencyRef", coordinator);
        if (null != managedObject2) {
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
                ManagedObject managedObject3 = managedObjectArray[i].getParent();
                ManagedObject managedObject4 = (ManagedObject)managedObject3.getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
                hashSet.addAll(this.extractGeranFrequencies((ManagedObject[])managedObject4.getAttribute(RESERVED_BY, coordinator)));
                if (!hashSet.add(managedObject2)) continue;
                String string = managedObject2.getLocalDistinguishedName() + VALIDATION_FAIL_MESSAGE + managedObject4.getLocalDistinguishedName();
                this.logAndThrowPrepareFailedException(string);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private Set extractGeranFrequencies(ManagedObject[] managedObjectArray) {
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!GERAN_FREQUENCY_TYPE.equals(managedObjectArray[i].getType())) continue;
            hashSet.add(managedObjectArray[i]);
        }
        return hashSet;
    }
}

