/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class FirstAttrLessThanSecondAttrValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = FirstAttrLessThanSecondAttrValidator.class;
    private static final boolean VALIDATE_AT_CREATE_FALSE = false;
    private static final boolean VALIDATE_AT_PREPARE_TRUE = true;
    private static final boolean VALIDATE_AT_DELETE_FALSE = false;
    private final boolean isAttributeStruct;
    private final String firstAttr;
    private final String secondAttr;
    private final String attributeToValidate;

    public FirstAttrLessThanSecondAttrValidator(String string, String string2, String string3, boolean bl) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.attributeToValidate = string;
        this.firstAttr = string2;
        this.secondAttr = string3;
        this.isAttributeStruct = bl;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        if (this.isAttributeStruct) {
            this.validateStructAttribute(managedObject, coordinator);
        } else {
            Integer n = (Integer)managedObject.getAttribute(this.firstAttr, coordinator);
            Integer n2 = (Integer)managedObject.getAttribute(this.secondAttr, coordinator);
            if (n >= n2) {
                this.logAndThrowPrepareFailedException("Attribute " + this.firstAttr + " must be less than " + this.secondAttr);
            }
        }
    }

    private void validateStructAttribute(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, NotHandledAttributeTypeException, MoNotFoundException, PrepareFailedException {
        Object object = managedObject.getAttribute(this.attributeToValidate, coordinator);
        Struct struct = (Struct)object;
        String[] stringArray = struct.getNames();
        Object[] objectArray = struct.getValues();
        Integer n = new Integer(0);
        Integer n2 = new Integer(0);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.firstAttr.equals(stringArray[i])) {
                n = (Integer)objectArray[i];
            }
            if (!this.secondAttr.equals(stringArray[i])) continue;
            n2 = (Integer)objectArray[i];
        }
        if (n > 0 && n2 > 0 && n >= n2) {
            this.logAndThrowPrepareFailedException("Attribute " + this.firstAttr + " must be less than " + this.secondAttr);
        }
    }
}

