/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.GetChildrenByTypeHelper;

public class IncludeInSystemInfoValidator
extends AbstractAttributeValidator {
    private static final String MOTYPE_CDMA2000_FREQ_BAND_RELATION = "Cdma2000FreqBandRelation";
    private static final String MOTYPE_CDMA2000_CELL_RELATION = "Cdma2000CellRelation";
    private static final String ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION = "includeInSystemInformation";
    private static final Class THIS_CLASS = IncludeInSystemInfoValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IncludeInSystemInfoValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(mo[" + managedObject.getLocalDistinguishedName() + "])");
        Boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION, coordinator);
        if (bl.booleanValue()) {
            this.validateChildrenUnderFreq(managedObject, coordinator);
            this.validateChildrenCell(managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateChildrenUnderFreq(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateChildrenUnderFreq()");
        List list = GetChildrenByTypeHelper.getInstance().getAllChildrenByTypeFromMo(managedObject.getParent(), MOTYPE_CDMA2000_CELL_RELATION);
        this.validateNumberOfIncludeInsystemInformation(list, coordinator, 16, MOTYPE_CDMA2000_CELL_RELATION);
        logger.traceReturn(THIS_CLASS, "validateChildrenUnderFreq()");
    }

    private void validateChildrenCell(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateChildrenCell()");
        List list = GetChildrenByTypeHelper.getInstance().getAllGrandChildrenByTypeFromMo(managedObject.getParent().getParent(), MOTYPE_CDMA2000_FREQ_BAND_RELATION, MOTYPE_CDMA2000_CELL_RELATION);
        this.validateNumberOfIncludeInsystemInformation(list, coordinator, 32, "EUtranCell");
        logger.traceEnter(THIS_CLASS, "validateChildrenCell()");
    }

    private void validateNumberOfIncludeInsystemInformation(List list, Coordinator coordinator, int n, String string) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        boolean bl;
        logger.traceEnter(THIS_CLASS, "validateNumberOfIncludeInsystemInformation()");
        int n2 = this.countIncludeInSystemInformation(list, coordinator);
        boolean bl2 = bl = n2 <= n;
        if (n2 > n) {
            String string2 = "It is not allowed to have more then " + n + " Cdma2000CellRelation " + "with the attribute 'includeInSystemInformation = true' under the " + string + ", actual = " + n2;
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "validateNumberOfIncludeInsystemInformation(" + bl + ")");
    }

    private int countIncludeInSystemInformation(List list, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "countIncludeInSystemInformation()");
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Boolean bl;
            ManagedObject managedObject = (ManagedObject)iterator.next();
            if (MoCheck.isMoNotReadable(managedObject) || !(bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION, coordinator)).booleanValue()) continue;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "countIncludeInSystemInformation(count[" + n + "])");
        return n;
    }
}

