/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class LimitMaxNoOfPagingRecordsValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = LimitMaxNoOfPagingRecordsValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String moAttributeName;
    private final GenericMaoContext genericMaoContext;
    private static final Map refMaxNoOfPagingRecordsMap = new HashMap();

    public LimitMaxNoOfPagingRecordsValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        this.moAttributeName = string;
        this.genericMaoContext = genericMaoContext;
        this.setUpRefMaxNoOfPagingRecords();
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        this.validateMaxNoOfPagingRecords(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateMaxNoOfPagingRecords(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Object object;
        Integer n;
        Integer n2;
        logger.traceEnter(THIS_CLASS, "validateMaxNoOfPagingRecords(ManagedObject " + managedObject + ")");
        if (managedObject.getType().equals("Paging")) {
            n2 = (Integer)managedObject.getAttribute(this.moAttributeName, coordinator);
            n = this.getMinChannelBandFromAllCells(coordinator);
        } else {
            object = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,ENodeBFunction=1,Paging=1");
            n2 = (Integer)object.getAttribute("maxNoOfPagingRecords", coordinator);
            n = (Integer)managedObject.getAttribute(this.moAttributeName, coordinator);
        }
        if (n != null) {
            Integer n3 = this.getMaxNoOfPagingRecordsFromChannelBandwidth(n);
            if (n3 == null) {
                this.logAndThrowPrepareFailedException("Could not determine maxNoOfPagingRecords.");
            } else if (n2.compareTo(n3) > 0) {
                object = "MaxNoOfPagingRecords(" + n2 + ") is not recommended settings. Should set to " + n3;
                this.logAndThrowPrepareFailedException((String)object);
            }
        }
        logger.traceReturn(THIS_CLASS, "validateMaxNoOfPagingRecords()");
    }

    private Integer getMinChannelBandFromAllCells(Coordinator coordinator) throws MoAccessException {
        Integer n = null;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellFDD");
        MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellTDD");
        if (moIterator != null) {
            n = this.getMinChannelBandwidth(n, moIterator, "dlChannelBandwidth", coordinator);
        }
        if (moIterator2 != null) {
            n = this.getMinChannelBandwidth(n, moIterator2, "channelBandwidth", coordinator);
        }
        return n;
    }

    private Integer getMinChannelBandwidth(Integer n, MoIterator moIterator, String string, Coordinator coordinator) throws MoAccessException {
        Integer n2 = n;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            Integer n3 = (Integer)managedObject.getAttribute(string, coordinator);
            if (n3 == null || n2 != null && n2.compareTo(n3) <= 0) continue;
            n2 = n3;
        }
        return n2;
    }

    private Integer getMaxNoOfPagingRecordsFromChannelBandwidth(Integer n) {
        return (Integer)refMaxNoOfPagingRecordsMap.get(n);
    }

    private void setUpRefMaxNoOfPagingRecords() {
        refMaxNoOfPagingRecordsMap.put(new Integer(1400), new Integer(1));
        refMaxNoOfPagingRecordsMap.put(new Integer(3000), new Integer(4));
        refMaxNoOfPagingRecordsMap.put(new Integer(5000), new Integer(7));
        refMaxNoOfPagingRecordsMap.put(new Integer(10000), new Integer(16));
        refMaxNoOfPagingRecordsMap.put(new Integer(15000), new Integer(16));
        refMaxNoOfPagingRecordsMap.put(new Integer(20000), new Integer(16));
    }
}

