/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class MappingInfoValidator
extends AbstractAttributeValidator {
    private static final String MAPPING_INFO_SIB12 = "mappingInfoSIB12";
    private static final String MAPPING_INFO_SIB11 = "mappingInfoSIB11";
    private static final String ATTRIBUTE_MAPPING_INFO = "mappingInfo";
    private static final Integer NOT_MAPPED = new Integer(0);
    private static final Class THIS_CLASS = MappingInfoValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public MappingInfoValidator() {
        super(THIS_CLASS.getName(), ATTRIBUTE_MAPPING_INFO, true, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        Struct struct = (Struct)managedObject.getAttribute(ATTRIBUTE_MAPPING_INFO, coordinator);
        this.checkThatSIB8AndSIB16AreInDifferentSI(struct);
        this.checkThatSIB11AndSIB12AreInDifferentSI(struct);
        this.checkThatAttributeIsUnique(struct, MAPPING_INFO_SIB11);
        this.checkThatAttributeIsUnique(struct, MAPPING_INFO_SIB12);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void checkThatSIB11AndSIB12AreInDifferentSI(Struct struct) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        Integer n;
        Integer n2 = (Integer)struct.getValue(MAPPING_INFO_SIB11);
        if (n2.equals(n = (Integer)struct.getValue(MAPPING_INFO_SIB12)) && !n2.equals(NOT_MAPPED)) {
            this.logAndThrowPrepareFailedException("The values for attributes [mappingInfoSIB11] and [mappingInfoSIB12] are same. They must have unique values.");
        }
    }

    private void checkThatSIB8AndSIB16AreInDifferentSI(Struct struct) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        Integer n;
        Integer n2 = (Integer)struct.getValue("mappingInfoSIB8");
        if (n2.equals(n = (Integer)struct.getValue("mappingInfoSIB16")) && !n2.equals(NOT_MAPPED)) {
            this.logAndThrowPrepareFailedException("SIB8 and SIB16 can not be mapped to the same SI message.");
        }
    }

    private void checkThatAttributeIsUnique(Struct struct, String string) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        Object object = struct.getValue(string);
        if (!object.equals(NOT_MAPPED)) {
            String[] stringArray = struct.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Object object2 = struct.getValue(string2);
                if (string2.equals(string) || !object2.equals(object)) continue;
                String string3 = "The values for attributes [" + string + "] and [" + string2 + "] are same. [" + string + "] must have an unique value.";
                this.logAndThrowPrepareFailedException(string3);
            }
        }
    }
}

