/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;

public class MbmsOverlapAlgorithm {
    private static final Class THIS_CLASS = MbmsOverlapAlgorithm.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String TDD = "TDD";
    private static final String FDD = "FDD";
    private static final String UNKNOWN_CELL_TYPE = "";
    private static final String NOTIFICATION_CONFIGURATION = "notificationConfiguration";
    private static final String COMMON_SF_ALLOC = "commonSFAlloc";
    private static final String NOTIFICATION_OFFSET = "notificationOffset";
    private static final String NOTIFICATION_SF_INDEX = "notificationSFIndex";
    private static final String SUBFRAME_ALLOCATION_ONE_FRAME = "subframeAllocationOneFrame";
    private static final String SUBFRAME_ALLOCATION_FOUR_FRAME = "subframeAllocationFourFrame";
    private static final String RADIO_FRAME_ALLOCATION_OFFSET = "radioframeAllocationOffset";
    private static final String RADIO_FRAME_ALLOCATION_PERIOD = "radioframeAllocationPeriod";
    private static final String SUB_FRAME_ALLOCATION = "subframeAllocation";
    private static final String MCCH_OFFSET = "mcchOffset";
    private static final String MCCH_REPETITION_PERIOD = "mcchRepetitionPeriod";
    private static final String SF_ALLOC_INFO = "sfAllocInfo";
    private boolean mbsnAreaCellRelationsExists = false;

    public void runOverlapAlgorithm(ManagedObject managedObject, Coordinator coordinator, GenericMaoContext genericMaoContext) throws NoSuchFieldException, NoSuchAttributeException, MoAccessException, PrepareFailedException {
        List list;
        String string = this.getNetworkType(managedObject, coordinator);
        if (!this.mbsnAreaCellRelationsExists) {
            string = FDD;
        }
        NotificationStruct notificationStruct = this.getNotificationStruct((Struct)managedObject.getAttribute(NOTIFICATION_CONFIGURATION, coordinator));
        SubFrameConfigurationStruct subFrameConfigurationStruct = this.getSubFrameNotificationStruct((Struct)managedObject.getAttribute(COMMON_SF_ALLOC, coordinator));
        McchConfiguration mcchConfiguration = this.getMcchConfiguration(managedObject, coordinator);
        MbsfnAreaContainer mbsfnAreaContainer = new MbsfnAreaContainer(subFrameConfigurationStruct, string, mcchConfiguration.getMcchRepetitionPeriod());
        if (this.mbsnAreaCellRelationsExists && mbsfnAreaContainer.doesTheMbsfnAreaOverlapWithPositioningSubFrames(list = this.getPositioningDataFromAllCellRelations(managedObject, coordinator, genericMaoContext))) {
            this.logAndThrowPrepareFailedException("The MbsfnArea configured in commonSFAlloc overlapps with positioning subframes of a cell.");
        }
        if (!mbsfnAreaContainer.canMbsfnAreaContainTheConfiguredNotification(notificationStruct.getNotificationOffset(), notificationStruct.getNotificationSfIndex())) {
            this.logAndThrowPrepareFailedException("The Notification being set does not match to Subframes of a commonSFAlloc. Please check the value of notificationOffset and notificationSfIndex.");
        }
    }

    private String getCellType(boolean bl, boolean bl2) throws NoSuchAttributeException, MoAccessException {
        String string = UNKNOWN_CELL_TYPE;
        if (bl && !bl2) {
            string = FDD;
        }
        if (!bl && bl2) {
            string = TDD;
        }
        return string;
    }

    private String getNetworkType(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = false;
        boolean bl2 = false;
        this.mbsnAreaCellRelationsExists = false;
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (MoCheck.isMoNotReadable(managedObject2) || !managedObject2.getType().equals("MbsfnAreaCellRelation")) continue;
            ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute("mbsfnAreaCellRef", coordinator);
            this.mbsnAreaCellRelationsExists = true;
            String string = managedObject3.getType();
            if (string.equals("EUtranCellFDD")) {
                bl = true;
            }
            if (!string.equals("EUtranCellTDD")) continue;
            bl2 = true;
        }
        return this.getCellType(bl, bl2);
    }

    private void logAndThrowPrepareFailedException(String string) throws PrepareFailedException {
        logger.info(THIS_CLASS, string);
        throw new PrepareFailedException(string);
    }

    private List getPositioningDataFromAllCellRelations(ManagedObject managedObject, Coordinator coordinator, GenericMaoContext genericMaoContext) throws NoSuchAttributeException, MoAccessException {
        ArrayList<SubFrameConfigurationStruct> arrayList = new ArrayList<SubFrameConfigurationStruct>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = this.isPositioningEnabled(genericMaoContext, coordinator);
        MoIterator moIterator = managedObject.getChildren();
        while (bl2 && moIterator.hasMoreElements()) {
            ManagedObject managedObject2;
            ManagedObject managedObject3 = moIterator.nextMo();
            if (MoCheck.isMoNotReadable(managedObject3) || !managedObject3.getType().equals("MbsfnAreaCellRelation") || !(bl = ((Boolean)(managedObject2 = (ManagedObject)managedObject3.getAttribute("mbsfnAreaCellRef", coordinator)).getAttribute("otdoaSuplActive", coordinator)).booleanValue())) continue;
            n = this.convertNoConsecutiveSubFramesEnumToInt((Integer)managedObject2.getAttribute("noConsecutiveSubframes", coordinator));
            n2 = this.convertPrsPeriodEnumToInt((Integer)managedObject2.getAttribute("prsPeriod", coordinator));
            n3 = this.getPrsSubFrameOffSetFromPrsConfigIndex((Integer)managedObject2.getAttribute("prsConfigIndexMapped", coordinator));
            arrayList.add(this.convertPositioningAreaIntoAnMbsfnArea(n, n3, n2));
        }
        return arrayList;
    }

    private boolean isPositioningEnabled(GenericMaoContext genericMaoContext, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = false;
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType("OtdoaSupl");
        if (moIterator != null && moIterator.hasMoreElements()) {
            Integer n = new Integer(1);
            ManagedObject managedObject = moIterator.nextMo();
            Integer n2 = (Integer)managedObject.getAttribute("serviceStateOtdoaSupl", coordinator);
            if (n2.equals(n)) {
                bl = true;
            }
        }
        return bl;
    }

    private int convertNoConsecutiveSubFramesEnumToInt(int n) {
        int n2 = -1;
        if (n == 0) {
            n2 = 1;
        } else if (n == 1) {
            n2 = 2;
        } else if (n == 2) {
            n2 = 4;
        } else if (n == 3) {
            n2 = 6;
        }
        return n2;
    }

    private int convertPrsPeriodEnumToInt(int n) {
        int n2 = -1;
        if (n == 0) {
            n2 = 16;
        } else if (n == 1) {
            n2 = 32;
        } else if (n == 2) {
            n2 = 64;
        } else if (n == 3) {
            n2 = 128;
        }
        return n2;
    }

    private int getPrsSubFrameOffSetFromPrsConfigIndex(int n) {
        int n2 = -1;
        if (this.isBetween(n, 0, 160)) {
            n2 = n;
        } else if (this.isBetween(n, 160, 480)) {
            n2 = n - 160;
        } else if (this.isBetween(n, 480, 1120)) {
            n2 = n - 480;
        } else if (this.isBetween(n, 1120, 2400)) {
            n2 = n - 1120;
        }
        return n2;
    }

    private boolean isBetween(int n, int n2, int n3) {
        return n >= n2 && n < n3;
    }

    private SubFrameConfigurationStruct convertPositioningAreaIntoAnMbsfnArea(int n, int n2, int n3) {
        int n4;
        SubFrameConfigurationStruct subFrameConfigurationStruct = new SubFrameConfigurationStruct();
        int n5 = n2 % 10;
        int n6 = n2 / 10;
        int n7 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n7 += 1 << n4;
        }
        n4 = (7 & (n7 <<= 20 - n5 - n) >> 1) + (0x38 & n7 >> 3) + (0x1C0 & n7 >> 5) + (0xE00 & n7 >> 7);
        subFrameConfigurationStruct.setRadioFrameAllocationOffset(n6);
        subFrameConfigurationStruct.setRadioFrameAllocationPeriod(n3);
        subFrameConfigurationStruct.setIsSubFrameAllocationIsFourFrame(4);
        String string = Integer.toBinaryString(n4 <<= 12);
        while (string.length() != 24) {
            string = "0" + string;
        }
        subFrameConfigurationStruct.setFourFrameBitString(string);
        return subFrameConfigurationStruct;
    }

    private NotificationStruct getNotificationStruct(Struct struct) throws NoSuchFieldException, MoNotFoundException, NotHandledAttributeTypeException {
        NotificationStruct notificationStruct = new NotificationStruct();
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals(NOTIFICATION_OFFSET)) {
                notificationStruct.setNotificationOffset(this.getStructValueAsInt(struct, string));
                continue;
            }
            if (!string.equals(NOTIFICATION_SF_INDEX)) continue;
            notificationStruct.setNotificationSfIndex(this.getStructValueAsInt(struct, string));
        }
        return notificationStruct;
    }

    private int getStructValueAsInt(Struct struct, String string) throws NoSuchFieldException, MoNotFoundException, NotHandledAttributeTypeException {
        return (Integer)struct.getValue(string);
    }

    private SubFrameConfigurationStruct getSubFrameNotificationStruct(Struct struct) throws NoSuchFieldException, NotHandledAttributeTypeException, MoNotFoundException {
        SubFrameConfigurationStruct subFrameConfigurationStruct = new SubFrameConfigurationStruct();
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals(SUBFRAME_ALLOCATION_ONE_FRAME)) {
                subFrameConfigurationStruct.setOneFrameBitString((String)struct.getValue(string));
                continue;
            }
            if (string.equals(SUBFRAME_ALLOCATION_FOUR_FRAME)) {
                subFrameConfigurationStruct.setFourFrameBitString((String)struct.getValue(string));
                continue;
            }
            if (string.equals(RADIO_FRAME_ALLOCATION_OFFSET)) {
                subFrameConfigurationStruct.setRadioFrameAllocationOffset(this.getStructValueAsInt(struct, string));
                continue;
            }
            if (string.equals(RADIO_FRAME_ALLOCATION_PERIOD)) {
                subFrameConfigurationStruct.setRadioFrameAllocationPeriod(this.getStructValueAsInt(struct, string));
                continue;
            }
            if (!string.equals(SUB_FRAME_ALLOCATION)) continue;
            subFrameConfigurationStruct.setIsSubFrameAllocationIsFourFrame(this.getStructValueAsInt(struct, string));
        }
        return subFrameConfigurationStruct;
    }

    private McchConfiguration getMcchConfiguration(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        McchConfiguration mcchConfiguration = new McchConfiguration();
        mcchConfiguration.setMcchRepetitionPeriod((Integer)managedObject.getAttribute(MCCH_REPETITION_PERIOD, coordinator));
        mcchConfiguration.setMcchOffset((Integer)managedObject.getAttribute(MCCH_OFFSET, coordinator));
        mcchConfiguration.setSfAllocInfo((String)managedObject.getAttribute(SF_ALLOC_INFO, coordinator));
        return mcchConfiguration;
    }

    public class MbsfnAreaContainer {
        private final int MAX_NO_FRAMES;
        private final String[] supportedFrames;

        public MbsfnAreaContainer(SubFrameConfigurationStruct subFrameConfigurationStruct, String string, int n) {
            this.MAX_NO_FRAMES = n;
            this.supportedFrames = new String[this.MAX_NO_FRAMES];
            String string2 = subFrameConfigurationStruct.getBitStringToUse();
            int n2 = 0;
            while (n2 < this.MAX_NO_FRAMES) {
                if (n2 % subFrameConfigurationStruct.getRadioFrameAllocationPeriod() == subFrameConfigurationStruct.getRadioFrameAllocationOffset()) {
                    if (string2.length() == 24) {
                        if (string.equals(MbmsOverlapAlgorithm.TDD)) {
                            this.addFrame(string2.substring(0, 5), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(5, 10), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(10, 15), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(15, 19), n2++, this.supportedFrames);
                            continue;
                        }
                        if (string.equals(MbmsOverlapAlgorithm.FDD)) {
                            this.addFrame(string2.substring(0, 6), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(6, 12), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(12, 18), n2++, this.supportedFrames);
                            this.addFrame(string2.substring(18, 24), n2++, this.supportedFrames);
                            continue;
                        }
                        ++n2;
                        continue;
                    }
                    this.supportedFrames[n2++] = string2;
                    continue;
                }
                ++n2;
            }
        }

        private void addFrame(String string, int n, String[] stringArray) {
            if (n < this.MAX_NO_FRAMES) {
                stringArray[n] = string;
            } else {
                stringArray[n - this.MAX_NO_FRAMES] = string;
            }
        }

        public boolean doesTheMbsfnAreaOverlapWithPositioningSubFrames(List list) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            String string = null;
            while (iterator.hasNext() && !bl) {
                SubFrameConfigurationStruct subFrameConfigurationStruct = (SubFrameConfigurationStruct)iterator.next();
                for (int i = 0; i < 4 && !bl; ++i) {
                    string = this.supportedFrames[subFrameConfigurationStruct.getRadioFrameAllocationOffset() + i];
                    if (string == null) continue;
                    char[] cArray = string.toCharArray();
                    char[] cArray2 = subFrameConfigurationStruct.getBitStringToUse().substring(0 + i * 6, 6 + i * 6).toCharArray();
                    bl = this.isOverlapping(cArray2, cArray, bl);
                }
            }
            return bl;
        }

        private boolean isOverlapping(char[] cArray, char[] cArray2, boolean bl) {
            boolean bl2 = false;
            for (int i = 0; i < cArray.length && !bl; ++i) {
                if (cArray[i] != '1' || cArray2[i] != '1') continue;
                bl2 = true;
            }
            return bl2;
        }

        public boolean canMbsfnAreaContainTheConfiguredNotification(int n, int n2) {
            boolean bl = true;
            char[] cArray = new char[6];
            for (int i = 1; i < 7; ++i) {
                cArray[i - 1] = i == n2 ? 49 : 48;
            }
            String string = this.supportedFrames[n];
            if (string == null) {
                bl = false;
            } else {
                char[] cArray2 = string.toCharArray();
                for (int i = 0; i < cArray.length && bl; ++i) {
                    if (cArray[i] != '1' || cArray2[i] != '0') continue;
                    bl = false;
                }
            }
            return bl;
        }
    }

    public class McchConfiguration {
        private int mcchRepetitionPeriod = 0;
        private int mcchOffset = 0;
        private String sfAllocInfo = "";

        public void setMcchRepetitionPeriod(int n) {
            this.mcchRepetitionPeriod = n;
        }

        public void setMcchOffset(int n) {
            this.mcchOffset = n;
        }

        public void setSfAllocInfo(String string) {
            this.sfAllocInfo = string;
        }

        public int getMcchRepetitionPeriod() {
            return this.mcchRepetitionPeriod;
        }

        public int getMcchOffset() {
            return this.mcchOffset;
        }

        public String getSfAllocInfo() {
            return this.sfAllocInfo;
        }
    }

    public class SubFrameConfigurationStruct {
        private String oneFrameBitString = "";
        private String fourFrameBitString = "";
        private boolean subframeAllocationFourFrames = false;
        private int valueOfRadioFrameAllocationOffset = 0;
        private int valueOfRadioFrameAllocationPeriod = 0;

        public void setSubFrameAllocationIsFourFrame(boolean bl) {
            this.subframeAllocationFourFrames = bl;
        }

        public void setRadioFrameAllocationPeriod(int n) {
            this.valueOfRadioFrameAllocationPeriod = n;
        }

        public void setRadioFrameAllocationOffset(int n) {
            this.valueOfRadioFrameAllocationOffset = n;
        }

        public void setFourFrameBitString(String string) {
            this.fourFrameBitString = string;
        }

        public void setOneFrameBitString(String string) {
            this.oneFrameBitString = string;
        }

        public boolean isSubFrameAllocationFourFrames() {
            return this.subframeAllocationFourFrames;
        }

        public int getRadioFrameAllocationPeriod() {
            return this.valueOfRadioFrameAllocationPeriod;
        }

        public int getRadioFrameAllocationOffset() {
            return this.valueOfRadioFrameAllocationOffset;
        }

        public String getFourFrameBitString() {
            return this.fourFrameBitString;
        }

        public String getOneFrameBitString() {
            return this.oneFrameBitString;
        }

        public String getBitStringToUse() {
            String string = this.oneFrameBitString;
            if (this.subframeAllocationFourFrames) {
                string = this.fourFrameBitString;
            }
            return string;
        }

        private void setIsSubFrameAllocationIsFourFrame(int n) {
            this.subframeAllocationFourFrames = false;
            if (n == 4) {
                this.subframeAllocationFourFrames = true;
            }
        }
    }

    public class NotificationStruct {
        private int notificationOffSet = -1;
        private int notificationSfIndex = -1;

        public void setNotificationSfIndex(int n) {
            this.notificationSfIndex = n;
        }

        public void setNotificationOffset(int n) {
            this.notificationOffSet = n;
        }

        public int getNotificationOffset() {
            return this.notificationOffSet;
        }

        public int getNotificationSfIndex() {
            return this.notificationSfIndex;
        }
    }
}

