/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.AilgAndMbmsActivationCheckWrapper;
import se.ericsson.lte.rbs.omf.common.validator.MbmsOverlapAlgorithm;

public class MbsfnAreaCellRelationMoTypeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = MbsfnAreaCellRelationMoTypeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;

    public MbsfnAreaCellRelationMoTypeValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "MbsfnAreaCellRelationMoTypeValidator(attribute " + string + ")");
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, "MbsfnAreaCellRelationMoTypeValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        if (AilgAndMbmsActivationCheckWrapper.getInstance().checkIfMbmsAndAilgAreBothActivated(managedObject, coordinator, stringBuffer)) {
            this.logAndThrowPrepareFailedException(stringBuffer.toString());
        }
        ManagedObject managedObject2 = managedObject.getParent();
        MoIterator moIterator = managedObject2.getChildren();
        this.checkIfFirstCellRelation(moIterator, coordinator);
        moIterator = managedObject2.getChildren();
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = (ManagedObject)moIterator.nextElement();
            if (MoCheck.isMoNotReadable(managedObject3)) continue;
            bl = this.checkBandwithAndFreq(managedObject3, managedObject, coordinator, bl, arrayList);
        }
        if (this.isAdministrativeStateStillEnabled(managedObject2, coordinator)) {
            MbmsOverlapAlgorithm mbmsOverlapAlgorithm = new MbmsOverlapAlgorithm();
            mbmsOverlapAlgorithm.runOverlapAlgorithm(managedObject2, coordinator, this.genericMaoContext);
        }
    }

    private boolean isAdministrativeStateStillEnabled(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return (Integer)managedObject.getAttribute("administrativeState", null) == 1 && (Integer)managedObject.getAttribute("administrativeState", coordinator) == 1;
    }

    private void checkIfFirstCellRelation(MoIterator moIterator, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (moIterator.hasMoreElements() && n < 2) {
            ManagedObject managedObject = moIterator.nextMo();
            if (managedObject.getType().equals("MbsfnAreaCellRelation")) {
                ++n;
                continue;
            }
            MoIterator moIterator2 = managedObject.getChildren();
            while (moIterator2 != null && moIterator2.hasMoreElements()) {
                arrayList.add(moIterator2.nextElement());
            }
        }
        if (n == 1) {
            this.verifyThatNoServiceIsEnabled(arrayList, coordinator);
        }
    }

    private void verifyThatNoServiceIsEnabled(List list, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)((ManagedObject)list.get(i)).getAttribute("operationalState", coordinator);
            if (n != 1) continue;
            this.logAndThrowPrepareFailedException("Not allowed to add first MbsfnAreaCellRelation to an MbsfnArea having a MbsmService with operationalState ENABLED.");
        }
    }

    private boolean checkBandwithAndFreq(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, boolean bl, List list) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute("mbsfnAreaCellRef", coordinator);
        int n = (Integer)managedObject3.getAttribute("cellId", coordinator);
        boolean bl2 = bl;
        if (managedObject.getType().equals(managedObject2.getType())) {
            ManagedObject managedObject4 = (ManagedObject)managedObject.getAttribute("mbsfnAreaCellRef", coordinator);
            Integer n2 = (Integer)managedObject4.getAttribute("cellId", coordinator);
            if (list.contains(n2)) {
                this.logAndThrowPrepareFailedException("The mbsfnAreaCellRef points to a cell with a cellId already used by a MbsfnAreaCellRelation.");
            } else {
                list.add(n2);
            }
            if (!bl2 && n != n2) {
                if (((Integer)managedObject3.getAttribute("earfcndl", coordinator)).intValue() != ((Integer)managedObject4.getAttribute("earfcndl", coordinator)).intValue()) {
                    this.logAndThrowPrepareFailedException("The MbsfnAreaCellRelation points to a cell with an earfcndl which is not the same as another cell already used by the MbsfnArea. CellId of the configured relations is " + n2 + ".");
                }
                if (((Integer)managedObject3.getAttribute("dlChannelBandwidth", coordinator)).intValue() != ((Integer)managedObject4.getAttribute("dlChannelBandwidth", coordinator)).intValue()) {
                    this.logAndThrowPrepareFailedException("The MbsfnAreaCellRelation points to a cell with a dlChannelBandwidth which is not the same as another cell already used by the MbsfnArea. CellId of the configured relations is " + n2 + ".");
                }
                bl2 = true;
            }
        }
        return bl2;
    }
}

