/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ModificationPeriodValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ModificationPeriodValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] attributeNames;
    private final GenericMaoContext genericMaoContext;

    public ModificationPeriodValidator(String string, String[] stringArray, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.attributeNames = stringArray;
        this.genericMaoContext = genericMaoContext;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        if (managedObject.getType().equalsIgnoreCase("Paging")) {
            MoIterator moIterator;
            Integer n = (Integer)managedObject.getAttribute(this.attributeNames[1], coordinator);
            int n2 = n;
            MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellTDD");
            if (moIterator2 != null) {
                this.validateCellAttributes(coordinator, n2, moIterator2);
            }
            if ((moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellFDD")) != null) {
                this.validateCellAttributes(coordinator, n2, moIterator);
            }
        } else {
            Integer n = (Integer)managedObject.getAttribute(this.attributeNames[0], coordinator);
            ManagedObject managedObject2 = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,ENodeBFunction=1,Paging=1");
            Integer n3 = (Integer)managedObject2.getAttribute(this.attributeNames[1], coordinator);
            int n4 = n;
            int n5 = n3;
            this.validateAttributes(n4, n5);
            logger.traceDebug(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ") modificationPeriodCoeff: " + n4 + " defaultPagingCycle: " + n5);
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }

    private void validateCellAttributes(Coordinator coordinator, int n, MoIterator moIterator) throws MoAccessException, PrepareFailedException {
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            if (MoCheck.isMoNotReadable(managedObject)) continue;
            Integer n2 = (Integer)managedObject.getAttribute(this.attributeNames[0], coordinator);
            int n3 = n2;
            this.validateAttributes(n3, n);
        }
    }

    private void validateAttributes(int n, int n2) throws PrepareFailedException {
        if (n * n2 > 1024) {
            this.logAndThrowPrepareFailedException("Attributes modificationPeriodCoeff * defaultPagingCycle must be less then 1024");
        }
    }
}

