/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.exception.IllegalRelationException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class NeighborCellValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = NeighborCellValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXTERNAL_EUTRAN_CELL_FDD = "ExternalEUtranCellFDD";
    private static final String EXTERNAL_EUTRAN_CELL_TDD = "ExternalEUtranCellTDD";
    private static final String EUTRAN_CELL_FDD = "EUtranCellFDD";
    private static final String EUTRAN_CELL_TDD = "EUtranCellTDD";
    private static final String ATTRIBUTE_NEIGHBORCELLREF = "neighborCellRef";
    private static final String ATTRIBUTE_EUTRANFREQUENCYREF = "eutranFrequencyRef";

    public NeighborCellValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = managedObject.getParent();
        ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute(ATTRIBUTE_EUTRANFREQUENCYREF, coordinator);
        ManagedObject managedObject4 = (ManagedObject)managedObject.getAttribute(ATTRIBUTE_NEIGHBORCELLREF, coordinator);
        String string = managedObject4.getType();
        if (EXTERNAL_EUTRAN_CELL_FDD.equals(string) || EXTERNAL_EUTRAN_CELL_TDD.equals(string)) {
            this.handleExternalEUtranCellNeighbor(coordinator, managedObject3, managedObject4);
        } else if (EUTRAN_CELL_FDD.equals(string)) {
            ManagedObject managedObject5 = managedObject2.getParent();
            this.handleEUtranCellNeighbor(coordinator, managedObject3, managedObject5, managedObject4, "earfcndl");
        } else if (EUTRAN_CELL_TDD.equals(string)) {
            ManagedObject managedObject6 = managedObject2.getParent();
            this.handleEUtranCellNeighbor(coordinator, managedObject3, managedObject6, managedObject4, "earfcn");
        } else {
            this.logAndThrowPrepareFailedException("Neighbor cell is not of correct type!");
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void handleEUtranCellNeighbor(Coordinator coordinator, ManagedObject managedObject, ManagedObject managedObject2, ManagedObject managedObject3, String string) throws MoAccessException, NoSuchAttributeException, IllegalParameterValueException, AttrValueNotUniqueException, IllegalRelationException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "handleEUtranCellNeighbor(parentEutranFrequencyRef = " + managedObject.getLocalDistinguishedName() + ", grandPa = " + managedObject2.getLocalDistinguishedName() + ", neighborCell = " + managedObject3.getLocalDistinguishedName() + ")");
        logger.traceDebug(THIS_CLASS, "Pointing at an cell in same node, going to verify the neighbor cell's frequency attribute, and that the cell isn't creating a reference to itself");
        Integer n = (Integer)managedObject3.getAttribute(string, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute("arfcnValueEUtranDl", coordinator);
        this.validateEarfcndl(managedObject3.getLocalDistinguishedName(), n, n2);
        String string2 = managedObject2.getLocalDistinguishedName();
        this.checkGrandPa(managedObject3.getLocalDistinguishedName(), string2);
        logger.traceReturn(THIS_CLASS, "handleEUtranCellNeighbor()");
    }

    private void handleExternalEUtranCellNeighbor(Coordinator coordinator, ManagedObject managedObject, ManagedObject managedObject2) throws MoAccessException, NoSuchAttributeException, IllegalParameterValueException, AttrValueNotUniqueException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "handleExternalEUtranCellNeighbor()");
        logger.traceDebug(THIS_CLASS, "Pointing at an external cell, going to verify the reference");
        String string = managedObject.getLocalDistinguishedName();
        ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute(ATTRIBUTE_EUTRANFREQUENCYREF, coordinator);
        String string2 = managedObject3.getLocalDistinguishedName();
        this.validateEutranFrequencyRef(string2, string);
        logger.traceReturn(THIS_CLASS, "handleExternalEUtranCellNeighbor()");
    }

    private void validateEutranFrequencyRef(String string, String string2) throws IllegalParameterValueException, AttrValueNotUniqueException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateEutranFrequencyRef(neighborCellsFreqRefLdn = " + string + ", parentEutranFrequencyRefAttributeLdn " + string2 + ")");
        if (!string.equals(string2)) {
            this.logAndThrowPrepareFailedException("Neighbor cell's frequency and this cell's frequency do not match!");
        }
        logger.traceReturn(THIS_CLASS, "validateEutranFrequencyRef()");
    }

    private void checkGrandPa(String string, String string2) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkGrandPa(myReferenceLdn = " + string + ", grandPaLdn = " + string2 + ")");
        if (string.equals(string2)) {
            String string3 = "Can not create a reference to EUtranCell " + string2;
            this.logAndThrowPrepareFailedException(string3);
        }
        logger.traceReturn(THIS_CLASS, "checkGrandPa()");
    }

    private void validateEarfcndl(String string, Integer n, Integer n2) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateEarfcndl(), Reference LDN: " + string + ", earfcndl from Neighbor cell: " + n + ", earfcndl from parent MO: " + n2);
        if (!n.equals(n2)) {
            String string2 = "Neighbor cell [" + string + "] [f=" + n + "] and this cell [f=" + n2 + "] do not have the same frequency!";
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "validateEarfcndl()");
    }
}

