/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class RangeCombinationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = RangeCombinationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String fixedAttributeName;
    private final int[] fixedAttributeValues;
    private final String rangeAttributeName;
    private final int[] lowerRangeLimits;
    private final int[] upperRangeLimits;

    public RangeCombinationValidator(String string, int n, String string2, int n2, int n3) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.fixedAttributeName = string;
        this.fixedAttributeValues = new int[]{n};
        this.rangeAttributeName = string2;
        this.lowerRangeLimits = new int[]{n2};
        this.upperRangeLimits = new int[]{n3};
    }

    public RangeCombinationValidator(String string, int[] nArray, String string2, int[] nArray2, int[] nArray3) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.fixedAttributeName = string;
        this.fixedAttributeValues = nArray;
        this.rangeAttributeName = string2;
        this.lowerRangeLimits = nArray2;
        this.upperRangeLimits = nArray3;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        Integer n = (Integer)managedObject.getAttribute(this.fixedAttributeName, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(this.rangeAttributeName, coordinator);
        for (int i = 0; i < this.fixedAttributeValues.length; ++i) {
            if (this.fixedAttributeValues[i] != n || n2 >= this.lowerRangeLimits[i] && n2 <= this.upperRangeLimits[i]) continue;
            String string = "The combination of attributes " + this.fixedAttributeName + " with value [" + n + "] and " + this.rangeAttributeName + " with value [" + n2 + "] is not valid";
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

