/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SectorCarrierModificationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = AbstractAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Integer UNLOCKED = new Integer(1);
    public static final String ATTR_RESERVED_BY = "reservedBy";
    public static final String MO_EUTRAN_CELL_TDD = "EUtranCellTDD";
    public static final String MO_EUTRAN_CELL_FDD = "EUtranCellFDD";

    public SectorCarrierModificationValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, true);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(ATTR_RESERVED_BY, coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            Integer n;
            ManagedObject managedObject2 = managedObjectArray[i];
            if (!MoCheck.isMoReadable(managedObject2) || !MO_EUTRAN_CELL_TDD.equalsIgnoreCase(managedObject2.getType()) && !MO_EUTRAN_CELL_FDD.equalsIgnoreCase(managedObject2.getType()) || !(n = (Integer)managedObject2.getAttribute("administrativeState", coordinator)).equals(UNLOCKED)) continue;
            String string = "SectorCarrier attribute could not be modified while EUtranCell administrativeState is UNLOCKED. EUtranCell LDN: " + managedObject2.getLocalDistinguishedName();
            this.logAndThrowPrepareFailedException(string);
        }
    }
}

