/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.AbstractEUtranCellMaoImplBase;

public class SectorCarrierRefValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = AbstractAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public SectorCarrierRefValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        boolean bl;
        String string;
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(this.attributeName, coordinator);
        if (!AbstractEUtranCellMaoImplBase.isOldOss && managedObjectArray.length == 0) {
            string = "AbstractEUtranCellMaoImplBase.sectorCarrierRef contain " + managedObjectArray.length + " sector carrier.";
            this.logAndThrowPrepareFailedException(string);
        }
        if (managedObjectArray.length > 6) {
            string = "AbstractEUtranCellMaoImplBase.sectorCarrierRef contain " + managedObjectArray.length + " sector carrier.";
            this.logAndThrowPrepareFailedException(string);
        }
        if (bl = this.isAnySectorCarrierReferredByTwoCells(managedObject, coordinator, managedObjectArray)) {
            this.logAndThrowPrepareFailedException("Cannot attach one sector to two cells");
        }
    }

    private boolean isAnySectorCarrierReferredByTwoCells(ManagedObject managedObject, Coordinator coordinator, ManagedObject[] managedObjectArray) throws MoAccessException {
        boolean bl = false;
        block0: for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[i].getAttribute("reservedBy", coordinator);
            if (managedObjectArray2 == null || bl) continue;
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                if (!managedObjectArray2[j].getType().equals(managedObject.getType()) || managedObject.equals(managedObjectArray2[j])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }
}

