/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.HashSet;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.SiMessageValidator;

public class SiMessageAlgorithm {
    private static final String[] MAP_INFO = new String[]{"mappingInfoSIB3", "mappingInfoSIB4", "mappingInfoSIB5", "mappingInfoSIB6", "mappingInfoSIB7", "mappingInfoSIB8", "mappingInfoSIB10", "mappingInfoSIB11", "mappingInfoSIB12"};
    private static final String[] SI_PER_INFO = new String[]{"siPeriodicitySI1", "siPeriodicitySI2", "siPeriodicitySI3", "siPeriodicitySI4", "siPeriodicitySI5", "siPeriodicitySI6", "siPeriodicitySI7", "siPeriodicitySI8", "siPeriodicitySI9", "siPeriodicitySI10"};
    private static final Class THIS_CLASS = SiMessageValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] attributeNames;
    private final Integer MBMS_NOT_FOUND = new Integer(-1);
    private final Integer NOT_MAPPED = new Integer(0);

    public SiMessageAlgorithm(String[] stringArray) {
        this.attributeNames = stringArray;
    }

    public void validateSiMessages(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateSiMessages(ManagedObject " + managedObject + ")");
        Integer n = this.MBMS_NOT_FOUND;
        ManagedObject managedObject2 = managedObject.getParent();
        MoIterator moIterator = managedObject2.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals("Mbms")) continue;
            n = (Integer)managedObject3.getAttribute("mappingInfoSIB13", coordinator);
        }
        Integer n2 = (Integer)managedObject.getAttribute(this.attributeNames[0], coordinator);
        Struct struct = (Struct)managedObject.getAttribute(this.attributeNames[1], coordinator);
        Struct struct2 = (Struct)managedObject.getAttribute(this.attributeNames[2], coordinator);
        int n3 = this.calcNrOfTransmittedSImessages(struct, n);
        int n4 = this.calcMinSiPeriodicity(struct2);
        int n5 = n2;
        this.validateAttributes(n5, n3, n4);
        logger.traceReturn(THIS_CLASS, "validateSiMessages(ManagedObject " + managedObject + ")");
    }

    private int calcNrOfTransmittedSImessages(Struct struct, Integer n) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < MAP_INFO.length; ++i) {
            Integer n2 = (Integer)struct.getValue(MAP_INFO[i]);
            if (n2.equals(this.NOT_MAPPED)) continue;
            hashSet.add(n2);
        }
        if (!n.equals(this.MBMS_NOT_FOUND) && !n.equals(this.NOT_MAPPED)) {
            hashSet.add(n);
        }
        hashSet.add(new Integer(1));
        return hashSet.size();
    }

    private int calcMinSiPeriodicity(Struct struct) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int n = 0;
        for (int i = 0; i < SI_PER_INFO.length; ++i) {
            Integer n2 = (Integer)struct.getValue(SI_PER_INFO[i]);
            if (n == 0) {
                n = n2;
                continue;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private void validateAttributes(int n, int n2, int n3) throws PrepareFailedException {
        if (n == 1 && n2 > 5) {
            this.logAndThrowPrepareFailedException("When attribute siWindowLength is [1], \u0091nr of transmitted SI messages\u0092 must be less or equal to 5.");
        } else if (n * n2 > n3 * 10) {
            this.logAndThrowPrepareFailedException("Attribute siWindowLength * \u0091nr of transmitted SI messages\u0092 <= MIN(siPeriodicitySI1-7 (in ms)");
        }
    }

    private void logAndThrowPrepareFailedException(String string) throws PrepareFailedException {
        logger.info(THIS_CLASS, string);
        throw new PrepareFailedException(string);
    }
}

