/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SubframeConfigValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SubframeConfigValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String SUBFRAME_ALLOCATION_ONE_FRAME = "subframeAllocationOneFrame";
    private static final String SUBFRAME_ALLOCATION_FOUR_FRAME = "subframeAllocationFourFrame";
    private static final String COMMON_SF_ALLOC = "commonSFAlloc";
    private static final String RADIO_FRAME_ALLOCATION_OFFSET = "radioframeAllocationOffset";
    private static final String RADIO_FRAME_ALLOCATION_PERIOD = "radioframeAllocationPeriod";
    private static final String SUB_FRAME_ALLOCATION = "subframeAllocation";
    private final String attributeToCheck;

    public SubframeConfigValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "SubframeConfigValidator(attribute " + string + ")");
        this.attributeToCheck = string;
        logger.traceReturn(THIS_CLASS, "SubframeConfigValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        if (this.attributeToCheck.equals(COMMON_SF_ALLOC)) {
            this.validateCommonSfAlloc(managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateCommonSfAlloc(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        SubFrameConfigurationStruct subFrameConfigurationStruct = this.getSubFrameNotificationStruct((Struct)managedObject.getAttribute(this.attributeToCheck, coordinator));
        if (!this.containsOnlyOnesAndZeroes(subFrameConfigurationStruct.getOneFrameBitString(), false)) {
            this.logAndThrow("The value of  subframeAllocationOneFrame with value [" + subFrameConfigurationStruct.getOneFrameBitString() + "]  is not valid. Can only contain 0's and 1's.");
        }
        if (!this.containsOnlyOnesAndZeroes(subFrameConfigurationStruct.getFourFrameBitString(), false)) {
            this.logAndThrow("The value of  subframeAllocationFourFrame with value [" + subFrameConfigurationStruct.getFourFrameBitString() + "]  is not valid. Can only contain 0's and 1's.");
        }
        if (!this.hasProperLength(subFrameConfigurationStruct.getOneFrameBitString(), SUBFRAME_ALLOCATION_ONE_FRAME)) {
            this.logAndThrow("The length of  subframeAllocationOneFrame with value [" + subFrameConfigurationStruct.getOneFrameBitString() + "]  is not valid. Must have a length of 6.");
        }
        if (!this.hasProperLength(subFrameConfigurationStruct.getFourFrameBitString(), SUBFRAME_ALLOCATION_FOUR_FRAME)) {
            this.logAndThrow("The length of  subframeAllocationFourFrame with value [" + subFrameConfigurationStruct.getFourFrameBitString() + "]  is not valid. Must have a length of 24.");
        }
        if (!this.hasRadioFrameAllocationPeriodValidValue(subFrameConfigurationStruct.getRadioFrameAllocationPeriod(), subFrameConfigurationStruct.isSubFrameAllocationFourFrames())) {
            this.logAndThrow("radioframeAllocationPeriod with value [" + subFrameConfigurationStruct.getRadioFrameAllocationPeriod() + "] is not valid. Can not be set to 1 or 2 if " + SUB_FRAME_ALLOCATION + " is set to 4 because of overlapping.");
        }
        if (!this.frameOffSetIsLessThenFramePeriod(subFrameConfigurationStruct.getRadioFrameAllocationOffset(), subFrameConfigurationStruct.getRadioFrameAllocationPeriod())) {
            this.logAndThrow("radioframeAllocationOffset with value [" + subFrameConfigurationStruct.getRadioFrameAllocationOffset() + "]  is not valid. Must be less then " + RADIO_FRAME_ALLOCATION_PERIOD + ".");
        }
    }

    private void logAndThrow(String string) throws PrepareFailedException {
        this.logAndThrowPrepareFailedException(string);
    }

    private boolean hasRadioFrameAllocationPeriodValidValue(int n, boolean bl) {
        boolean bl2 = true;
        if (bl && (n == 1 || n == 2)) {
            bl2 = false;
        }
        return bl2;
    }

    private boolean frameOffSetIsLessThenFramePeriod(int n, int n2) {
        boolean bl = false;
        if (n < n2) {
            bl = true;
        }
        return bl;
    }

    private boolean hasProperLength(String string, String string2) {
        boolean bl = false;
        if (string2.equals(SUBFRAME_ALLOCATION_FOUR_FRAME)) {
            if (string.length() == 24) {
                bl = true;
            }
        } else if (string.length() == 6) {
            bl = true;
        }
        return bl;
    }

    private boolean containsOnlyOnesAndZeroes(String string, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length && bl2; ++i) {
            char c = cArray[i];
            bl2 = this.isCharAOneOrATwo(c);
            if (!bl || !bl2) continue;
            if (c == '1' && bl3) {
                bl2 = false;
                continue;
            }
            if (c != '1') continue;
            bl3 = true;
        }
        return bl2;
    }

    private boolean isCharAOneOrATwo(char c) {
        boolean bl = true;
        if (c != '0' && c != '1') {
            bl = false;
        }
        return bl;
    }

    private int getStructValueAsInt(Struct struct, String string) throws NoSuchFieldException, MoNotFoundException, NotHandledAttributeTypeException {
        return (Integer)struct.getValue(string);
    }

    private SubFrameConfigurationStruct getSubFrameNotificationStruct(Struct struct) throws NoSuchFieldException, NotHandledAttributeTypeException, MoNotFoundException {
        SubFrameConfigurationStruct subFrameConfigurationStruct = new SubFrameConfigurationStruct();
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals(SUBFRAME_ALLOCATION_ONE_FRAME)) {
                subFrameConfigurationStruct.setOneFrameBitString((String)struct.getValue(string));
                continue;
            }
            if (string.equals(SUBFRAME_ALLOCATION_FOUR_FRAME)) {
                subFrameConfigurationStruct.setFourFrameBitString((String)struct.getValue(string));
                continue;
            }
            if (string.equals(RADIO_FRAME_ALLOCATION_OFFSET)) {
                subFrameConfigurationStruct.setRadioFrameAllocationOffset(this.getStructValueAsInt(struct, string));
                continue;
            }
            if (string.equals(RADIO_FRAME_ALLOCATION_PERIOD)) {
                subFrameConfigurationStruct.setRadioFrameAllocationPeriod(this.getStructValueAsInt(struct, string));
                continue;
            }
            if (!string.equals(SUB_FRAME_ALLOCATION)) continue;
            subFrameConfigurationStruct.setIsSubFrameAllocationIsFourFrame(this.getStructValueAsInt(struct, string));
        }
        return subFrameConfigurationStruct;
    }

    public class SubFrameConfigurationStruct {
        private String oneFrameBitString = "";
        private String fourFrameBitString = "";
        private boolean subframeAllocationFourFrames = false;
        private int valueOfRadioFrameAllocationOffset = 0;
        private int valueOfRadioFrameAllocationPeriod = 0;

        public void setSubFrameAllocationIsFourFrame(boolean bl) {
            this.subframeAllocationFourFrames = bl;
        }

        public void setRadioFrameAllocationPeriod(int n) {
            this.valueOfRadioFrameAllocationPeriod = n;
        }

        public void setRadioFrameAllocationOffset(int n) {
            this.valueOfRadioFrameAllocationOffset = n;
        }

        public void setFourFrameBitString(String string) {
            this.fourFrameBitString = string;
        }

        public void setOneFrameBitString(String string) {
            this.oneFrameBitString = string;
        }

        public boolean isSubFrameAllocationFourFrames() {
            return this.subframeAllocationFourFrames;
        }

        public int getRadioFrameAllocationPeriod() {
            return this.valueOfRadioFrameAllocationPeriod;
        }

        public int getRadioFrameAllocationOffset() {
            return this.valueOfRadioFrameAllocationOffset;
        }

        public String getFourFrameBitString() {
            return this.fourFrameBitString;
        }

        public String getOneFrameBitString() {
            return this.oneFrameBitString;
        }

        public String getBitStringToUse() {
            String string = this.oneFrameBitString;
            if (this.subframeAllocationFourFrames) {
                string = this.fourFrameBitString;
            }
            return string;
        }

        private void setIsSubFrameAllocationIsFourFrame(int n) {
            this.subframeAllocationFourFrames = false;
            if (n == 4) {
                this.subframeAllocationFourFrames = true;
            }
        }
    }
}

