/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SumValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SumValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final int lowerSumLimit;
    private final int upperSumLimit;
    private final GenericMaoContext genericMaoContext;
    private boolean ongoingCreate = false;

    public SumValidator(String string, int n, int n2, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.lowerSumLimit = n;
        this.upperSumLimit = n2;
        this.genericMaoContext = genericMaoContext;
    }

    public void validateAtCreate(ManagedObject managedObject, Object object, AttrList attrList, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate(ManagedObject " + managedObject + " ,...)");
        this.ongoingCreate = true;
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
        super.validateAtCreate(managedObject, object, attrList, coordinator);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        if (this.ongoingCreate) {
            logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ") ongoing create skipping validation");
            return;
        }
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(managedObject.getType());
        int n = this.calculateSum(coordinator, moIterator);
        if (n < this.lowerSumLimit || n > this.upperSumLimit) {
            String string = "The sum (" + n + ") of the values of attribute " + this.attributeName + " in all MOs of type " + managedObject.getType() + " is not within the allowed range [" + this.lowerSumLimit + ", " + this.upperSumLimit + "].";
            logger.info(THIS_CLASS, string);
            throw new PrepareFailedException(string);
        }
    }

    private int calculateSum(Coordinator coordinator, MoIterator moIterator) throws MoAccessException, NoSuchAttributeException {
        int n = 0;
        while (moIterator != null && moIterator.hasMoreElements()) {
            Object object;
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            if (MoCheck.isMoNotReadable(managedObject) || !((object = managedObject.getAttribute(this.attributeName, coordinator)) instanceof Integer)) continue;
            n += ((Integer)object).intValue();
        }
        return n;
    }

    public void handlePostSet(ManagedObject managedObject, String string, Object object) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ", attribute " + string + ", value " + object + ")");
        this.ongoingCreate = false;
        logger.traceReturn(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ")");
        super.handlePostSet(managedObject, string, object);
    }
}

