/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SyncSequenceLengthValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SyncSequenceLengthValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public SyncSequenceLengthValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "SyncSequenceLengthValidator(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, "SyncSequenceLengthValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        if (!this.isTheSyncSequenceLengthCorrectComparedToMchSchedulingPeriod(managedObject, coordinator)) {
            this.logAndThrowPrepareFailedException("An MbmsService has a syncSequenceLength that is smaller than the mchSchedulingPeriod in the PmchMch.");
        }
    }

    private boolean isTheSyncSequenceLengthCorrectComparedToMchSchedulingPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        int n = (Integer)managedObject.getAttribute("syncSequenceLength", coordinator);
        int n2 = (Integer)managedObject.getParent().getAttribute("mchSchedulingPeriod", coordinator);
        if (n2 < n) {
            bl = false;
        }
        return bl;
    }
}

