/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class TermPointToENBValidator
extends AbstractAttributeValidator {
    private static final String DEFAULT_IP_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_IPV6_ADDRESS = "::";
    private static final String EMPTY_DOMAIN_NAME = "";
    private static final String ATTRIBUTE_X2_IP_ADDR_VIA_S1_ACTIVE = "x2IpAddrViaS1Active";
    private static final String ATTRIBUTE_DOMAIN_NAME = "domainName";
    private static final String ATTRIBUTE_IP_ADDRESS = "ipAddress";
    private static final String ATTRIBUTE_IPV6_ADDRESS = "ipv6Address";
    private static final String ATTRIBUTE_CREATED_BY = "createdBy";
    private static final String ENODEBFUNCTION_MOTYPE = "ENodeBFunction";
    private static final int ADMINISTRATIVE_STATE_UNLOCKED = 1;
    private static final int CREATED_BY_X2 = 1;
    private static final Class THIS_CLASS = TermPointToENBValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;

    public TermPointToENBValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.genericMaoContext = genericMaoContext;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        Integer n = (Integer)managedObject.getAttribute(this.attributeName, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(ATTRIBUTE_CREATED_BY, coordinator);
        if (n == 1 && n2 != 1) {
            Object object = managedObject.getAttribute(ATTRIBUTE_IP_ADDRESS, coordinator);
            Object object2 = managedObject.getAttribute(ATTRIBUTE_IPV6_ADDRESS, coordinator);
            Object object3 = managedObject.getAttribute(ATTRIBUTE_DOMAIN_NAME, coordinator);
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(ENODEBFUNCTION_MOTYPE);
            ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
            Object object4 = managedObject2.getAttribute(ATTRIBUTE_X2_IP_ADDR_VIA_S1_ACTIVE, coordinator);
            if (object4.equals(Boolean.FALSE) && EMPTY_DOMAIN_NAME.equals(object3) && DEFAULT_IP_ADDRESS.equals(object) && DEFAULT_IPV6_ADDRESS.equals(object2)) {
                this.logAndThrowPrepareFailedException("Not possible to unlock TermPointToENB when values of attribute are: ipAddress[0.0.0.0], ipv6Address[::], domainName[\"\"] and ENodeBFunction:x2IpAddrViaS1Active[false]");
            }
        }
        logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
    }
}

