/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class TrafficModelPrbValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = TrafficModelPrbValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String QCI_DIST_SINR_HIGH = "qciDistSinrHigh";
    private static final String QCI_DIST_SINR_MEDIUM = "qciDistSinrMedium";
    private static final String QCI_DIST_SINR_LOW = "qciDistSinrLow";
    private static final String AILG_HIGH_PRIO = "ailgHighPrio";
    private static final String TRAFFIC_MODEL_PRB = "trafficModelPrb";
    private static final int TRAFFIC_MODEL = 1;

    public TrafficModelPrbValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        Integer n = (Integer)managedObject.getAttribute(AILG_HIGH_PRIO, coordinator);
        if (n == 1) {
            Object object = managedObject.getAttribute(TRAFFIC_MODEL_PRB, coordinator);
            Struct struct = (Struct)object;
            this.validateTrafficModelPrb(struct);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private int getqciDistSinrXSum(Struct struct, String string) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int[] nArray = this.getQciValues(struct.getValue(string));
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    private int[] getQciValues(Object object) {
        int[] nArray = null;
        if (object instanceof int[]) {
            nArray = (int[])object;
        } else if (object instanceof Object[] || object instanceof Integer[]) {
            Object[] objectArray = (Object[])object;
            nArray = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = (Integer)objectArray[i];
            }
        }
        return nArray;
    }

    private void validateTrafficModelPrb(Struct struct) throws MoAccessException, PrepareFailedException {
        int n;
        int n2;
        int n3 = this.getqciDistSinrXSum(struct, QCI_DIST_SINR_LOW);
        int n4 = n3 + (n2 = this.getqciDistSinrXSum(struct, QCI_DIST_SINR_MEDIUM)) + (n = this.getqciDistSinrXSum(struct, QCI_DIST_SINR_HIGH));
        if (n4 != 100) {
            String string = "The sum of qciDistSinrHigh [" + n + "], qciDistSinrMedium [" + n2 + "] and qciDistSinrLow [" + n3 + "] must be 100, but was [" + n4 + "]";
            this.logAndThrowPrepareFailedException(string);
        }
    }
}

