/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class UniqueExternalUtranCellFddRelationValidator
extends AbstractAttributeValidator {
    private static final String UTRAN_CELL_RELATION = "UtranCellRelation";
    private static final String RESERVED_BY = "reservedBy";
    private static final String UTRAN_FREQUENCY_REF = "utranFrequencyRef";
    private static final Class THIS_CLASS = UniqueExternalUtranCellFddRelationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public UniqueExternalUtranCellFddRelationValidator(String string) {
        super(THIS_CLASS.getName(), string, true, false, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        this.checkUniqueRefAndGrandParent(managedObject, coordinator);
        this.checkParentRef(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void checkParentRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkParentRef()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getParent().getAttribute(UTRAN_FREQUENCY_REF, coordinator);
        String string = managedObject2.getLocalDistinguishedName();
        ManagedObject managedObject3 = ((ManagedObject)managedObject.getAttribute(this.attributeName, coordinator)).getParent();
        String string2 = managedObject3.getLocalDistinguishedName();
        if (!string2.equals(string)) {
            String string3 = "The UtranCellRelation with LDN [" + managedObject.getLocalDistinguishedName() + "] can not be created due to a consistency check failure! The parent of the UtranCellRelation: [" + managedObject.getParent().getLocalDistinguishedName() + "] must have the same referenced MO: [" + string + "] as the referenced externalUtranCellFDD parent: [" + string2 + "]";
            this.logAndThrowPrepareFailedException(string3);
        }
        logger.traceReturn(THIS_CLASS, "checkParentRef()");
    }

    private void checkUniqueRefAndGrandParent(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkUniqueRefAndGrandParent()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(RESERVED_BY, coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            boolean bl;
            ManagedObject managedObject3 = managedObjectArray[i];
            logger.traceEnter(THIS_CLASS, "checkUniqueReferenceAndGrandParent()");
            String string = managedObject.getParent().getParent().getLocalDistinguishedName();
            boolean bl2 = managedObject3.getType().equals(managedObject.getType());
            boolean bl3 = managedObject3.getParent().getParent().getLocalDistinguishedName().equals(string);
            boolean bl4 = bl = managedObject.getLocalDistinguishedName() != managedObject3.getLocalDistinguishedName();
            if (!bl2 || !bl3 || !bl) continue;
            String string2 = "The UtranCellRelation with LDN [" + managedObject.getLocalDistinguishedName() + "] can not be created due to a consistency check failure! The MO with LDN=[" + managedObject2.getLocalDistinguishedName() + "] already has a reference from an " + UTRAN_CELL_RELATION + " which has the same cell:[" + string + "] as grandparent";
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "checkUniqueRefAndGrandParent()");
    }
}

