/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.AilgAndMbmsActivationCheckWrapper;
import se.ericsson.lte.rbs.omf.common.validator.MbmsOverlapAlgorithm;

public class UnlockMbsfnAreaValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = UnlockMbsfnAreaValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;

    public UnlockMbsfnAreaValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "UnlockMbsfnAreaValidator(attribute " + string + ")");
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, "UnlockMbsfnAreaValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        if (this.isAreaToBeUnlocked(managedObject, coordinator)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (AilgAndMbmsActivationCheckWrapper.getInstance().checkifAilgActivatedInAnyRelatedCells(managedObject, coordinator, stringBuffer)) {
                this.logAndThrowPrepareFailedException(stringBuffer.toString());
            }
            if (!this.areAllMchSchedulingPeriodsCorrectComparedToMcchModificationPeriod(managedObject, coordinator)) {
                this.logAndThrowPrepareFailedException("A PmchMch has an mchSchedulingPeriod that is larger then the MbsfnAreas mcchModificationPeriod.");
            }
            if (!this.areAllMchSchedulingPeriodsCorrectComparedToMcchRepetitionPeriod(managedObject, coordinator)) {
                this.logAndThrowPrepareFailedException("The PmchMch with the smallest sfAllocEnd has a mchSchedulingPeriod larger then the MbsfnAreas mcchRepetitionPeriod.");
            }
            if (!this.areAllMchSchedulingPeriodsCorrectComparedToCommonSfAllocPeriod(managedObject, coordinator)) {
                this.logAndThrowPrepareFailedException("A PmchMch has an mchSchedulingPeriod that is smaller then the commonSFAllocPeriod in the MbsfnAreas.");
            }
            if (!this.areAnySfAllocEndLargerThenTheNumberSubframesAllocatedByArea(managedObject, coordinator)) {
                this.logAndThrowPrepareFailedException("A PmchMch has an sfAllocEnd that is larger then the number of subframes allocated by the MbsfnAreas.");
            }
            MbmsOverlapAlgorithm mbmsOverlapAlgorithm = new MbmsOverlapAlgorithm();
            mbmsOverlapAlgorithm.runOverlapAlgorithm(managedObject, coordinator, this.genericMaoContext);
        }
    }

    private boolean areAllMchSchedulingPeriodsCorrectComparedToMcchModificationPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        int n = (Integer)managedObject.getAttribute("mcchModificationPeriod", coordinator);
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements() && bl) {
            int n2;
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!MoCheck.isMoReadable(managedObject2) || !managedObject2.getType().equals("PmchMch") || (n2 = ((Integer)managedObject2.getAttribute("mchSchedulingPeriod", coordinator)).intValue()) <= n) continue;
            bl = false;
        }
        return bl;
    }

    private boolean areAllMchSchedulingPeriodsCorrectComparedToMcchRepetitionPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        int n = (Integer)managedObject.getAttribute("mcchRepetitionPeriod", coordinator);
        boolean bl = true;
        boolean bl2 = true;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!MoCheck.isMoReadable(managedObject2) || !managedObject2.getType().equals("PmchMch") || (n2 = ((Integer)managedObject2.getAttribute("sfAllocEnd", coordinator)).intValue()) >= n3 && !bl) continue;
            n3 = n2;
            n4 = (Integer)managedObject2.getAttribute("mchSchedulingPeriod", coordinator);
            bl = false;
        }
        if (n4 > n) {
            bl2 = false;
        }
        return bl2;
    }

    private boolean areAllMchSchedulingPeriodsCorrectComparedToCommonSfAllocPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        int n = (Integer)managedObject.getAttribute("commonSFAllocPeriod", coordinator);
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements() && bl) {
            int n2;
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!MoCheck.isMoReadable(managedObject2) || !managedObject2.getType().equals("PmchMch") || n <= (n2 = ((Integer)managedObject2.getAttribute("mchSchedulingPeriod", coordinator)).intValue())) continue;
            bl = false;
        }
        return bl;
    }

    private boolean areAnySfAllocEndLargerThenTheNumberSubframesAllocatedByArea(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        int n = this.getNoOfSubframesForTheMbsfnArea(managedObject, coordinator);
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements() && bl) {
            int n2;
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!MoCheck.isMoReadable(managedObject2) || !managedObject2.getType().equals("PmchMch") || (n2 = ((Integer)managedObject2.getAttribute("sfAllocEnd", coordinator)).intValue()) <= n) continue;
            bl = false;
        }
        return bl;
    }

    private int getNoOfSubframesForTheMbsfnArea(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        int n = (Integer)managedObject.getAttribute("commonSFAllocPeriod", coordinator);
        int n2 = -1;
        int n3 = -1;
        String string = "";
        String string2 = "";
        Struct struct = (Struct)managedObject.getAttribute("commonSFAlloc", coordinator);
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("radioframeAllocationPeriod")) {
                n2 = (Integer)struct.getValue("radioframeAllocationPeriod");
                continue;
            }
            if (stringArray[i].equals("subframeAllocation")) {
                n3 = (Integer)struct.getValue("subframeAllocation");
                continue;
            }
            if (stringArray[i].equals("subframeAllocationFourFrame")) {
                string = (String)struct.getValue("subframeAllocationFourFrame");
                continue;
            }
            if (!stringArray[i].equals("subframeAllocationOneFrame")) continue;
            string2 = (String)struct.getValue("subframeAllocationOneFrame");
        }
        String string3 = string2;
        if (n3 == 4) {
            string3 = string;
        }
        int n4 = this.getNoOfOnesInString(string3);
        int n5 = n / n2 * n4 - 1;
        return n5;
    }

    private int getNoOfOnesInString(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '1') continue;
            ++n;
        }
        return n;
    }

    private boolean isAreaToBeUnlocked(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        boolean bl = false;
        int n = (Integer)managedObject.getAttribute("administrativeState", null);
        int n2 = (Integer)managedObject.getAttribute("administrativeState", coordinator);
        if (n == 0 && n2 == 1) {
            bl = true;
        }
        return bl;
    }
}

