/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroIdFinder;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.lte.rbs.omf.common.xml.XmlPack;

public class XmlPackImpl
implements XmlPack {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = XmlPackImpl.class;
    protected final DocumentBuilder builder;

    public XmlPackImpl() {
        logger.traceEnter(THIS_CLASS, "PnpXmlPackImpl()");
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.traceError(THIS_CLASS, "Document Builder could not be created: " + parserConfigurationException.getMessage());
        }
        this.builder = documentBuilder;
        logger.traceReturn(THIS_CLASS, "PnpXmlPackImpl()");
    }

    public Document createDocument() {
        return this.builder.newDocument();
    }

    public final String packArray(String string, Object[] objectArray) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packArray()");
        Document document = this.createDocument();
        Element element = this.packArray(string, objectArray, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packArray()");
        return string2;
    }

    public final Element packArray(String string, Object[] objectArray, Document document) throws IllegalParameterValueException {
        Element element = document.createElement("array");
        if (string != null) {
            element.setAttribute("name", string);
        }
        List<Object> list = Arrays.asList(objectArray);
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) {
                element.appendChild(this.packArrayEntry(new NullManagedObject(), document));
                continue;
            }
            element.appendChild(this.packArrayEntry(object, document));
        }
        return element;
    }

    public final String packBoolean(String string, boolean bl) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packBoolean()");
        Document document = this.createDocument();
        Element element = this.packBoolean(string, bl ? Boolean.TRUE : Boolean.FALSE, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packBoolean()");
        return string2;
    }

    public final Element packBoolean(String string, Object object, Document document) {
        Element element = document.createElement("attr");
        if (string != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("type", "boolean");
        element.setAttribute("value", object.toString());
        return element;
    }

    public final String packBooleanArray(String string, boolean[] blArray) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packBooleanArray()");
        Document document = this.createDocument();
        Element element = this.packBooleanArray(string, blArray, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packBooleanArray()");
        return string2;
    }

    public final Element packBooleanArray(String string, boolean[] blArray, Document document) {
        Element element = document.createElement("array");
        if (string != null) {
            element.setAttribute("name", string);
        }
        for (int i = 0; i < blArray.length; ++i) {
            Element element2 = document.createElement("attr");
            element2.setAttribute("type", "boolean");
            element2.setAttribute("value", Boolean.valueOf(blArray[i]).toString());
            element.appendChild(element2);
        }
        return element;
    }

    public final String packInt(String string, int n) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packInt()");
        Document document = this.createDocument();
        Element element = this.packInt(string, new Integer(n), document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packInt()");
        return string2;
    }

    public final Element packInt(String string, Object object, Document document) {
        Element element = document.createElement("attr");
        if (string != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("type", "s32");
        element.setAttribute("value", object.toString());
        return element;
    }

    public final String packIntArray(String string, int[] nArray) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packIntArray()");
        Document document = this.createDocument();
        Element element = this.packIntArray(string, nArray, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packIntArray()");
        return string2;
    }

    public final Element packIntArray(String string, int[] nArray, Document document) {
        Element element = document.createElement("array");
        if (string != null) {
            element.setAttribute("name", string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Element element2 = document.createElement("attr");
            element2.setAttribute("type", "s32");
            element2.setAttribute("value", Integer.toString(nArray[i]));
            element.appendChild(element2);
        }
        return element;
    }

    public final String packLong(String string, long l) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packLong()");
        Document document = this.createDocument();
        Element element = this.packLong(string, new Long(l), document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packLong()");
        return string2;
    }

    public final Element packLong(String string, Object object, Document document) {
        Element element = document.createElement("attr");
        if (string != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("type", "s64");
        element.setAttribute("value", object.toString());
        return element;
    }

    public final String packLongArray(String string, long[] lArray) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packLongArray()");
        Document document = this.createDocument();
        Element element = this.packLongArray(string, lArray, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packLongArray()");
        return string2;
    }

    public final Element packLongArray(String string, long[] lArray, Document document) {
        Element element = document.createElement("array");
        if (string != null) {
            element.setAttribute("name", string);
        }
        for (int i = 0; i < lArray.length; ++i) {
            Element element2 = document.createElement("attr");
            element2.setAttribute("type", "s64");
            element2.setAttribute("value", Long.toString(lArray[i]));
            element.appendChild(element2);
        }
        return element;
    }

    public final String packManagedObject(String string, ManagedObject managedObject) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packManagedObject()");
        Document document = this.createDocument();
        Element element = this.packManagedObject(string, managedObject, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packManagedObject()");
        return string2;
    }

    public final Element packManagedObject(String string, ManagedObject managedObject, Document document) throws IllegalParameterValueException {
        Element element = document.createElement("moref");
        element.setAttribute("name", string);
        if (managedObject == null) {
            element.appendChild(this.packParameter("ldn", "", document));
            element.appendChild(this.packParameter("froType", new Integer(-1), document));
            element.appendChild(this.packParameter("froId", new Integer(-1), document));
        } else {
            element.appendChild(this.packParameter("ldn", managedObject.getLocalDistinguishedName(), document));
            try {
                Integer n = new Integer(FroIdFinder.getManagedObjectFroType((ManagedObject)managedObject, null));
                element.appendChild(this.packParameter("froType", n, document));
                Integer n2 = new Integer(FroIdFinder.getManagedObjectFroId((ManagedObject)managedObject, null));
                element.appendChild(this.packParameter("froId", n2, document));
            }
            catch (MoAccessException moAccessException) {
                logger.traceDebug(THIS_CLASS, moAccessException.getMessage());
                logger.traceDebugStackTrace(THIS_CLASS, (Throwable)moAccessException);
                throw new IllegalParameterValueException(moAccessException.getMessage());
            }
        }
        return element;
    }

    public final Element packParameter(String string, Object object, Document document) throws IllegalParameterValueException {
        Element element = object == null ? this.handleNullValue(string, document) : this.handleNonNullValue(string, object, document);
        return element;
    }

    public final String packStruct(String string, Struct struct) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packStruct()");
        Document document = this.createDocument();
        Element element = this.packStruct(string, struct, document);
        document.appendChild(element);
        String string2 = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, string2);
        logger.traceReturn(THIS_CLASS, "packStruct()");
        return string2;
    }

    public final Element packStruct(String string, Struct struct, Document document) throws IllegalParameterValueException {
        Element element = document.createElement("struct");
        if (string != null) {
            element.setAttribute("name", string);
        }
        String[] stringArray = struct.getNames();
        try {
            Object[] objectArray = struct.getValues();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Object object = objectArray[i];
                element.appendChild(this.packParameter(string2, object, document));
            }
        }
        catch (NotHandledAttributeTypeException notHandledAttributeTypeException) {
            logger.traceError(THIS_CLASS, "Error in packStruct()", (Throwable)notHandledAttributeTypeException);
        }
        catch (MoNotFoundException moNotFoundException) {
            logger.traceError(THIS_CLASS, "Error in packStruct()", (Throwable)moNotFoundException);
        }
        return element;
    }

    public final Element packString(String string, Object object, Document document) {
        Element element = document.createElement("attr");
        if (string != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("type", "string");
        element.setAttribute("value", object.toString());
        return element;
    }

    public final String transformDocument(Document document) throws SoftwareErrorException {
        return this.transformDocument(document, true);
    }

    public final String transformDocument(Document document, boolean bl) throws SoftwareErrorException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", bl);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(bl);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        try {
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            logger.traceError(THIS_CLASS, "Error while transforming document: " + iOException.getMessage());
            throw new SoftwareErrorException((Throwable)iOException);
        }
        try {
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            logger.traceError(THIS_CLASS, "Stream error: " + iOException.getMessage());
            throw new SoftwareErrorException((Throwable)iOException);
        }
        return string;
    }

    protected final Element packArrayEntry(Object object, Document document) throws IllegalParameterValueException {
        return this.packParameter(null, object, document);
    }

    private Element handleNonNullValue(String string, Object object, Document document) throws IllegalParameterValueException {
        Element element = object instanceof Struct ? this.packStruct(string, (Struct)object, document) : (object instanceof int[] ? this.packIntArray(string, (int[])object, document) : (object instanceof long[] ? this.packLongArray(string, (long[])object, document) : (object instanceof boolean[] ? this.packBooleanArray(string, (boolean[])object, document) : (object.getClass().isArray() ? this.packArray(string, (Object[])object, document) : (object instanceof ManagedObject ? this.packManagedObject(string, (ManagedObject)object, document) : this.packPrimitiveParameter(string, object, document))))));
        return element;
    }

    private Element handleNullValue(String string, Document document) throws IllegalParameterValueException {
        if (!string.endsWith("Ref") && string.indexOf("RefPrio") == -1) {
            throw new IllegalParameterValueException("NULL value not permitted in parameter. Parameter = " + string + ".");
        }
        Element element = this.packManagedObject(string, null, document);
        return element;
    }

    protected final Element packPrimitiveParameter(String string, Object object, Document document) {
        Element element = this.isValueNullAndNameIndicatesRef(string, object) ? this.packString(string, "", document) : (object instanceof String ? this.packString(string, object, document) : (object instanceof Integer ? this.packInt(string, object, document) : (object instanceof Boolean ? this.packBoolean(string, object.toString(), document) : (object instanceof Long ? this.packLong(string, object, document) : (object instanceof Float ? this.packInt(string, object, document) : null)))));
        return element;
    }

    private boolean isValueNullAndNameIndicatesRef(String string, Object object) {
        return object == null && string.endsWith("Ref");
    }
}

