/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.glms.common;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.lte.rbs.omf.glms.common.GlmsSubscriber;

public class GlmsSubscriptionHandler
implements AvcSubscriber {
    private transient boolean avcSubscriptionStarted = false;
    private static final Class THIS_CLASS = GlmsSubscriptionHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final GlmsSubscriptionHandler instance = new GlmsSubscriptionHandler();
    private static final Map subscriberMap = new HashMap();

    private GlmsSubscriptionHandler() {
    }

    public static GlmsSubscriptionHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeForAvcUpdate(GlmsSubscriber glmsSubscriber, String string, String string2, String[] stringArray) {
        logger.traceEnter(THIS_CLASS, "AVC Subscription request for " + string2);
        subscriberMap.put(string2, glmsSubscriber);
        GlmsSubscriptionHandler glmsSubscriptionHandler = this;
        synchronized (glmsSubscriptionHandler) {
            if (!this.avcSubscriptionStarted) {
                String[] stringArray2 = stringArray;
                for (int i = 0; i < stringArray2.length; ++i) {
                    AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, stringArray2[i]);
                }
                this.avcSubscriptionStarted = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "AVC Subscription request for " + string2);
    }

    private GlmsSubscriber getCurrentSubscriber(String string) {
        GlmsSubscriber glmsSubscriber = (GlmsSubscriber)subscriberMap.get(string);
        return glmsSubscriber;
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc ldn=" + string + ", attributeName=" + string2);
        GlmsSubscriber glmsSubscriber = this.getCurrentSubscriber(string);
        if (glmsSubscriber != null) {
            glmsSubscriber.reportGlmsAvc(string, string2, object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportAvc ldn=" + string + ", attributeName=" + string2);
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
    }
}

