/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.capacityoutputpower;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.mao.capacityoutputpower.CapacityOutputPowerMao;

public class CapacityOutputPowerMaoImpl
extends AbstractGenericAttributeValidatorMao
implements CapacityOutputPowerMao {
    private static final Class THIS_CLASS = CapacityOutputPowerMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String CAPACITY_UNIT_OUTPUT_POWER = "capacityUnitOutputPower";
    public static final String KEY_ID_OUTPUT_POWER = "keyIdOutputPower";
    public static final String LICENSE_CAPACITY_OUTPUT_POWER = "licenseCapacityOutputPower";
    public static final String LICENSE_STATE_OUTPUT_POWER = "licenseStateOutputPower";

    public CapacityOutputPowerMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, "CapacityOutputPower", genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public CapacityOutputPowerMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    public final Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        Object object;
        logger.traceEnter(THIS_CLASS, "getAttribute()");
        String string2 = super.getRdnId(coordinator);
        logger.traceGeneral(THIS_CLASS, "getAttribute called on rdn: " + string2 + "for attribute: " + string);
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,SystemFunctions=1,Licensing=1,CapacityFeatureLicense=" + this.getNewRdnId(string2));
        if (managedObject == null) {
            logger.traceAbnormal(THIS_CLASS, "Did not find capacityFeatureLicenseMO with rdn: " + this.getNewRdnId(string2));
            throw new MoNotFoundException("capacityFeatureLicenseMO for capacityUnitOutputPower in GLMS not yet started");
        }
        if (CAPACITY_UNIT_OUTPUT_POWER.equals(string)) {
            object = managedObject.getAttribute("capacityUnit", coordinator);
        } else if (KEY_ID_OUTPUT_POWER.equals(string)) {
            object = managedObject.getAttribute("keyId", coordinator);
        } else if (LICENSE_CAPACITY_OUTPUT_POWER.equals(string)) {
            Struct struct = (Struct)managedObject.getAttribute("licensedCapacity", coordinator);
            object = struct.getValue("value");
        } else {
            object = LICENSE_STATE_OUTPUT_POWER.equals(string) ? managedObject.getAttribute("licenseState", coordinator) : super.getAttribute(string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttribute()");
        return object;
    }

    private String getNewRdnId(String string) {
        int n = Integer.parseInt(string.substring(0, string.length() - 4));
        return "OutputPower" + (n - 20) + "WTo" + n + "W";
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.preGetAttributes(stringArray, coordinator);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = CAPACITY_UNIT_OUTPUT_POWER.equals(stringArray[i]) || KEY_ID_OUTPUT_POWER.equals(stringArray[i]) || LICENSE_CAPACITY_OUTPUT_POWER.equals(stringArray[i]) || LICENSE_STATE_OUTPUT_POWER.equals(stringArray[i]) ? this.getAttribute(stringArray[i], coordinator) : super.getAttribute(stringArray[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return objectArray;
    }

    protected void registerValidators() {
    }
}

