/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.enodebfunction;

import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMaoImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;

public class RbsConfigurationDeprecatedMaoImpl
extends ManagedObjectBase
implements AvcSubscriber {
    public static final String ENODEBFUNCTION_LDN = "ManagedElement=1,ENodeBFunction=1";
    public static final String NODEMANAGEMENTFUNCTION_LDN = "ManagedElement=1,NodeManagementFunction=1";
    public static final String REAL_RBSCONFIGURATION_LDN = "ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1";
    public static final String RBSCONFIGURATION_MOTYPE = "RbsConfiguration";
    private static final Class THIS_CLASS = RbsConfigurationDeprecatedMaoImpl.class;
    private final AbstractLogger logger = LoggingService.getLogger((String)((Object)((Object)this)).getClass().getName());
    private final GenericMaoContext genericMaoContext;
    private RbsConfigurationMaoImpl realMo;

    public RbsConfigurationDeprecatedMaoImpl(ManagedObject managedObject, String string, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, GenericMaoContext genericMaoContext) throws MoNameAlreadyTakenException {
        super(managedObject, string, string2, coordinator, initialMaoContext);
        this.genericMaoContext = genericMaoContext;
        MoWaiter moWaiter = new MoWaiter(initialMaoContext);
        new Thread((Runnable)moWaiter, "moWaiterRbsConfiguration").start();
    }

    public RbsConfigurationDeprecatedMaoImpl(String string, InitialMaoContext initialMaoContext, GenericMaoContext genericMaoContext) throws MoNameAlreadyTakenException {
        super(string, initialMaoContext);
        this.genericMaoContext = genericMaoContext;
        MoWaiter moWaiter = new MoWaiter(initialMaoContext);
        new Thread((Runnable)moWaiter, "moWaiterRbsConfiguration").start();
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.logger.traceEnter(THIS_CLASS, "getAttribute(attributeName[" + string + "])");
        this.checkIsRbsConfMoSet("getAttribute");
        Object object = this.realMo.getAttribute(string, coordinator);
        this.logger.traceReturn(THIS_CLASS, "getAttribute(returnValue[" + object + "])");
        return object;
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.checkIsRbsConfMoSet("getAttributes");
        Object[] objectArray = this.realMo.getAttributes(stringArray, coordinator);
        this.logger.traceReturn(THIS_CLASS, "getAttributes()");
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "setAttribute(setAttribute[" + string + "], value[" + object + "])");
        this.checkIsRbsConfMoSet("setAttribute");
        this.realMo.setAttribute(string, object, coordinator);
        this.logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "setAttributes()");
        this.checkIsRbsConfMoSet("setAttributes");
        this.realMo.setAttributes(stringArray, objectArray, coordinator);
        this.logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    public void actionCancelRbsIntegration(Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionCancelRbsIntegration()");
        this.checkIsRbsConfMoSet("actionCancelRbsIntegration");
        this.realMo.actionCancelRbsIntegration(coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionCancelRbsIntegration()");
    }

    public void actionChangeIpForOamSetting(String string, String string2, String string3, String string4, String string5, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionChangeIpForOamSetting()");
        this.checkIsRbsConfMoSet("actionChangeIpForOamSetting");
        this.realMo.actionChangeIpForOamSetting(string, string2, string3, string4, string5, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionChangeIpForOamSetting()");
    }

    public void actionModifyConfiguration(String string, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionModifyConfiguration()");
        this.checkIsRbsConfMoSet("actionModifyConfiguration");
        this.realMo.actionModifyConfiguration(string, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionModifyConfiguration()");
    }

    public void actionSetUniqueLogicalName(String string, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionSetUniqueLogicalName()");
        this.checkIsRbsConfMoSet("actionSetUniqueLogicalName");
        this.realMo.actionSetUniqueLogicalName(string, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionSetUniqueLogicalName()");
    }

    public void actionStartProductionTestConfiguration(String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionStartProductionTestConfiguration()");
        this.checkIsRbsConfMoSet("actionStartProductionTestConfiguration");
        this.realMo.actionStartProductionTestConfiguration(string, string2, string3, string4, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionStartProductionTestConfiguration()");
    }

    public void actionStartRbsIntegration(String string, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionStartRbsIntegration()");
        this.checkIsRbsConfMoSet("actionStartRbsIntegration");
        this.realMo.actionStartRbsIntegration(string, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionStartRbsIntegration()");
    }

    public void actionStoreConfigurationReport(String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionStoreConfigurationReport()");
        this.checkIsRbsConfMoSet("actionStoreConfigurationReport");
        this.realMo.actionStoreConfigurationReport(string, string2, string3, string4, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionStoreConfigurationReport()");
    }

    public void actionUpdateRbsIntegrationParameters(String string, Coordinator coordinator) throws MoAccessException {
        this.logger.traceEnter(THIS_CLASS, "actionUpdateRbsIntegrationParameters()");
        this.checkIsRbsConfMoSet("actionUpdateRbsIntegrationParameters");
        this.realMo.actionUpdateRbsIntegrationParameters(string, coordinator);
        this.logger.traceReturn(THIS_CLASS, "actionUpdateRbsIntegrationParameters()");
    }

    private void checkIsRbsConfMoSet(String string) throws MoAccessException {
        if (this.realMo == null) {
            String string2 = "RbsConfiguration MO is not set, can not do action: " + string;
            this.logger.traceError(THIS_CLASS, string2);
            throw new MoAccessException(string2){};
        }
    }

    protected void setRealMo(RbsConfigurationMaoImpl rbsConfigurationMaoImpl) {
        this.realMo = rbsConfigurationMaoImpl;
    }

    protected void startAvcSubscriptions() {
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "configFaultReason");
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "dhcpClientIdentifier");
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "ossCorbaNameServiceAddress");
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "progressInformation");
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "progressLevel");
        this.registerForAVCNotifications(RBSCONFIGURATION_MOTYPE, "rbsConfigLevel");
    }

    private void registerForAVCNotifications(String string, String string2) {
        this.logger.traceEnter(THIS_CLASS, "registerForAVCNotifications(motype[" + string + "], attributeName[" + string2 + "])");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, string2);
        this.logger.traceReturn(THIS_CLASS, "registerForAVCNotifications()");
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        if (string.equals(REAL_RBSCONFIGURATION_LDN)) {
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, new String[]{string2}, new Object[]{this.convertAvcReportValue(object)});
        }
    }

    protected Object convertAvcReportValue(Object object) {
        this.logger.traceEnter(THIS_CLASS, "convertAvcReportValue()");
        Object object2 = object;
        if (object instanceof Struct) {
            this.logger.traceDebug(THIS_CLASS, "Attribute is a neal.cm.Struct, will convert to regular struct instance");
            Struct struct = (Struct)object;
            String[] stringArray = new String[struct.getSize()];
            Object[] objectArray = new Object[struct.getSize()];
            NameValue[] nameValueArray = struct.getNameValueArray();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = nameValueArray[i].getName();
                objectArray[i] = nameValueArray[i].getValue();
                this.logger.traceDebug(THIS_CLASS, "Adding entry name[" + stringArray[i] + "], value[" + objectArray[i] + "]");
            }
            object2 = new StructImpl(stringArray, objectArray);
        }
        this.logger.traceReturn(THIS_CLASS, "convertAvcReportValue()");
        return object2;
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
    }

    class MoWaiter
    implements Runnable {
        private final InitialMaoContext initialmaocontext;

        public MoWaiter(InitialMaoContext initialMaoContext) {
            this.initialmaocontext = initialMaoContext;
        }

        public void run() {
            RbsConfigurationMaoImpl rbsConfigurationMaoImpl;
            ManagedObject managedObject;
            while (true) {
                managedObject = this.initialmaocontext.getMoAccessor().lookup(RbsConfigurationDeprecatedMaoImpl.ENODEBFUNCTION_LDN);
                rbsConfigurationMaoImpl = (RbsConfigurationMaoImpl)this.initialmaocontext.getMoAccessor().lookup(RbsConfigurationDeprecatedMaoImpl.REAL_RBSCONFIGURATION_LDN);
                boolean bl = managedObject != null;
                boolean bl2 = rbsConfigurationMaoImpl != null;
                RbsConfigurationDeprecatedMaoImpl.this.logger.traceDebug(THIS_CLASS, "ENodeBFunction Mo is found: " + bl);
                RbsConfigurationDeprecatedMaoImpl.this.logger.traceDebug(THIS_CLASS, "RbsConfiguration Mo is found: " + bl2);
                if (bl && bl2) break;
                try {
                    RbsConfigurationDeprecatedMaoImpl.this.logger.traceDebug(THIS_CLASS, "Not ready to setup AVC subscriptions, will wait for 1 sec and retry");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            RbsConfigurationDeprecatedMaoImpl.this.logger.traceDebug(THIS_CLASS, "Will start AVC subscriptions");
            managedObject.addChild((ManagedObject)RbsConfigurationDeprecatedMaoImpl.this);
            RbsConfigurationDeprecatedMaoImpl.this.setRealMo(rbsConfigurationMaoImpl);
            RbsConfigurationDeprecatedMaoImpl.this.startAvcSubscriptions();
        }
    }
}

