/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.eutrancellfdd;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.validator.CellNotUsedByMbmsValidator;
import se.ericsson.lte.rbs.omf.common.validator.CommonSrPeriodicityVsDlChannelBandwidthValidator;
import se.ericsson.lte.rbs.omf.common.validator.EarfcnDlUlRangeValidator;
import se.ericsson.lte.rbs.omf.common.validator.EarfcnGenericAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.FirstAttrLessThanSecondAttrValidator;
import se.ericsson.lte.rbs.omf.common.validator.LimitMaxNoOfPagingRecordsValidator;
import se.ericsson.lte.rbs.omf.common.validator.SameValueDifferentAttributesValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.AbstractEUtranCellMaoImplBase;

public class EUtranCellFDDMaoImpl
extends AbstractEUtranCellMaoImplBase {
    private static final Class THIS_CLASS = EUtranCellFDDMaoImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE = "EUtranCellFDD";
    public static final String ATTRIBUTE_EARFCNDL = "earfcndl";
    public static final String ATTRIBUTE_EARFCNUL = "earfcnul";
    public static final String ATTRIBUTE_COMMON_SR_PERIODICITY = "commonSrPeriodicity";
    public static final String ATTRIBUTE_DL_CHANNEL_BANDWIDTH = "dlChannelBandwidth";
    public static final String ATTRIBUTE_UL_CHANNEL_BANDWIDTH = "ulChannelBandwidth";
    public static final String ATTRIBUTE_CELL_CAP_MIN_CELL_SUB_CAP = "cellCapMinCellSubCap";
    public static final String ATTRIBUTE_CELL_CAP_MAX_CELL_SUB_CAP = "cellCapMaxCellSubCap";

    public EUtranCellFDDMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException, ProcessingFailureException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellFDDMaoImpl()");
        logger.traceReturn(THIS_CLASS, "EUtranCellFDDMaoImpl()");
    }

    public EUtranCellFDDMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellFDDMaoImpl()");
        logger.traceReturn(THIS_CLASS, "EUtranCellFDDMaoImpl()");
    }

    public void actionChangeFrequency(Integer n, Coordinator coordinator) throws ChangeFrequencyException {
        try {
            if (n >= 0 && n <= 9659 || n >= 9920 && n <= 17999) {
                this.setRestrictedAttribute(ATTRIBUTE_EARFCNUL, new Integer(n + 18000), coordinator);
            } else if (n >= 9660 && n <= 9769) {
                this.setRestrictedAttribute(ATTRIBUTE_EARFCNUL, new Integer(n + 18000), coordinator);
            } else if (n >= 9770 && n <= 9919) {
                this.setRestrictedAttribute(ATTRIBUTE_EARFCNUL, new Integer(n + 17890), coordinator);
            } else if (n >= 46590 && n <= 65535) {
                this.setRestrictedAttribute(ATTRIBUTE_EARFCNUL, new Integer(n), coordinator);
            }
        }
        catch (Exception exception) {
            String string = ExceptionHelper.appendReason((String)"Unable to perform action changeFrequency due to: ", (Throwable)exception);
            logger.info(THIS_CLASS, string);
            throw new ChangeFrequencyException(string);
        }
        super.actionChangeFrequency(n, coordinator);
    }

    public String getDownlinkFrequencyAttrName() {
        return ATTRIBUTE_EARFCNDL;
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        super.registerValidators();
        this.registerValidator(ATTRIBUTE_EARFCNDL, new EarfcnDlUlRangeValidator(ATTRIBUTE_EARFCNDL, this.genericMaoContext));
        this.registerValidator(ATTRIBUTE_EARFCNDL, new EarfcnGenericAttributeValidator(ATTRIBUTE_EARFCNDL, MO_TYPE, this.genericMaoContext));
        this.registerValidator(ATTRIBUTE_EARFCNUL, new EarfcnDlUlRangeValidator(ATTRIBUTE_EARFCNUL, this.genericMaoContext));
        this.registerValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, new CommonSrPeriodicityVsDlChannelBandwidthValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH));
        this.registerValidator(ATTRIBUTE_COMMON_SR_PERIODICITY, new CommonSrPeriodicityVsDlChannelBandwidthValidator(ATTRIBUTE_COMMON_SR_PERIODICITY));
        this.registerValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, new SameValueDifferentAttributesValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, ATTRIBUTE_UL_CHANNEL_BANDWIDTH));
        this.registerValidator(ATTRIBUTE_UL_CHANNEL_BANDWIDTH, new SameValueDifferentAttributesValidator(ATTRIBUTE_UL_CHANNEL_BANDWIDTH, ATTRIBUTE_DL_CHANNEL_BANDWIDTH));
        this.registerValidator("noConsecutiveSubframes", new CellNotUsedByMbmsValidator("noConsecutiveSubframes"));
        this.registerValidator("prsPeriod", new CellNotUsedByMbmsValidator("prsPeriod"));
        this.registerValidator("prsConfigIndex", new CellNotUsedByMbmsValidator("prsConfigIndex"));
        this.registerValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, new CellNotUsedByMbmsValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH));
        this.registerValidator(ATTRIBUTE_EARFCNDL, new CellNotUsedByMbmsValidator(ATTRIBUTE_EARFCNDL));
        this.registerValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, new LimitMaxNoOfPagingRecordsValidator(ATTRIBUTE_DL_CHANNEL_BANDWIDTH, this.genericMaoContext));
        this.registerValidator(ATTRIBUTE_CELL_CAP_MIN_CELL_SUB_CAP, new FirstAttrLessThanSecondAttrValidator("", ATTRIBUTE_CELL_CAP_MIN_CELL_SUB_CAP, ATTRIBUTE_CELL_CAP_MAX_CELL_SUB_CAP, false));
        this.registerValidator(ATTRIBUTE_CELL_CAP_MAX_CELL_SUB_CAP, new FirstAttrLessThanSecondAttrValidator("", ATTRIBUTE_CELL_CAP_MIN_CELL_SUB_CAP, ATTRIBUTE_CELL_CAP_MAX_CELL_SUB_CAP, false));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }
}

