/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.externalgerancell;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.ExternalGeranCellChangeFrequencyValidator;
import se.ericsson.lte.rbs.omf.common.validator.OnlyRegistrationValidator;
import se.ericsson.lte.rbs.omf.common.validator.SetAttributeToNullValueValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueCombinationDeprecatedValidator;
import se.ericsson.lte.rbs.omf.mao.externalgerancell.DeprecatedExternalGeranCellWrapper;
import se.ericsson.lte.rbs.omf.mao.externalgerancell.ExternalGeranCellDeprecatedMaoImpl;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.UseDeprecatedStructureChecker;

public class ExternalGeranCellMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final String BAND_INDICATOR = "bandIndicator";
    private static final String ARFCN_VALUE_GERAN_DL = "arfcnValueGeranDl";
    private static final String LAC = "lac";
    private static final String CELL_IDENTITY = "cellIdentity";
    private static final String PLMN_IDENTITY = "plmnIdentity";
    public static final String GERAN_FREQUENCY_REF_ATTR = "geranFrequencyRef";
    protected static final String MO_TYPE = "ExternalGeranCell";
    private static final Class THIS_CLASS = ExternalGeranCellMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ExternalGeranCellMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(ExternalGeranCellDeprecatedMaoImpl.getCorrectParent(managedObject, initialMaoContext), attrList, ExternalGeranCellDeprecatedMaoImpl.getCorrectId(managedObject, string, coordinator), MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor ExternalGeranCellMaoImpl()");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_IRAT_OPERATOR, AttributeUtilities.LAST_MODIFICATION_GERAN_NOT_MODIFIED, coordinator);
        if (ExternalGeranCellDeprecatedMaoImpl.inOldStructure(managedObject)) {
            logger.traceDebug(THIS_CLASS, "Creating stub MO");
            DeprecatedExternalGeranCellWrapper.getInstance().createDeprecatedExternalGeranCell(managedObject, string, coordinator, initialMaoContext, genericMaoContext, (ManagedObject)this);
            ManagedObject managedObject2 = ExternalGeranCellDeprecatedMaoImpl.getCorrectFrequencyRef(managedObject.getLocalDistinguishedName(), initialMaoContext);
            super.setRestrictedAttribute(GERAN_FREQUENCY_REF_ATTR, (Object)managedObject2, coordinator);
        } else if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
        logger.traceReturn(THIS_CLASS, "Constructor ExternalGeranCellMaoImpl()");
    }

    public ExternalGeranCellMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor ExternalGeranCellMaoImpl(recover)");
        logger.traceReturn(THIS_CLASS, "Constructor ExternalGeranCellMaoImpl(recover)");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_GERAN_OPERATOR_MODIFICATION, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    public void actionChangeFrequency(Integer n, Integer n2, Coordinator coordinator) throws ChangeFrequencyException {
        try {
            logger.traceEnter(THIS_CLASS, "actionChangeFrequency(" + n + " , " + n2 + ")");
            if (this.frequencyOrBandIndicatorChanged(n, n2, coordinator)) {
                ManagedObject managedObject = this.getGeranFrequency(n, n2, coordinator);
                if (managedObject == null) {
                    String string = "GeranFrequency with arfcnValueGeranDl:" + n.toString() + " and bandIndicator: " + n2.toString() + " does not exist!";
                    throw new ChangeFrequencyException(string);
                }
                this.setRestrictedAttribute(GERAN_FREQUENCY_REF_ATTR, managedObject, coordinator);
            }
            logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
        }
        catch (MoAccessException moAccessException) {
            throw new ChangeFrequencyException(moAccessException.toString());
        }
    }

    public void postRecover() throws TransactionRequiredException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postRecover()");
        if (UseDeprecatedStructureChecker.getInstance().useDeprecation() && ExternalGeranCellDeprecatedMaoImpl.isUpgradedFromOldStructure((ManagedObject)this)) {
            String string = this.getLocalDistinguishedName();
            String string2 = ExternalGeranCellDeprecatedMaoImpl.getLdnOfDeprecatedMo(string);
            logger.traceDebug(THIS_CLASS, "Creating stub MO with LDN: " + string2);
            DeprecatedExternalGeranCellWrapper.getInstance().createDeprecatedExternalGeranCell(string2, (InitialMaoContext)this.getMaoContext(), this.genericMaoContext, (ManagedObject)this);
        }
        logger.traceReturn(THIS_CLASS, "postRecover()");
        super.postRecover();
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete()");
        super.delete(coordinator);
        this.handleDeprecationAtDelete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    protected void deleteFromProxy(Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        super.delete(coordinator);
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_OPERATOR);
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.checkStopUsingDeprecatedStructure(string);
        super.setAttribute(string, object, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.checkStopUsingDeprecatedStructure(stringArray[i]);
        }
        super.setAttributes(stringArray, objectArray, coordinator);
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "registerValidators()");
        String[] stringArray = new String[]{PLMN_IDENTITY, CELL_IDENTITY, LAC};
        this.registerValidator(PLMN_IDENTITY, new UniqueCombinationDeprecatedValidator(PLMN_IDENTITY, stringArray, new String[]{MO_TYPE}, this.genericMaoContext));
        this.registerValidator(CELL_IDENTITY, new OnlyRegistrationValidator(CELL_IDENTITY));
        this.registerValidator(LAC, new OnlyRegistrationValidator(LAC));
        this.registerValidator(GERAN_FREQUENCY_REF_ATTR, new ExternalGeranCellChangeFrequencyValidator(GERAN_FREQUENCY_REF_ATTR));
        this.registerValidator(GERAN_FREQUENCY_REF_ATTR, new SetAttributeToNullValueValidator(GERAN_FREQUENCY_REF_ATTR));
        logger.traceReturn(THIS_CLASS, "registerValidators()");
    }

    private boolean frequencyOrBandIndicatorChanged(Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        ManagedObject managedObject = (ManagedObject)this.getAttribute(GERAN_FREQUENCY_REF_ATTR, coordinator);
        Integer n3 = null;
        Integer n4 = null;
        if (null == managedObject) {
            bl = true;
        } else {
            n3 = (Integer)managedObject.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator);
            n4 = (Integer)managedObject.getAttribute(BAND_INDICATOR, coordinator);
            if (!n.equals(n3) || !n2.equals(n4)) {
                bl = true;
            }
        }
        return bl;
    }

    private ManagedObject getGeranFrequency(Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        boolean bl;
        ManagedObject managedObject = null;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("GeranFrequency");
        boolean bl2 = bl = n >= 512 && n <= 810;
        while (moIterator.hasMoreElements() && managedObject == null) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!managedObject2.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator).equals(n) || bl && !managedObject2.getAttribute(BAND_INDICATOR, coordinator).equals(n2)) continue;
            managedObject = managedObject2;
        }
        return managedObject;
    }

    private void handleDeprecationAtDelete(Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        String string = this.getLocalDistinguishedName();
        if (ExternalGeranCellDeprecatedMaoImpl.isUpgradedFromOldStructure((ManagedObject)this)) {
            String string2 = ExternalGeranCellDeprecatedMaoImpl.getLdnOfDeprecatedMo(string);
            logger.traceDebug(THIS_CLASS, "Looking for: " + string2);
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string2);
            if (managedObject != null) {
                logger.traceDebug(THIS_CLASS, "Found stub MO, deleting it!");
                managedObject.delete(coordinator);
            }
        }
        if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
    }

    private void checkStopUsingDeprecatedStructure(String string) {
        if (GERAN_FREQUENCY_REF_ATTR.equals(string) && UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
    }
}

