/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.geranfrequency;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.ArfcnValueAndBandIndicatorValidator;
import se.ericsson.lte.rbs.omf.common.validator.GeranFrequencyIndirectRelationValidator;
import se.ericsson.lte.rbs.omf.common.validator.GeranRelationConsistencyValidator;
import se.ericsson.lte.rbs.omf.common.validator.ReservedByMaxNrOfMOsValidator;
import se.ericsson.lte.rbs.omf.common.validator.SameDeprecatedMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SetArrayToEmptyValueValidator;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.DeprecatedGeranFrequencyWrapper;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.GeranFrequencyDeprecatedMaoImpl;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.UseDeprecatedStructureChecker;

public class GeranFrequencyMaoImpl
extends AbstractGenericAttributeValidatorMao {
    public static final int SHARED_INTERVAL_UPPER_LIMIT = 810;
    public static final int SHARED_INTERVAL_LOWER_LIMIT = 512;
    private static final int MAXIMUM_NR_OF_GERAN_FREQ_PER_GERAN_FREQ_GROUP = 32;
    public static final String BAND_INDICATOR = "bandIndicator";
    public static final String ARFCN_VALUE_GERAN_DL = "arfcnValueGeranDl";
    public static final String GERAN_FREQ_GROUP_REF_ATTR = "geranFreqGroupRef";
    public static final String MO_TYPE = "GeranFrequency";
    private static final Class THIS_CLASS = GeranFrequencyMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public GeranFrequencyMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(GeranFrequencyDeprecatedMaoImpl.getCorrectParent(managedObject), attrList, GeranFrequencyDeprecatedMaoImpl.getCorrectId(managedObject, string, coordinator), MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GeranFrequencyMaoImpl() - constructor");
        logger.traceDebug(THIS_CLASS, "Parent: " + managedObject);
        if (GeranFrequencyDeprecatedMaoImpl.inOldStructure(managedObject)) {
            logger.traceDebug(THIS_CLASS, "Creating stub MO");
            DeprecatedGeranFrequencyWrapper.getInstance().createDeprecatedGeranFrequency(managedObject, string, coordinator, initialMaoContext, (ManagedObject)this);
            super.setAttribute(GERAN_FREQ_GROUP_REF_ATTR, new ManagedObject[]{managedObject}, coordinator);
        } else if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
        logger.traceReturn(THIS_CLASS, "GeranFrequencyMaoImpl() - constructor");
    }

    public GeranFrequencyMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GeranFrequencyMaoImpl() - recovery constructor");
        logger.traceReturn(THIS_CLASS, "GeranFrequencyMaoImpl() - recovery constructor");
    }

    public void postRecover() throws TransactionRequiredException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postRecover()");
        this.handleDeprecationAtPostRecover();
        logger.traceReturn(THIS_CLASS, "postRecover()");
        super.postRecover();
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete()");
        super.delete(coordinator);
        this.handleDeprecationAtDelete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    protected void deleteFromProxy(Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        super.delete(coordinator);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.checkStopUsingDeprecatedStructure(string);
        super.setAttribute(string, object, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.checkStopUsingDeprecatedStructure(stringArray[i]);
        }
        super.setAttributes(stringArray, objectArray, coordinator);
    }

    private void handleDeprecationAtPostRecover() throws MoNameAlreadyTakenException {
        if (UseDeprecatedStructureChecker.getInstance().useDeprecation() && GeranFrequencyDeprecatedMaoImpl.isUpgradedFromOldStructure((ManagedObject)this)) {
            ManagedObject managedObject = this.getStubMo();
            if (managedObject == null) {
                this.createStubMo();
            } else {
                this.registerWithStubMo(managedObject);
            }
        }
    }

    private void handleDeprecationAtDelete(Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        String string = this.getLocalDistinguishedName();
        if (GeranFrequencyDeprecatedMaoImpl.isUpgradedFromOldStructure((ManagedObject)this)) {
            String string2 = GeranFrequencyDeprecatedMaoImpl.getLdnOfDeprecatedMo(string);
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string2);
            if (managedObject != null) {
                logger.traceDebug(THIS_CLASS, "Found stub MO, deleting it!");
                managedObject.delete(coordinator);
            }
        }
        if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
    }

    private ManagedObject getStubMo() {
        String string = this.getLocalDistinguishedName();
        String string2 = GeranFrequencyDeprecatedMaoImpl.getLdnOfDeprecatedMo(string);
        logger.traceDebug(THIS_CLASS, "Looking for: " + string2);
        ManagedObject managedObject = this.getMaoContext().getMoAccessor().lookup(string2);
        return managedObject;
    }

    private void createStubMo() throws MoNameAlreadyTakenException {
        String string = this.getLocalDistinguishedName();
        String string2 = GeranFrequencyDeprecatedMaoImpl.getLdnOfDeprecatedMo(string);
        logger.traceDebug(THIS_CLASS, "Creating stub MO with LDN: " + string2);
        DeprecatedGeranFrequencyWrapper.getInstance().createDeprecatedGeranFrequency(string2, (InitialMaoContext)this.getMaoContext(), (ManagedObject)this);
    }

    private void registerWithStubMo(ManagedObject managedObject) {
        ((GeranFrequencyDeprecatedMaoImpl)managedObject).setReplacementMo((ManagedObject)this);
    }

    private void checkStopUsingDeprecatedStructure(String string) {
        if (GERAN_FREQ_GROUP_REF_ATTR.equals(string) && UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "registerValidators()");
        this.registerValidator(BAND_INDICATOR, new ArfcnValueAndBandIndicatorValidator(BAND_INDICATOR));
        this.registerValidator(ARFCN_VALUE_GERAN_DL, new SameDeprecatedMoTypeValidator(ARFCN_VALUE_GERAN_DL, true, this.genericMaoContext));
        this.registerValidator(ARFCN_VALUE_GERAN_DL, new ArfcnValueAndBandIndicatorValidator(ARFCN_VALUE_GERAN_DL));
        this.registerValidator(GERAN_FREQ_GROUP_REF_ATTR, new ReservedByMaxNrOfMOsValidator(GERAN_FREQ_GROUP_REF_ATTR, MO_TYPE, 32));
        this.registerValidator(GERAN_FREQ_GROUP_REF_ATTR, new GeranFrequencyIndirectRelationValidator(GERAN_FREQ_GROUP_REF_ATTR));
        this.registerValidator(GERAN_FREQ_GROUP_REF_ATTR, new GeranRelationConsistencyValidator(GERAN_FREQ_GROUP_REF_ATTR));
        this.registerValidator(GERAN_FREQ_GROUP_REF_ATTR, new SetArrayToEmptyValueValidator(GERAN_FREQ_GROUP_REF_ATTR));
        logger.traceReturn(THIS_CLASS, "registerValidators()");
    }
}

