/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.ima.handler;

import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.StringHelper;
import se.ericsson.lte.rbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.lte.rbs.omf.common.proxy.SignalHandler;
import se.ericsson.lte.rbs.omf.common.proxy.SignalObject;
import se.ericsson.lte.rbs.omf.common.xml.XmlPack;
import se.ericsson.lte.rbs.omf.common.xml.XmlPackFactory;
import se.ericsson.lte.rbs.omf.mao.ima.handler.AttributeHolder;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaHandlerException;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaRequestXmlHandler;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaSubscriptionHandler;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaConnToServerCfmSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaConnToServerReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaOmfReadCfmSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaOmfReadReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaRacSubscribeCfmSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaRacSubscribeReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaUehReadCfmSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaUehReadReqSignal;

public class ImaSignalHandler
implements SignalHandler {
    protected static final String CLASS_TAG = "class";
    public static final int NOT_USED_SERVERREF_VALUE = 43;
    public static final String IMA_VERSION = "R1A";
    private static final String BLANK_STRING = " ";
    private static final String EMPTY_STRING = "";
    public static final String INTEGER_ATTRIBUTE_NAME = "INTEGER";
    public static final String STRING_ATTRIBUTE_NAME = "STRING";
    private static final AttributeHolder[] OMF_MANAGED_ELEMENT_ATTRS = new AttributeHolder[]{new AttributeHolder("logicalName", String.class), new AttributeHolder("userLabel", String.class)};
    private static final AttributeHolder[] OMF_UPGRADE_PACKAGE_ATTRS = new AttributeHolder[]{new AttributeHolder("upgradePackageDocumentId", String.class)};
    private static final AttributeHolder[] OMF_ENODEB_FUNCTION_ATTRS = new AttributeHolder[]{new AttributeHolder("eNBId", Integer.class), new AttributeHolder("eNodeBPlmnId", Struct.class)};
    private static final AttributeHolder[] OMF_CONFIGURATION_VERSION_ATTRS = new AttributeHolder[]{new AttributeHolder("currentUpgradePackage", String.class)};
    private static final AttributeHolder[] UEH_MANAGED_ELEMENT_ATTRS = new AttributeHolder[]{new AttributeHolder("logicalName", String.class)};
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    protected static final String UPGRADE_PACKAGE_LDN = "ManagedElement=1,SwManagement=1,UpgradePackage=";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    private static final String ENODEB_FUNCTION_LDN = "ManagedElement=1,ENodeBFunction=1";
    protected static final int OMF_REQUEST = 0;
    protected static final int UEH_REQUEST = 1;
    protected static final int RAC_SUBSCRIBE_REQUEST = 2;
    protected static final String[] REQUESTER_NAME = new String[]{"OMF", "UEH", "RAC_SUBSCRIBE"};
    protected static final String[][] VALID_EQUALS_LDNS = new String[][]{{"ManagedElement=1", "ManagedElement=1,SwManagement=1,ConfigurationVersion=1", "ManagedElement=1,ENodeBFunction=1"}, {"ManagedElement=1"}, {"ManagedElement=1", "ManagedElement=1,ENodeBFunction=1"}};
    private static final String[][] VALID_STARTS_WITH_LDNS = new String[][]{{"ManagedElement=1,SwManagement=1,UpgradePackage="}, new String[0], new String[0]};
    private static final String IMA = "ima";
    private static final Class THIS_CLASS = ImaSignalHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final OmfContext theOmfContext;
    private static final Map[] REQUEST_LDN_ATTRIBUTES_ARRAY = new Map[REQUESTER_NAME.length];

    public ImaSignalHandler(AbstractSignalConverter abstractSignalConverter, OmfContext omfContext) {
        this.theOmfContext = omfContext;
        abstractSignalConverter.addSignalHandler(new OmfMaoImaOmfReadReqSignal(), this);
        abstractSignalConverter.addSignalHandler(new OmfMaoImaUehReadReqSignal(), this);
        abstractSignalConverter.addSignalHandler(new OmfMaoImaConnToServerReqSignal(), this);
        abstractSignalConverter.addSignalHandler(new OmfMaoImaRacSubscribeReqSignal(), this);
    }

    public SignalObject request(SignalObject signalObject) {
        logger.traceGeneral(THIS_CLASS, "Received new request signal: " + signalObject);
        SignalObject signalObject2 = null;
        String string = "Not set yet";
        try {
            int n = signalObject.getSignalNumber();
            switch (n) {
                case 23234820: {
                    string = "OMF_MAO_IMA_OMF_READ_REQ";
                    signalObject2 = this.handleOmfReadRequest(signalObject);
                    break;
                }
                case 23234822: {
                    string = "OMF_MAO_IMA_UEH_READ_REQ";
                    signalObject2 = this.handleUehReadRequest(signalObject);
                    break;
                }
                case 23234816: {
                    string = "OMF_MAO_IMA_CONN_TO_SERVER_REQ";
                    signalObject2 = this.handleControllerConnectRequest(signalObject);
                    break;
                }
                case 23234824: {
                    string = "OMF_MAO_IMA_RAC_SUBSCRIBE_REQ";
                    signalObject2 = this.handleRacSubscribeRequest(signalObject);
                    break;
                }
                default: {
                    logger.traceAbnormal(THIS_CLASS, "Ignoring unknown signal " + n);
                    break;
                }
            }
        }
        catch (MoAccessException moAccessException) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed to created request: " + string), (Throwable)moAccessException));
        }
        return signalObject2;
    }

    private SignalObject handleControllerConnectRequest(SignalObject signalObject) {
        OmfMaoImaConnToServerReqSignal omfMaoImaConnToServerReqSignal = (OmfMaoImaConnToServerReqSignal)signalObject;
        OmfMaoImaConnToServerCfmSignal omfMaoImaConnToServerCfmSignal = new OmfMaoImaConnToServerCfmSignal();
        omfMaoImaConnToServerCfmSignal.setClientRef(omfMaoImaConnToServerReqSignal.getClientRef());
        omfMaoImaConnToServerCfmSignal.setServerRef(43);
        return omfMaoImaConnToServerCfmSignal;
    }

    protected SignalObject handleOmfReadRequest(SignalObject signalObject) throws MoAccessException {
        OmfMaoImaOmfReadReqSignal omfMaoImaOmfReadReqSignal = (OmfMaoImaOmfReadReqSignal)signalObject;
        OmfMaoImaOmfReadCfmSignal omfMaoImaOmfReadCfmSignal = new OmfMaoImaOmfReadCfmSignal();
        String string = this.createResponseXml(0, omfMaoImaOmfReadReqSignal.getXml());
        omfMaoImaOmfReadCfmSignal.setXml(string);
        omfMaoImaOmfReadCfmSignal.setClientRef(omfMaoImaOmfReadReqSignal.getClientRef());
        omfMaoImaOmfReadCfmSignal.setServerRef(omfMaoImaOmfReadReqSignal.getServerRef());
        return omfMaoImaOmfReadCfmSignal;
    }

    protected SignalObject handleUehReadRequest(SignalObject signalObject) throws MoAccessException {
        OmfMaoImaUehReadReqSignal omfMaoImaUehReadReqSignal = (OmfMaoImaUehReadReqSignal)signalObject;
        OmfMaoImaUehReadCfmSignal omfMaoImaUehReadCfmSignal = new OmfMaoImaUehReadCfmSignal();
        String string = this.createResponseXml(1, omfMaoImaUehReadReqSignal.getXml());
        omfMaoImaUehReadCfmSignal.setXml(string);
        omfMaoImaUehReadCfmSignal.setClientRef(omfMaoImaUehReadReqSignal.getClientRef());
        omfMaoImaUehReadCfmSignal.setServerRef(omfMaoImaUehReadReqSignal.getServerRef());
        return omfMaoImaUehReadCfmSignal;
    }

    private SignalObject handleRacSubscribeRequest(SignalObject signalObject) throws MoAccessException {
        OmfMaoImaRacSubscribeReqSignal omfMaoImaRacSubscribeReqSignal = (OmfMaoImaRacSubscribeReqSignal)signalObject;
        this.createRacSubscriptions(omfMaoImaRacSubscribeReqSignal);
        String string = this.createResponseXml(2, omfMaoImaRacSubscribeReqSignal.getXml());
        OmfMaoImaRacSubscribeCfmSignal omfMaoImaRacSubscribeCfmSignal = new OmfMaoImaRacSubscribeCfmSignal();
        omfMaoImaRacSubscribeCfmSignal.setXml(string);
        omfMaoImaRacSubscribeCfmSignal.setClientRef(omfMaoImaRacSubscribeReqSignal.getClientRef());
        omfMaoImaRacSubscribeCfmSignal.setServerRef(omfMaoImaRacSubscribeReqSignal.getServerRef());
        return omfMaoImaRacSubscribeCfmSignal;
    }

    private void createRacSubscriptions(OmfMaoImaRacSubscribeReqSignal omfMaoImaRacSubscribeReqSignal) {
        Set set = ImaSignalHandler.parseInput(omfMaoImaRacSubscribeReqSignal.getXml());
        ImaSignalHandler.filterLdns(2, set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = ImaSignalHandler.trimLdn((String)iterator.next());
            MoAndAttrHolder moAndAttrHolder = this.getManagedElementAndAttribute(string);
            ImaSubscriptionHandler imaSubscriptionHandler = ImaSubscriptionHandler.getInstance(this.theOmfContext);
            imaSubscriptionHandler.startSubscription(moAndAttrHolder.moType, moAndAttrHolder.attribute);
        }
    }

    protected String createResponseXml(int n, String string) throws MoAccessException {
        String string2;
        logger.traceGeneral(THIS_CLASS, "handleGenericRequest [" + string + "] from " + n);
        XmlPack xmlPack = XmlPackFactory.getXmlPack();
        Document document = xmlPack.createDocument();
        Element element = ImaSignalHandler.createTopElement(document);
        Set set = ImaSignalHandler.parseInput(string);
        ImaSignalHandler.filterLdns(n, set);
        Iterator iterator = set.iterator();
        MoRepositoryWrapper moRepositoryWrapper = this.theOmfContext.getMoRepositoryWrapper();
        while (iterator.hasNext()) {
            string2 = ImaSignalHandler.trimLdn((String)iterator.next());
            this.addResponseData(element, n, xmlPack, document, moRepositoryWrapper, string2);
        }
        string2 = this.createResponse(xmlPack, document);
        logger.traceGeneral(THIS_CLASS, "handleGenericRequest returning [" + string2 + "]");
        return string2;
    }

    private String createResponse(XmlPack xmlPack, Document document) throws MoAccessException {
        String string = xmlPack.transformDocument(document, false);
        string = StringHelper.replaceInString((String)string, (String)"\n", (String)EMPTY_STRING);
        return string;
    }

    private void addResponseData(Element element, int n, XmlPack xmlPack, Document document, MoRepositoryWrapper moRepositoryWrapper, String string) {
        try {
            ManagedObject managedObject = moRepositoryWrapper.lookup(string);
            if (managedObject == null) {
                logger.traceError(THIS_CLASS, "Failed " + REQUESTER_NAME[n] + " request. Mo does not exist for the specified LDN: \"" + string + "\"");
            } else {
                AttributeHolder[] attributeHolderArray = this.getResponseAttributes(n, string);
                this.addResponse(attributeHolderArray, element, managedObject, xmlPack, document);
            }
        }
        catch (MoAccessException moAccessException) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed " + REQUESTER_NAME[n] + " request. Could not get data for LDN, \"" + string), (Throwable)moAccessException));
        }
        catch (ImaHandlerException imaHandlerException) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed " + REQUESTER_NAME[n] + " request. Could not get data for LDN, \"" + string), (Throwable)imaHandlerException));
        }
    }

    private AttributeHolder[] getResponseAttributes(int n, String string) {
        Map map = REQUEST_LDN_ATTRIBUTES_ARRAY[n];
        Iterator iterator = map.entrySet().iterator();
        AttributeHolder[] attributeHolderArray = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if ((!string2.endsWith("=") || !string.startsWith(string2)) && !string.equals(string2)) continue;
            attributeHolderArray = (AttributeHolder[])entry.getValue();
            break;
        }
        return attributeHolderArray;
    }

    private MoAndAttrHolder getManagedElementAndAttribute(String string) {
        MoAndAttrHolder moAndAttrHolder = new MoAndAttrHolder("ManagedElement", "logicalName");
        if (string.indexOf("ENodeBFunction") > -1) {
            moAndAttrHolder = new MoAndAttrHolder("ENodeBFunction", "eNBId");
        }
        return moAndAttrHolder;
    }

    private void addResponse(AttributeHolder[] attributeHolderArray, Element element, ManagedObject managedObject, XmlPack xmlPack, Document document) throws MoAccessException, ImaHandlerException {
        String[] stringArray = this.getAttributeNames(attributeHolderArray);
        Element element2 = ImaSignalHandler.createTypeElement(CLASS_TAG, managedObject.getLocalDistinguishedName(), document);
        element.appendChild(element2);
        Object[] objectArray = this.getAttributes(stringArray, managedObject);
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof ManagedObject) {
                    ManagedObject managedObject2 = (ManagedObject)objectArray[i];
                    ImaSignalHandler.packHolder(element2, xmlPack, document, new AttributeHolder(attributeHolderArray[i].attributeName, class$java$lang$String == null ? ImaSignalHandler.class$("java.lang.String") : class$java$lang$String), managedObject2.getLocalDistinguishedName());
                    continue;
                }
                ImaSignalHandler.packHolder(element2, xmlPack, document, attributeHolderArray[i], objectArray[i]);
            }
        }
    }

    private String[] getAttributeNames(AttributeHolder[] attributeHolderArray) {
        String[] stringArray = new String[attributeHolderArray.length];
        for (int i = 0; i < attributeHolderArray.length; ++i) {
            stringArray[i] = attributeHolderArray[i].attributeName;
        }
        return stringArray;
    }

    protected static void packHolder(Element element, XmlPack xmlPack, Document document, AttributeHolder attributeHolder, Object object) throws ImaHandlerException, MoAccessException {
        if (String.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packString(element, xmlPack, document, attributeHolder.attributeName, object);
        } else if (Integer.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packInt(element, xmlPack, document, attributeHolder.attributeName, object);
        } else if (Struct.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packStruct(element, xmlPack, document, attributeHolder.attributeName, object);
        }
    }

    public static void filterLdns(int n, Set set) {
        Iterator iterator = set.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                while (iterator.hasNext()) {
                    String string = ImaSignalHandler.trimLdn((String)iterator.next());
                    String[] stringArray = VALID_EQUALS_LDNS[n];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        arrayList.add(string);
                    }
                    String[] stringArray2 = VALID_STARTS_WITH_LDNS[n];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!string.startsWith(stringArray2[i])) continue;
                        arrayList.add(string);
                    }
                }
                break;
            }
            default: {
                logger.traceAbnormal(THIS_CLASS, "Can't filter LDNs for unknown requester " + n);
            }
        }
        set.clear();
        set.addAll(arrayList);
    }

    public static Set parseInput(String string) {
        logger.traceEnter(THIS_CLASS, "parseInput()");
        HashSet hashSet = new HashSet();
        Set set = null;
        if (string == null) {
            logger.traceError(THIS_CLASS, "XML parse exception: xml document is null");
        } else {
            try {
                CharArrayReader charArrayReader = new CharArrayReader(string.trim().toCharArray());
                InputSource inputSource = new InputSource(charArrayReader);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                ImaRequestXmlHandler imaRequestXmlHandler = new ImaRequestXmlHandler();
                xMLReader.setContentHandler(imaRequestXmlHandler);
                xMLReader.setErrorHandler(imaRequestXmlHandler);
                xMLReader.parse(inputSource);
                set = imaRequestXmlHandler.getLdns();
                hashSet.addAll(set);
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "XML parse exception: " + exception.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "parseInput()");
        return hashSet;
    }

    protected Object getAttribute(String string, ManagedObject managedObject) throws MoAccessException, ImaHandlerException {
        Object object = managedObject.getAttribute(string, null);
        if (object == null) {
            throw new ImaHandlerException("Attribute, " + string + ", not found");
        }
        return object;
    }

    protected Object[] getAttributes(String[] stringArray, ManagedObject managedObject) throws MoAccessException, ImaHandlerException {
        Object[] objectArray = managedObject.getAttributes(stringArray, null);
        if (objectArray == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            throw new ImaHandlerException("Attributes, " + arrayList + ", not found");
        }
        if (objectArray.length == stringArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                throw new ImaHandlerException("Attribute, [" + stringArray[i] + "], not found");
            }
        } else {
            throw new ImaHandlerException("Data inconsistent. Asked for " + stringArray.length + " but got " + objectArray.length + " attributes from getAttributes()");
        }
        return objectArray;
    }

    protected static void packInt(Element element, XmlPack xmlPack, Document document, String string, Object object) throws ImaHandlerException, MoAccessException {
        if (!(object instanceof Integer)) {
            throw new ImaHandlerException(string + " is not an Integer");
        }
        Element element2 = xmlPack.packInt(string, object, document);
        element.appendChild(element2);
    }

    protected static void packString(Element element, XmlPack xmlPack, Document document, String string, Object object) throws ImaHandlerException, MoAccessException {
        if (!(object instanceof String)) {
            throw new ImaHandlerException(string + " is not a String");
        }
        Element element2 = xmlPack.packString(string, object, document);
        element.appendChild(element2);
    }

    protected static void packStruct(Element element, XmlPack xmlPack, Document document, String string, Object object) throws ImaHandlerException, MoAccessException {
        if (!(object instanceof Struct)) {
            throw new ImaHandlerException(string + " is not a Struct");
        }
        Element element2 = xmlPack.packStruct(string, (Struct)object, document);
        element.appendChild(element2);
    }

    protected static Element createTopElement(Document document) {
        Element element = document.createElement(IMA);
        element.setAttribute("version", IMA_VERSION);
        document.appendChild(element);
        return element;
    }

    protected static Element createTypeElement(String string, String string2, Document document) {
        Element element = document.createElement(string);
        element.setAttribute("ldn", string2);
        return element;
    }

    protected UpgradePackageMo convertAttributeToUpgradePackageMo(String string, Object object) throws ImaHandlerException {
        if (object instanceof UpgradePackageMo) {
            return (UpgradePackageMo)object;
        }
        throw new ImaHandlerException(string + " is not an UpgradePackageMo");
    }

    protected static String trimLdn(String string) {
        return StringHelper.replaceInString((String)string, (String)BLANK_STRING, (String)EMPTY_STRING);
    }

    static {
        HashMap<String, AttributeHolder[]> hashMap = new HashMap<String, AttributeHolder[]>();
        hashMap.put(MANAGED_ELEMENT_LDN, OMF_MANAGED_ELEMENT_ATTRS);
        hashMap.put(CONFIGURATION_VERSION_LDN, OMF_CONFIGURATION_VERSION_ATTRS);
        hashMap.put(ENODEB_FUNCTION_LDN, OMF_ENODEB_FUNCTION_ATTRS);
        hashMap.put(UPGRADE_PACKAGE_LDN, OMF_UPGRADE_PACKAGE_ATTRS);
        HashMap<String, AttributeHolder[]> hashMap2 = new HashMap<String, AttributeHolder[]>();
        hashMap2.put(MANAGED_ELEMENT_LDN, UEH_MANAGED_ELEMENT_ATTRS);
        HashMap<String, AttributeHolder[]> hashMap3 = new HashMap<String, AttributeHolder[]>();
        hashMap3.put(MANAGED_ELEMENT_LDN, OMF_MANAGED_ELEMENT_ATTRS);
        hashMap3.put(ENODEB_FUNCTION_LDN, OMF_ENODEB_FUNCTION_ATTRS);
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[0] = hashMap;
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[1] = hashMap2;
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[2] = hashMap3;
    }

    private static class MoAndAttrHolder {
        private final String moType;
        private final String attribute;

        public MoAndAttrHolder(String string, String string2) {
            this.moType = string;
            this.attribute = string2;
        }
    }
}

