/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.ima.handler;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.proxy.AbstractSignalObject;
import se.ericsson.lte.rbs.omf.common.proxy.OseSenderReceiverFactory;
import se.ericsson.lte.rbs.omf.common.proxy.SignalException;
import se.ericsson.lte.rbs.omf.common.proxy.SignalObject;
import se.ericsson.lte.rbs.omf.common.xml.XmlPack;
import se.ericsson.lte.rbs.omf.common.xml.XmlPackFactory;
import se.ericsson.lte.rbs.omf.mao.ima.handler.AttributeHolder;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaHandlerException;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaSignalHandler;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaRacAttributeValueChangedIndSignal;

public class ImaSubscriptionHandler
implements AvcSubscriber {
    private static final Class THIS_CLASS = ImaSubscriptionHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String MANAGED_ELEMENT_TYPE = "ManagedElement";
    protected static final String LOGICAL_NAME_ATTRIBUTE = "logicalName";
    protected static final String ENB_FUNCTION_TYPE = "ENodeBFunction";
    protected static final String ENB_ID_ATTRIBUTE = "eNBId";
    private static ImaSubscriptionHandler instance;
    protected Object lastLogicalName;
    protected Object lastENbId;
    private final OmfContext omfContext;
    private final List avcList;

    private ImaSubscriptionHandler(OmfContext omfContext) {
        this.omfContext = omfContext;
        this.avcList = new ArrayList();
    }

    public void startSubscription(String string, String string2) {
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, string2);
    }

    public void stopSubscription(String string, String string2) {
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, string, string2);
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) {
        Class clazz;
        this.storeLogicalName(string2, object);
        boolean bl = this.storeENbId(string2, object);
        Class clazz2 = clazz = String.class;
        if (bl) {
            clazz = Integer.class;
        }
        AvcSenderReceiverInfoHolder[] avcSenderReceiverInfoHolderArray = this.getAvcSenderReceiverInfoHolder(string);
        for (int i = 0; i < avcSenderReceiverInfoHolderArray.length; ++i) {
            try {
                AbstractSignalObject abstractSignalObject = (AbstractSignalObject)this.buildAvcInd(string, avcSenderReceiverInfoHolderArray[i], string2, object, clazz);
                OseSenderReceiverFactory.getInstance().getOseSenderReceiver().sendSignal(avcSenderReceiverInfoHolderArray[i].sender, avcSenderReceiverInfoHolderArray[i].receiver, (Signal)abstractSignalObject.getOseSignal());
                continue;
            }
            catch (SignalException signalException) {
                logger.traceError(THIS_CLASS, ExceptionHelper.appendReason((String)"Could not report avc to subscriber.", (Throwable)signalException));
                continue;
            }
            catch (ImaHandlerException imaHandlerException) {
                logger.traceError(THIS_CLASS, ExceptionHelper.appendReason((String)"Could not report avc to subscriber.", (Throwable)imaHandlerException));
                continue;
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, ExceptionHelper.appendReason((String)"Could not report avc to subscriber.", (Throwable)moAccessException));
            }
        }
    }

    private boolean storeENbId(String string, Object object) {
        boolean bl = false;
        if (ENB_ID_ATTRIBUTE.equalsIgnoreCase(string)) {
            this.lastENbId = object;
            bl = true;
        }
        return bl;
    }

    private boolean storeLogicalName(String string, Object object) {
        boolean bl = false;
        if (LOGICAL_NAME_ATTRIBUTE.equalsIgnoreCase(string)) {
            this.lastLogicalName = object;
            bl = true;
        }
        return bl;
    }

    private AvcSenderReceiverInfoHolder[] getAvcSenderReceiverInfoHolder(String string) {
        ArrayList<AvcSenderReceiverInfoHolder> arrayList = new ArrayList<AvcSenderReceiverInfoHolder>();
        for (int i = 0; i < this.avcList.size(); ++i) {
            AvcSenderReceiverInfoHolder avcSenderReceiverInfoHolder = (AvcSenderReceiverInfoHolder)this.avcList.get(i);
            if (!avcSenderReceiverInfoHolder.ldn.equalsIgnoreCase(string)) continue;
            arrayList.add(avcSenderReceiverInfoHolder);
        }
        AvcSenderReceiverInfoHolder[] avcSenderReceiverInfoHolderArray = new AvcSenderReceiverInfoHolder[arrayList.size()];
        arrayList.toArray(avcSenderReceiverInfoHolderArray);
        return avcSenderReceiverInfoHolderArray;
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        Object object;
        Object object2 = this.getManagedElement().getAttribute(LOGICAL_NAME_ATTRIBUTE, coordinator);
        if (object2 != null && !object2.equals(this.lastLogicalName)) {
            this.reportAvc(null, LOGICAL_NAME_ATTRIBUTE, object2, coordinator);
        }
        if ((object = this.getENodeBFunction().getAttribute(ENB_ID_ATTRIBUTE, coordinator)) != null && !object.equals(this.lastENbId)) {
            this.reportAvc(null, ENB_ID_ATTRIBUTE, object, coordinator);
        }
    }

    private ManagedObject getManagedElement() {
        MoIterator moIterator = this.omfContext.getMoRepositoryWrapper().lookupType(MANAGED_ELEMENT_TYPE);
        ManagedObject managedObject = moIterator.nextMo();
        return managedObject;
    }

    private ManagedObject getENodeBFunction() {
        MoIterator moIterator = this.omfContext.getMoRepositoryWrapper().lookupType(ENB_FUNCTION_TYPE);
        ManagedObject managedObject = moIterator.nextMo();
        return managedObject;
    }

    private SignalObject buildAvcInd(String string, AvcSenderReceiverInfoHolder avcSenderReceiverInfoHolder, String string2, Object object, Class clazz) throws ImaHandlerException, MoAccessException {
        OmfMaoImaRacAttributeValueChangedIndSignal omfMaoImaRacAttributeValueChangedIndSignal = new OmfMaoImaRacAttributeValueChangedIndSignal();
        String string3 = this.getXmlResponse(string, string2, object, clazz);
        omfMaoImaRacAttributeValueChangedIndSignal.setXml(string3);
        omfMaoImaRacAttributeValueChangedIndSignal.setClientRef(avcSenderReceiverInfoHolder.clientRef);
        omfMaoImaRacAttributeValueChangedIndSignal.setServerRef(avcSenderReceiverInfoHolder.serverRef);
        return omfMaoImaRacAttributeValueChangedIndSignal;
    }

    private String getXmlResponse(String string, String string2, Object object, Class clazz) throws ImaHandlerException, MoAccessException {
        XmlPack xmlPack = XmlPackFactory.getXmlPack();
        Document document = xmlPack.createDocument();
        Element element = ImaSignalHandler.createTopElement(document);
        Element element2 = ImaSignalHandler.createTypeElement("class", string, document);
        element.appendChild(element2);
        AttributeHolder attributeHolder = new AttributeHolder(string2, clazz);
        ImaSignalHandler.packHolder(element2, xmlPack, document, attributeHolder, object);
        return xmlPack.transformDocument(document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImaSubscriptionHandler getInstance(OmfContext omfContext) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new ImaSubscriptionHandler(omfContext);
            }
            return instance;
        }
    }

    public void addSenderReceiver(OseProcess oseProcess, OseProcess oseProcess2, int n, int n2, String string) {
        Iterator iterator;
        Set set = ImaSignalHandler.parseInput(string);
        ImaSignalHandler.filterLdns(2, set);
        if (set != null && (iterator = set.iterator()) != null) {
            this.loopIteratorAndAdd(oseProcess, oseProcess2, n, n2, iterator);
        }
    }

    private void loopIteratorAndAdd(OseProcess oseProcess, OseProcess oseProcess2, int n, int n2, Iterator iterator) {
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) continue;
            String string = object.toString();
            this.avcList.add(new AvcSenderReceiverInfoHolder(string, oseProcess, oseProcess2, n, n2));
        }
    }

    private static class AvcSenderReceiverInfoHolder {
        private final OseProcess sender;
        private final OseProcess receiver;
        private final int clientRef;
        private final int serverRef;
        private final String ldn;

        public AvcSenderReceiverInfoHolder(String string, OseProcess oseProcess, OseProcess oseProcess2, int n, int n2) {
            this.ldn = string;
            this.sender = oseProcess;
            this.receiver = oseProcess2;
            this.clientRef = n;
            this.serverRef = n2;
        }
    }
}

