/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.opprofiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.systemconstants.SystemConstantsMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.mao.opprofiles.OpProfile;
import se.ericsson.lte.rbs.omf.mao.opprofiles.OpProfileParameter;
import se.ericsson.lte.rbs.omf.mao.opprofiles.OpProfilesMaoDefinitions;

public class OpProfilesMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final int TX_TIMEOUT = 120;
    private static final String ADMINISTRATIVE_STATE = "administrativeState";
    private static final Integer LOCKED = new Integer(0);
    private static final Integer UNLOCKED = new Integer(1);
    private static final Class THIS_CLASS = OpProfilesMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String PROFILE_NAME = "profileName";
    private static final String MO_TYPE = "OpProfiles";

    public OpProfilesMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public OpProfilesMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    public void actionActivateProfile(String string, Coordinator coordinator) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "actionActivateProfile(profileName[" + string + "], coordinator[" + coordinator + "])");
        OpProfile opProfile = this.getProfile(string);
        logger.traceDebug(THIS_CLASS, "Found profile: " + string);
        List list = this.lockCells();
        this.setProfileContent(opProfile);
        this.unlockCells(list, coordinator);
        logger.traceReturn(THIS_CLASS, "actionActivateProfile()");
    }

    private void setProfileContent(OpProfile opProfile) throws TransactionRolledBackException, InactiveTransactionException {
        Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
        Coordinator coordinator = control.getCoordinator();
        try {
            this.setProfileMoAttributes(opProfile, coordinator);
            this.resetProfileSystemConstants(opProfile, coordinator);
            this.sendActionWithCfm("activateProfile", coordinator, this.createSignalParameterMap(opProfile.profileName));
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception message: " + (Object)((Object)moAccessException));
            control.getTerminator().rollback();
        }
    }

    private List lockCells() throws TransactionRolledBackException, InactiveTransactionException, MoAccessException {
        List list = null;
        Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
        Coordinator coordinator = control.getCoordinator();
        try {
            list = this.lockAllUnlockedCells(coordinator);
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            control.getTerminator().rollback();
            throw moAccessException;
        }
        return list;
    }

    private void resetProfileSystemConstants(OpProfile opProfile, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        SystemConstantsMao systemConstantsMao = (SystemConstantsMao)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,NodeManagementFunction=1,SystemConstants=1");
        String string = (String)systemConstantsMao.getAttribute("systConstants", coordinator);
        logger.traceDebug(THIS_CLASS, "systemConstants before reset: " + string);
        for (int i = 0; i < opProfile.profileSystemConstantIds.length; ++i) {
            boolean bl = this.isSystemConstantIdInString(opProfile.profileSystemConstantIds[i].toString(), string);
            if (bl) {
                systemConstantsMao.actionResetSystConst(opProfile.profileSystemConstantIds[i].toString(), coordinator);
                logger.traceDebug(THIS_CLASS, "Profile systemConstant reset");
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Profile systemConstant not set - skipping reset.");
        }
    }

    private boolean isSystemConstantIdInString(String string, String string2) {
        boolean bl = string2.indexOf(string + ':') == 0;
        boolean bl2 = string2.indexOf(',' + string + ':') > 0;
        boolean bl3 = bl2 || bl;
        return bl3;
    }

    private void unlockCells(List list, Coordinator coordinator) throws MoAccessException {
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ManagedObject managedObject = (ManagedObject)listIterator.next();
                if (MoCheck.isMoNotReadable(managedObject)) continue;
                managedObject.setAttribute(ADMINISTRATIVE_STATE, (Object)UNLOCKED, coordinator);
            }
        }
    }

    private List lockAllUnlockedCells(Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "lockAllUnlockedCells()");
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellFDD");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                Integer n;
                ManagedObject managedObject = moIterator.nextMo();
                if (MoCheck.isMoNotReadable(managedObject) || !(n = (Integer)managedObject.getAttribute(ADMINISTRATIVE_STATE, coordinator)).equals(UNLOCKED)) continue;
                managedObject.setAttribute(ADMINISTRATIVE_STATE, (Object)LOCKED, coordinator);
                arrayList.add(managedObject);
            }
        }
        logger.traceReturn(THIS_CLASS, "lockAllUnlockedCells()");
        return arrayList;
    }

    private Map createSignalParameterMap(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(PROFILE_NAME, string);
        return treeMap;
    }

    private void setProfileMoAttributes(OpProfile opProfile, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setProfileMoAttributes()");
        Map map = this.createParameterMapByMoType(opProfile);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setProfileAttributesOnAllMoWithMoType(coordinator, map, string);
        }
        logger.traceReturn(THIS_CLASS, "setProfileMoAttributes()");
    }

    private void setProfileAttributesOnAllMoWithMoType(Coordinator coordinator, Map map, String string) throws MoAccessException {
        OpProfileParameter opProfileParameter;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Iterator iterator = ((List)map.get(string)).iterator();
        while (iterator.hasNext()) {
            opProfileParameter = (OpProfileParameter)iterator.next();
            arrayList.add(opProfileParameter.attributeName);
            arrayList2.add(new Integer(opProfileParameter.attributeValue));
        }
        opProfileParameter = this.genericMaoContext.getMoRepositoryWrapper().lookupType(string);
        if (opProfileParameter != null) {
            while (opProfileParameter.hasMoreElements()) {
                ManagedObject managedObject = opProfileParameter.nextMo();
                if (MoCheck.isMoNotReadable(managedObject)) continue;
                String[] stringArray = new String[]{};
                managedObject.setAttributes(arrayList.toArray(stringArray), arrayList2.toArray(), coordinator);
            }
        }
    }

    private Map createParameterMapByMoType(OpProfile opProfile) {
        HashMap hashMap = new HashMap();
        Iterator iterator = opProfile.profileMoAttributes.iterator();
        while (iterator.hasNext()) {
            OpProfileParameter opProfileParameter = (OpProfileParameter)iterator.next();
            this.addParameterToMap(opProfileParameter, hashMap);
        }
        return hashMap;
    }

    private OpProfile getProfile(String string) throws MoAccessException {
        OpProfile opProfile = null;
        for (int i = 0; i < OpProfilesMaoDefinitions.PROFILE_LIST.length; ++i) {
            if (!OpProfilesMaoDefinitions.PROFILE_LIST[i].profileName.equals(string)) continue;
            opProfile = OpProfilesMaoDefinitions.PROFILE_LIST[i];
            break;
        }
        if (opProfile == null) {
            logger.traceGeneral(THIS_CLASS, "No matching profile \"" + string + "\" found");
            throw new MoAccessException("Profile " + string + " does not exist"){};
        }
        return opProfile;
    }

    private void addParameterToMap(OpProfileParameter opProfileParameter, Map map) {
        List<OpProfileParameter> list;
        if (map.get(opProfileParameter.moType) == null) {
            list = new ArrayList();
            map.put(opProfileParameter.moType, list);
        } else {
            list = (List)map.get(opProfileParameter.moType);
        }
        list.add(opProfileParameter);
        logger.traceDebug(THIS_CLASS, "Adding parameter: " + opProfileParameter.toString());
    }

    public void actionDeactivateProfile(String string, Coordinator coordinator) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "actionDeactivateProfile(profileName[" + string + "], coordinator[" + coordinator + "])");
        OpProfile opProfile = this.getProfile(string);
        logger.traceDebug(THIS_CLASS, "Found profile: " + string);
        List list = this.lockCells();
        this.resetProfileContent(opProfile);
        this.unlockCells(list, coordinator);
        logger.traceReturn(THIS_CLASS, "actionDeactivateProfile()");
    }

    private void resetProfileContent(OpProfile opProfile) throws TransactionRolledBackException, InactiveTransactionException {
        Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
        Coordinator coordinator = control.getCoordinator();
        try {
            this.resetProfileMoAttributes(opProfile, coordinator);
            this.resetProfileSystemConstants(opProfile, coordinator);
            this.sendActionWithCfm("deactivateProfile", coordinator, this.createSignalParameterMap(opProfile.profileName));
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception message: " + (Object)((Object)moAccessException));
            control.getTerminator().rollback();
        }
    }

    private void resetProfileMoAttributes(OpProfile opProfile, Coordinator coordinator) throws MoAccessException {
        MoMetaDataFinder moMetaDataFinder = this.genericMaoContext.getMoMetaDataFinder();
        Map map = this.createParameterMapByMoType(opProfile);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.resetProfileAttrbutesOnAllMoWithMoType(coordinator, moMetaDataFinder, map, string);
        }
    }

    private void resetProfileAttrbutesOnAllMoWithMoType(Coordinator coordinator, MoMetaDataFinder moMetaDataFinder, Map map, String string) throws MoAccessException {
        Object object;
        OpProfileParameter opProfileParameter;
        Map map2 = moMetaDataFinder.getMoData(string).getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ManagedObject> arrayList2 = new ArrayList<ManagedObject>();
        Iterator iterator = ((List)map.get(string)).iterator();
        while (iterator.hasNext()) {
            opProfileParameter = (OpProfileParameter)iterator.next();
            arrayList.add(opProfileParameter.attributeName);
            object = ((AttributeMetaData)map2.get(opProfileParameter.attributeName)).getData().getDefaultValue(moMetaDataFinder);
            arrayList2.add((ManagedObject)object);
        }
        opProfileParameter = this.genericMaoContext.getMoRepositoryWrapper().lookupType(string);
        if (opProfileParameter != null) {
            while (opProfileParameter.hasMoreElements()) {
                object = opProfileParameter.nextMo();
                if (MoCheck.isMoNotReadable(object)) continue;
                String[] stringArray = new String[]{};
                object.setAttributes(arrayList.toArray(stringArray), arrayList2.toArray(), coordinator);
            }
        }
    }

    protected void registerValidators() {
    }
}

