/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.rnh.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactory;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.MissingReferenceException;
import se.ericsson.lte.rbs.omf.common.NoLicenseException;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.exception.AlreadyStartedException;
import se.ericsson.lte.rbs.omf.common.exception.AlreadyStoppedException;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.exception.DeviceDisabledException;
import se.ericsson.lte.rbs.omf.common.helper.IdleModePrioAtReleaseHelper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.AilgAndMbmsActivationCheckWrapper;
import se.ericsson.lte.rbs.omf.common.validator.ArrayValidator;
import se.ericsson.lte.rbs.omf.common.validator.AttributesCorrelationValidator;
import se.ericsson.lte.rbs.omf.common.validator.IdleModePrioAtReleaseRefValidator;
import se.ericsson.lte.rbs.omf.common.validator.MappingInfoValidator;
import se.ericsson.lte.rbs.omf.common.validator.ModificationPeriodValidator;
import se.ericsson.lte.rbs.omf.common.validator.OnlyRegistrationValidator;
import se.ericsson.lte.rbs.omf.common.validator.SameMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SectorCarrierRefValidator;
import se.ericsson.lte.rbs.omf.common.validator.SiMessageValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueCombinationValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.AbstractEUtranCellMaoI;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public abstract class AbstractEUtranCellMaoImplBase
extends AbstractGenericAttributeValidatorMao
implements AvcSubscriber,
AbstractEUtranCellMaoI {
    private static final String AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE = "acBarringForMoSignallingPresent";
    private static final String AC_BARRING_FOR_MO_SIGN_PRESENCE_ATTRIBUTE = "acBarringForMoSignPresence";
    private static final String AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE = "acBarringForMoDataPresent";
    private static final String AC_BARRING_FOR_MO_DATA_PRESENCE_ATTRIBUTE = "acBarringForMoDataPresence";
    private static final String AC_BARRING_FOR_CSFB_PRESENCE_ATTRIBUTE = "acBarringForCsfbPresence";
    private static final String AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE = "acBarringForCsfbPresent";
    private static final String AC_BARRING_FOR_EMERGENCY_ATTRIBUTE = "acBarringForEmergency";
    private static final String AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE = "acBarringForEmergPresence";
    private static final String AC_BARRING_PRESENCE_ATTRIBUTE = "acBarringPresence";
    private static final Integer AC_BARRING_MODE_OFF = Integer.valueOf("0");
    private static final Integer AC_BARRING_MODE_MANUAL = Integer.valueOf("1");
    public static final String Q_QUAL_MIN = "qQualMin";
    public static final String THRESH_SERVING_LOWQ_ATTRIBUTE = "threshServingLowQ";
    public static final String SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE = "systemInformationBlock3";
    public static final String PRIMARY_PLMN_RESERVED_ATTRIBUTE = "primaryPlmnReserved";
    public static final String ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE = "additionalPlmnReservedList";
    public static final String ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE = "additionalPlmnAlarmSupprList";
    public static final String HOSTING_DIGITAL_UNIT_ATTRIBUTE = "hostingDigitalUnit";
    private static final String REPORT_CONFIG_E_UTRA_INTER_FREQ_LB = "ReportConfigEUtraInterFreqLb";
    private static final String REPORT_CONFIG_E_UTRA_INTER_FREQ_MBMS = "ReportConfigEUtraInterFreqMbms";
    private static final String E_UTRAN_CELL_RELATION_ID_ATTRIBUTE = "EUtranCellRelationId";
    private static final String ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE = "arfcnValueEUtranDl";
    private static final String EUTRAN_FREQUENCY_REF_ATTRIBUTE = "eutranFrequencyRef";
    private static final String PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE = "physicalLayerCellIdGroup";
    private static final String PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE = "physicalLayerSubCellId";
    private static final String SI_WINDOW_LENGTH_ATTRIBUTE = "siWindowLength";
    private static final String SI_MAPPING_INFO_ATTRIBUTE = "mappingInfo";
    private static final String SI_PERIODICITY_ATTRIBUTE = "siPeriodicity";
    private static final String MODIFICATION_PERIOD_COEFF_ATTRIBUTE = "modificationPeriodCoeff";
    private static final String DEFAULT_PAGING_CYCLE_ATTRIBUTE = "defaultPagingCycle";
    private static final String ADDITIONAL_PLMN_LIST_ATTRIBUTE = "additionalPlmnList";
    private static final String ADMINISTRATIVE_STATE_ATTRIBUTE = "administrativeState";
    public static final String OPERATIONAL_STATE_ATTRIBUTE = "operationalState";
    public static final String ATTR_SECTOR_CARRIER_REF = "sectorCarrierRef";
    public static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    public static final String ZZZ_TEMPORARY_25_ATTRIBUTE = "zzzTemporary25";
    public static final String ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF = "idleModePrioAtReleaseRef";
    public static final String ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL = "measuredMaxNoOfUsersInCell";
    public static final String ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL = "expectedMaxNoOfUsersInCell";
    public static final int EXPECTED_MAX_NO_OF_USERS_IN_CELL_NOT_USED = -1;
    public static final String ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF = "latestHostingDigitalUnitRef";
    public static final String ATTR_AVAILABILITY_STATUS = "availabilityStatus";
    public static final String ATTR_MAXIMUM_TRANSMISSION_POWER = "maximumTransmissionPower";
    public static final String ATTR_NO_OF_RX_ANTENNAS = "noOfRxAntennas";
    public static final String ATTR_NO_OF_TX_ANTENNAS = "noOfTxAntennas";
    public static final String ATTR_NO_OF_USED_RX_ANTENNAS = "noOfUsedRxAntennas";
    public static final String ATTR_NO_OF_USED_TX_ANTENNAS = "noOfUsedTxAntennas";
    public static final String ATTR_OPERATIONAL_STATE = "operationalState";
    public static final String ATTR_PART_OF_SECTOR_POWER = "partOfSectorPower";
    public static final String ATTR_PRS_ENABLED = "prsEnabled";
    public static final String ATTR_RESERVED_BY = "reservedBy";
    public static final String ATTR_SECTOR_CARRIER_ID = "SectorCarrierId";
    public static final String ATTR_SECTOR_FUNCTION_REF = "sectorFunctionRef";
    private static final String SECTOR_CARRIER_LDN_BASE = "ManagedElement=1,ENodeBFunction=1,SectorCarrier=";
    private static final int MAX_NUMBER_OF_SECTOR_CARRIER = 48;
    public static boolean isOldOss = false;
    private static final Class THIS_CLASS = AbstractEUtranCellMaoImplBase.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EUTRAN_FREQUENCY_MOTYPE = "EUtranFrequency";
    private static final String EUTRAN_CELL_RELATION_MOTYPE = "EUtranCellRelation";
    private static final String EUTRA_NETWORK_LDN = "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1";
    private static final String NEIGHBOR_CELL_REF = "neighborCellRef";
    private static final String EUTRAN_FREQ_RELATION = "EUtranFreqRelation";
    private static final String RDN_1 = "1";
    private static final String ETWS = "Etws";
    private static final String MIMO_SLEEP_FUNCTION = "MimoSleepFunction";
    private static final String REPORT_CONFIG_EUTRA_BAD_COV_PRIM = "ReportConfigEUtraBadCovPrim";
    private static final String REPORT_CONFIG_EUTRA_BAD_COV_SEC = "ReportConfigEUtraBadCovSec";
    private static final String REPORT_CONFIG_EUTRA_BEST_CELL = "ReportConfigEUtraBestCell";
    private static final String REPORT_CONFIG_A1_PRIM = "ReportConfigA1Prim";
    private static final String REPORT_CONFIG_A1_SEC = "ReportConfigA1Sec";
    private static final String REPORT_CONFIG_A4 = "ReportConfigA4";
    private static final String REPORT_CONFIG_A5 = "ReportConfigA5";
    private static final String REPORT_CONFIG_A5_ANR = "ReportConfigA5Anr";
    private static final String REPORT_CONFIG_A5_DL_COMP = "ReportConfigA5DlComp";
    private static final String REPORT_CONFIG_B1_GERAN = "ReportConfigB1Geran";
    private static final String REPORT_CONFIG_B1_UTRA = "ReportConfigB1Utra";
    private static final String REPORT_CONFIG_B2_CDMA_2000 = "ReportConfigB2Cdma2000";
    private static final String REPORT_CONFIG_B2_GERAN = "ReportConfigB2Geran";
    private static final String REPORT_CONFIG_B2_UTRA = "ReportConfigB2Utra";
    private static final String REPORT_CONFIG_EUTRA_BEST_CELL_ANR = "ReportConfigEUtraBestCellAnr";
    private static final String REPORT_CONFIG_EUTRA_IF_BEST_CELL = "ReportConfigEUtraIFBestCell";
    private static final String REPORT_CONFIG_SEARCH = "ReportConfigSearch";
    private static final String REPORT_CONFIG_CSFB_CDMA_2000 = "ReportConfigCsfbCdma2000";
    private static final String REPORT_CONFIG_INTER_RAT_LB = "ReportConfigInterRatLb";
    private static final String REPORT_CONFIG_S_CELL_A1A2 = "ReportConfigSCellA1A2";
    private static final String REPORT_CONFIG_S_CELL_A4 = "ReportConfigSCellA4";
    private static final String REPORT_CONFIG_S_CELL_A6 = "ReportConfigSCellA6";
    private static final String REPORT_CONFIG_B2_CDMA_20001_X_RTT = "ReportConfigB2Cdma20001xRtt";
    private static final String REPORT_CONFIG_CSFB_GERAN = "ReportConfigCsfbGeran";
    private static final String REPORT_CONFIG_CSFB_UTRA = "ReportConfigCsfbUtra";
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final String UL_HARQ_VOLTE_BLER_TARGET_ATTRIBUTE = "ulHarqVolteBlerTarget";
    private static final Integer OLD_MIN_OF_RANGE_OF_UL_HARQ_VOLTE_BLER_TARGET = new Integer(-1);
    private static final Integer NEW_MIN_OF_RANGE_OF_UL_HARQ_VOLTE_BLER_TARGET = new Integer(0);
    private static final String STOP_AILG = "stopAilg";
    private static final String RESULT_ALREADY_STARTED = Integer.toString(0x1010002);
    private static final String RESULT_DEVICE_DISABLED = Integer.toString(0x1010003);
    private static final String RESULT_NO_LICENSE = Integer.toString(0x1010004);
    private static final String RESULT_ALREADY_STOPPED = Integer.toString(0x1010005);
    public static final String CELL_RANGE_ATTRIBUTE = "cellRange";
    private static final int TX_TIMEOUT = 120;

    public AbstractEUtranCellMaoImplBase(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException, ProcessingFailureException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellMaoImplBase()");
        this.registerForAVCNotifications(string2, "operationalState");
        this.registerForAVCNotifications(string2, HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        logger.traceReturn(THIS_CLASS, "EUtranCellMaoImplBase()");
    }

    public AbstractEUtranCellMaoImplBase(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellMaoImplBase()");
        this.registerForAVCNotifications(string, "operationalState");
        this.registerForAVCNotifications(string, HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        logger.traceReturn(THIS_CLASS, "EUtranCellMaoImplBase()");
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "postCreate()");
        this.createSysCreatedTree(coordinator);
        this.createSectorCarrierRefWhenNotContained(attrList, coordinator);
        logger.traceReturn(this.getClass(), "postCreate()");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        GenericMao genericMao;
        logger.traceEnter(this.getClass(), "delete()");
        MoIterator moIterator = this.getChildren();
        String string = this.getClass() + ".delete: " + this.getLocalDistinguishedName() + " cannot be deleted. It has children or subchildren which are not system created.";
        while (moIterator.hasMoreElements()) {
            genericMao = (GenericMao)moIterator.nextMo();
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            if (UE_MEAS_CONTROL.equals(genericMao.getType())) {
                this.deleteAllSystemCreatedChildren((ManagedObject)genericMao, coordinator);
                continue;
            }
            if (moMetaData.isSystemCreated()) {
                genericMao.deleteInternal(coordinator);
                continue;
            }
            logger.info(THIS_CLASS, string);
            throw new ProcessingFailureException(string);
        }
        genericMao = new GenericMao[]{};
        this.setAttribute(ATTR_SECTOR_CARRIER_REF, genericMao, coordinator);
        this.unregisterForAVCNotifications(this.getMoType(), "operationalState");
        this.unregisterForAVCNotifications(this.getMoType(), HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        super.delete(coordinator);
        logger.traceReturn(this.getClass(), "delete()");
    }

    public void actionStartAilg(Coordinator coordinator) throws AlreadyStartedException, DeviceDisabledException, MissingReferenceException, MoAccessException {
        block6: {
            logger.traceEnter(THIS_CLASS, "actionStartAilg()");
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getAttribute("ailgRef", coordinator) == null) {
                String string = "The reference (ailgRef) to the AirIfLoadProfile MO on " + this.getLocalDistinguishedName() + " is not set.";
                throw new MissingReferenceException(this.getType(), string);
            }
            if (AilgAndMbmsActivationCheckWrapper.getInstance().checkIfMbmsIsActivated((ManagedObject)this, coordinator, stringBuffer)) {
                throw new InternalErrorException(this.getType(), stringBuffer.toString());
            }
            try {
                this.sendActionWithCfm("startAilg", null, new TreeMap());
            }
            catch (FroRequestFailedException froRequestFailedException) {
                String string = froRequestFailedException.getVariablesAsString();
                String string2 = this.getResultFromString(string);
                String string3 = ExceptionHelper.getErrorString(string);
                if (RESULT_ALREADY_STARTED.equals(string2)) {
                    logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                    throw new AlreadyStartedException(this.getType(), string3);
                }
                if (RESULT_DEVICE_DISABLED.equals(string2)) {
                    logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                    throw new DeviceDisabledException(this.getType(), string3);
                }
                if (!RESULT_NO_LICENSE.equals(string2)) break block6;
                logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                throw new NoLicenseException(this.getType(), string3);
            }
        }
        logger.traceReturn(THIS_CLASS, "actionStartAilg()");
    }

    public void actionStopAilg(Coordinator coordinator) throws AlreadyStoppedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStopAilg(" + coordinator + ")");
        try {
            this.sendActionWithCfm(STOP_AILG, null, new TreeMap());
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (RESULT_ALREADY_STOPPED.equals(string2)) {
                String string3 = "Ailg is already stopped. Caught exception = " + (Object)((Object)froRequestFailedException);
                logger.traceAbnormal(THIS_CLASS, string3);
                throw new AlreadyStoppedException(this.getType(), string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStopAilg()");
    }

    public void actionSendSIChangeNotification(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSendSIChangeNotification(" + coordinator + ")");
        this.sendActionWithCfm("sendSIChangeNotification", null, new TreeMap());
        logger.traceReturn(THIS_CLASS, "actionSendSIChangeNotification()");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        String string = this.getDownlinkFrequencyAttrName();
        String[] stringArray = new String[]{string, PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE};
        String[] stringArray2 = new String[]{this.getMoType()};
        AbstractAttributeValidator abstractAttributeValidator = new UniqueCombinationValidator(string, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(string, abstractAttributeValidator);
        abstractAttributeValidator = new UniqueCombinationValidator(PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SectorCarrierRefValidator(ATTR_SECTOR_CARRIER_REF);
        this.registerValidator(ATTR_SECTOR_CARRIER_REF, abstractAttributeValidator);
        abstractAttributeValidator = new UniqueCombinationValidator(PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray3 = new String[]{SI_WINDOW_LENGTH_ATTRIBUTE, SI_MAPPING_INFO_ATTRIBUTE, SI_PERIODICITY_ATTRIBUTE};
        abstractAttributeValidator = new SiMessageValidator(SI_WINDOW_LENGTH_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_WINDOW_LENGTH_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SiMessageValidator(SI_MAPPING_INFO_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_MAPPING_INFO_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SiMessageValidator(SI_PERIODICITY_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_PERIODICITY_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray4 = new String[]{MODIFICATION_PERIOD_COEFF_ATTRIBUTE, DEFAULT_PAGING_CYCLE_ATTRIBUTE};
        abstractAttributeValidator = new ModificationPeriodValidator(MODIFICATION_PERIOD_COEFF_ATTRIBUTE, stringArray4, this.genericMaoContext);
        this.registerValidator(MODIFICATION_PERIOD_COEFF_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray5 = new String[]{ADDITIONAL_PLMN_LIST_ATTRIBUTE, ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE};
        this.registerValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, new SameMoTypeValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, false, this.genericMaoContext));
        abstractAttributeValidator = new OnlyRegistrationValidator(ADMINISTRATIVE_STATE_ATTRIBUTE);
        this.registerValidator(ADMINISTRATIVE_STATE_ATTRIBUTE, abstractAttributeValidator);
        this.registerValidator(SI_MAPPING_INFO_ATTRIBUTE, new MappingInfoValidator());
        String[] stringArray6 = new String[]{SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE};
        abstractAttributeValidator = new AttributesCorrelationValidator(Q_QUAL_MIN, stringArray6);
        this.registerValidator(Q_QUAL_MIN, abstractAttributeValidator);
        String[] stringArray7 = new String[]{Q_QUAL_MIN};
        abstractAttributeValidator = new AttributesCorrelationValidator(SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE, stringArray7);
        this.registerValidator(SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE, abstractAttributeValidator);
        this.registerValidator(ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF, new IdleModePrioAtReleaseRefValidator(IdleModePrioAtReleaseHelper.MO_ATTRLIST_DISTRIBUTION_INFO));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }

    private void deleteAllSystemCreatedChildren(ManagedObject managedObject, Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        String string = "deleteAllSystemCreatedChildren for MO [" + managedObject.getLocalDistinguishedName() + "]";
        logger.traceEnter(THIS_CLASS, string);
        MoIterator moIterator = managedObject.getChildren();
        string = managedObject.getLocalDistinguishedName() + " has [" + moIterator.size() + "] children";
        logger.traceDebug(THIS_CLASS, string);
        while (moIterator.hasMoreElements()) {
            GenericMao genericMao = (GenericMao)moIterator.nextMo();
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            string = "Current child[" + genericMao.getLocalDistinguishedName() + "] is system created[" + moMetaData.isSystemCreated() + "]";
            logger.traceDebug(THIS_CLASS, string);
            if (moMetaData.isSystemCreated()) {
                this.deleteAllSystemCreatedChildren((ManagedObject)genericMao, coordinator);
                continue;
            }
            string = THIS_CLASS + "deleteAllSystemCreatedChildren. " + genericMao.getLocalDistinguishedName() + " is not system created.";
            throw new ProcessingFailureException(string);
        }
        ((GenericMao)managedObject).deleteInternal(coordinator);
        logger.traceReturn(THIS_CLASS, "deleteAllSystemCreatedChildren()");
    }

    private void createSysCreatedTree(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.createSysCreatedMo((ManagedObject)this, ETWS, coordinator);
        this.createSysCreatedMo((ManagedObject)this, MIMO_SLEEP_FUNCTION, coordinator);
        ManagedObject managedObject = this.createSysCreatedMo((ManagedObject)this, UE_MEAS_CONTROL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BAD_COV_PRIM, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BAD_COV_SEC, coordinator);
        ManagedObject managedObject2 = this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BEST_CELL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A1_PRIM, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A1_SEC, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A4, coordinator);
        ManagedObject managedObject3 = this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5, coordinator);
        this.createSysCreatedMo(managedObject3, REPORT_CONFIG_A5_ANR, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5_DL_COMP, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B1_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B1_UTRA, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_2000, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_UTRA, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_E_UTRA_INTER_FREQ_LB, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_E_UTRA_INTER_FREQ_MBMS, coordinator);
        this.createSysCreatedMo(managedObject2, REPORT_CONFIG_EUTRA_BEST_CELL_ANR, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_IF_BEST_CELL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_SEARCH, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_CDMA_2000, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_INTER_RAT_LB, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A1A2, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A4, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A6, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_20001_X_RTT, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_UTRA, coordinator);
    }

    private ManagedObject createSysCreatedMo(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(string);
        SystemCreatedMaoFactory systemCreatedMaoFactory = (SystemCreatedMaoFactory)this.genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        return systemCreatedMaoFactory.createSystemMo(managedObject, (AttrList)attrListImpl, RDN_1, null, coordinator);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(name = " + string + ", value=" + object + ")");
        AttributeUtilities.Pair pair = this.setDeprecatedAttribute(string, object, coordinator);
        if (pair != null) {
            super.setAttribute(pair.ldn, pair.value, coordinator);
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes(no of attributes = " + stringArray.length + ")");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            AttributeUtilities.Pair pair = this.setDeprecatedAttribute(string, objectArray[i], coordinator);
            if (pair == null) continue;
            arrayList.add(pair.ldn);
            arrayList2.add(pair.value);
        }
        super.setAttributes(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Object[arrayList2.size()]), coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    private AttributeUtilities.Pair setDeprecatedAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        AttributeUtilities.Pair pair = AttributeUtilities.getPair(string, object);
        if (ADMINISTRATIVE_STATE_ATTRIBUTE.equals(string)) {
            pair = this.handleDeprecatedAdministrativeState(pair, string, object, coordinator);
        } else if (AC_BARRING_PRESENCE_ATTRIBUTE.equals(string)) {
            pair = this.handleSetDeprecatedAcBarringForEmergAttributeInAcBarringPresence((Struct)object, coordinator);
        } else if (this.isDeprecatedAcBarringPresence(string)) {
            pair = this.handleSetDeprecatedAcBarringPresenceAttributeOnCell(string, object, coordinator);
        } else if (UL_HARQ_VOLTE_BLER_TARGET_ATTRIBUTE.equals(string)) {
            pair = this.handleSetDeprecatedUlHarqVolteBlerTarget(string, object);
        }
        pair = this.handleAttributeMovedToSectorCarrier(pair, string, object, coordinator);
        return pair;
    }

    protected Object getDeprecated(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (this.isMovedToSectorCarrier(string)) {
            ManagedObject[] managedObjectArray = this.getSectorCarrierRef(coordinator);
            object = managedObjectArray[0].getAttribute(string, coordinator);
        } else {
            object = AC_BARRING_PRESENCE_ATTRIBUTE.equals(string) ? this.handleGetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(string, coordinator) : (this.isDeprecatedAcBarringPresence(string) ? this.handleGetDeprecatedAcBarringPresenceAttributeOnCell(string, coordinator) : super.getDeprecated(string, coordinator));
        }
        return object;
    }

    private AttributeUtilities.Pair handleSetDeprecatedUlHarqVolteBlerTarget(String string, Object object) throws MoAccessException {
        AttributeUtilities.Pair pair = AttributeUtilities.getPair(string, object);
        pair = OLD_MIN_OF_RANGE_OF_UL_HARQ_VOLTE_BLER_TARGET.equals(object) ? AttributeUtilities.getPair(string, NEW_MIN_OF_RANGE_OF_UL_HARQ_VOLTE_BLER_TARGET) : AttributeUtilities.getPair(string, object);
        return pair;
    }

    private Object handleGetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(String string, Coordinator coordinator) throws MoAccessException {
        StructImpl structImpl = (StructImpl)this.getRawAttribute(string, coordinator);
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl2 = new se.ericsson.crbs.omf.mao.commonmo.StructImpl(structImpl.getNames(), structImpl.getValues());
        Boolean bl = (Boolean)this.getAttribute(AC_BARRING_FOR_EMERGENCY_ATTRIBUTE, coordinator);
        Integer n = AC_BARRING_MODE_OFF;
        if (bl.booleanValue()) {
            n = AC_BARRING_MODE_MANUAL;
        }
        structImpl2.setValue(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE, (Object)n);
        return structImpl2;
    }

    private AttributeUtilities.Pair handleSetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(Struct struct, Coordinator coordinator) throws MoAccessException {
        Integer n = (Integer)struct.getValue(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
        Boolean bl = this.convertAcBarringModeToBoolean(n);
        AttributeUtilities.Pair pair = AttributeUtilities.getPair(AC_BARRING_FOR_EMERGENCY_ATTRIBUTE, bl);
        super.setAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, struct, coordinator);
        return pair;
    }

    private AttributeUtilities.Pair handleSetDeprecatedAcBarringPresenceAttributeOnCell(String string, Object object, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Struct struct = (Struct)super.getAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, coordinator);
        String string2 = this.getReplacedByAcBarringPresenceAttrName(string);
        Integer n = AC_BARRING_MODE_OFF;
        if (((Boolean)object).booleanValue()) {
            n = AC_BARRING_MODE_MANUAL;
        }
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = new se.ericsson.crbs.omf.mao.commonmo.StructImpl(struct.getNames(), struct.getValues());
        structImpl.setValue(string2, (Object)n);
        super.setAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, structImpl, coordinator);
        return null;
    }

    private AttributeUtilities.Pair handleDeprecatedSectorCarrierRelatedAttr(String string, Object object, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getSectorCarrierRef(coordinator);
        managedObjectArray[0].setAttribute(string, object, coordinator);
        return null;
    }

    private AttributeUtilities.Pair handleDeprecatedAdministrativeState(AttributeUtilities.Pair pair, String string, Object object, Coordinator coordinator) throws MoAccessException {
        AttributeUtilities.Pair pair2 = pair;
        pair2 = AttributeUtilities.getPair(string, this.handleAdminState(string, object, coordinator));
        return pair2;
    }

    private Object handleAdminState(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Object object2 = object;
        Integer n = (Integer)this.getAttribute(string, coordinator);
        Integer n2 = (Integer)this.getAttribute("operationalState", coordinator);
        Integer n3 = (Integer)object;
        logger.info(THIS_CLASS, "Start handling of ldn[" + this.getLocalDistinguishedName() + "], [" + string + "=" + n3 + "]");
        if (n3 == 1) {
            object2 = this.subHandleAdminStateUnlocked(object2, n, n2);
        } else if (n3 == 2) {
            object2 = this.subHandleAdminStateShuttingdown(object2, n, n2);
        }
        if (object2 == null) {
            String string2 = "Attribute: administrativeState of Mo:" + this.getLocalDistinguishedName() + " can not set to " + n3 + " current admin(" + n + "),current oper(" + n2 + ")";
            logger.info(THIS_CLASS, string2);
            throw new MoAccessException(string2){};
        }
        return object2;
    }

    private Object subHandleAdminStateUnlocked(Object object, Integer n, Integer n2) {
        Object object2 = object;
        if (n == 2 && n2 == 0) {
            object2 = null;
        }
        return object2;
    }

    private Object subHandleAdminStateShuttingdown(Object object, Integer n, Integer n2) {
        Object object2 = object;
        if (n == 0) {
            object2 = null;
        } else if (n == 1 && n2 == 0) {
            object2 = new Integer(0);
        } else if (n == 2 && n2 == 0) {
            object2 = new Integer(0);
        }
        return object2;
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        if (ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL.equals(string) && -1 != (Integer)object && -1 == (Integer)this.getAttribute(ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL, null)) {
            this.setReadOnlyAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, new Integer(0), coordinator);
        }
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_SOURCE_CELL_OPERATOR, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private Object handleGetDeprecatedAcBarringPresenceAttributeOnCell(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Struct struct = (Struct)super.getAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, coordinator);
        String string2 = this.getReplacedByAcBarringPresenceAttrName(string);
        Integer n = (Integer)struct.getValue(string2);
        Boolean bl = this.convertAcBarringModeToBoolean(n);
        return bl;
    }

    private Boolean convertAcBarringModeToBoolean(Integer n) {
        Boolean bl = Boolean.FALSE;
        if (AC_BARRING_MODE_MANUAL.equals(n)) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    private String getReplacedByAcBarringPresenceAttrName(String string) {
        String string2 = "";
        if (AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_CSFB_PRESENCE_ATTRIBUTE;
        } else if (AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_MO_DATA_PRESENCE_ATTRIBUTE;
        } else if (AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_MO_SIGN_PRESENCE_ATTRIBUTE;
        }
        return string2;
    }

    private boolean isDeprecatedAcBarringPresence(String string) {
        return AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE.equals(string) || AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE.equals(string) || AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE.equals(string);
    }

    private void removeAttributesDuringCreate(AttrList attrList, String string) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n > -1 && AC_BARRING_PRESENCE_ATTRIBUTE.equals(string)) {
            Struct struct = (Struct)attrList.getValue(n);
            try {
                struct.getValue(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        } else if (n != -1) {
            attrList.removeElementAt(n);
            logger.traceDebug(THIS_CLASS, "Remove attribute [" + string + "] from attributeList");
        }
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        isOldOss = AbstractEUtranCellMaoImplBase.judgeIfOldOss(attrList2);
        this.removeAttributesDuringCreate(attrList, HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        this.removeAttributesDuringCreate(attrList, AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE);
        this.removeAttributesDuringCreate(attrList, AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE);
        this.removeAttributesDuringCreate(attrList, AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE);
        this.removeAttributesDuringCreate(attrList, AC_BARRING_PRESENCE_ATTRIBUTE);
        this.removeAttributesDuringCreate(attrList, ATTR_NO_OF_RX_ANTENNAS);
        this.removeAttributesDuringCreate(attrList, ATTR_PART_OF_SECTOR_POWER);
        this.removeAttributesDuringCreate(attrList, ATTR_NO_OF_TX_ANTENNAS);
        this.removeAttributesDuringCreate(attrList, ATTR_SECTOR_FUNCTION_REF);
        this.fixArraySizes(attrList);
        ((AttrListImpl)attrList).addElement(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, (Object)new Integer(0));
        ((AttrListImpl)attrList).addElement(ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF, null);
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    private void fixArraySizes(AttrList attrList) throws NotHandledAttributeTypeException, MoNotFoundException {
        this.fillAdditionalPlmnListWithDefaultValues(attrList);
        this.fillAdditionalPlmnReservedWithDefaultValues(attrList);
        this.fillAdditionalAdditionalPlmnAlarmSupprList(attrList);
    }

    private void fillAdditionalPlmnReservedWithDefaultValues(AttrList attrList) throws NotHandledAttributeTypeException, MoNotFoundException {
        int n = attrList.indexOf(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE);
        if (n >= 0) {
            if (attrList.getValue(n) instanceof Boolean[]) {
                this.fillAdditionalPlmnListWithDefaultValuesBoolean(attrList, n, 5);
            } else {
                this.fillAdditionalPlmnListWithDefaultValuesSmallBoolean(attrList, n, 5);
            }
        }
    }

    private void fillAdditionalAdditionalPlmnAlarmSupprList(AttrList attrList) throws NotHandledAttributeTypeException, MoNotFoundException {
        int n = attrList.indexOf(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE);
        if (n >= 0) {
            if (attrList.getValue(n) instanceof Boolean[]) {
                this.fillAdditionalPlmnListWithDefaultValuesBoolean(attrList, n, 5);
            } else {
                this.fillAdditionalPlmnListWithDefaultValuesSmallBoolean(attrList, n, 5);
            }
        }
    }

    private void fillAdditionalPlmnListWithDefaultValuesBoolean(AttrList attrList, int n, int n2) throws NotHandledAttributeTypeException, MoNotFoundException {
        Boolean[] booleanArray = (Boolean[])attrList.getValue(n);
        Boolean[] booleanArray2 = new Boolean[n2];
        if (booleanArray.length < n2) {
            for (int i = 0; i < n2; ++i) {
                booleanArray2[i] = i < booleanArray.length ? booleanArray[i] : Boolean.FALSE;
            }
            String string = attrList.getName(n);
            ((AttrListImpl)attrList).removeElementAt(n);
            ((AttrListImpl)attrList).addElement(string, (Object)booleanArray2);
        }
    }

    private void fillAdditionalPlmnListWithDefaultValuesSmallBoolean(AttrList attrList, int n, int n2) throws NotHandledAttributeTypeException, MoNotFoundException {
        boolean[] blArray = (boolean[])attrList.getValue(n);
        boolean[] blArray2 = new boolean[n2];
        if (blArray.length < n2) {
            for (int i = 0; i < n2; ++i) {
                blArray2[i] = i < blArray.length ? blArray[i] : false;
            }
            String string = attrList.getName(n);
            ((AttrListImpl)attrList).removeElementAt(n);
            ((AttrListImpl)attrList).addElement(string, (Object)blArray2);
        }
    }

    private void fillAdditionalPlmnListWithDefaultValues(AttrList attrList) throws NotHandledAttributeTypeException, MoNotFoundException {
        int n = attrList.indexOf(ADDITIONAL_PLMN_LIST_ATTRIBUTE);
        if (n >= 0) {
            se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = new se.ericsson.crbs.omf.mao.commonmo.StructImpl();
            structImpl.addElement("mcc", (Object)new Integer(1));
            structImpl.addElement("mnc", (Object)new Integer(1));
            structImpl.addElement("mncLength", (Object)new Integer(2));
            Struct[] structArray = (Struct[])attrList.getValue(n);
            Struct[] structArray2 = new Struct[5];
            if (structArray.length < 5) {
                for (int i = 0; i < 5; ++i) {
                    structArray2[i] = i < structArray.length ? structArray[i] : structImpl;
                }
                ((AttrListImpl)attrList).removeElementAt(n);
                ((AttrListImpl)attrList).addElement(ADDITIONAL_PLMN_LIST_ATTRIBUTE, (Object)structArray2);
            }
        }
    }

    public void actionChangeFrequency(Integer n, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "actionChangeFrequency(earfcn=" + n + ", coordinator=" + coordinator + ")");
        try {
            Integer n2 = (Integer)this.getAttribute(this.getDownlinkFrequencyAttrName(), coordinator);
            if (!n.equals(n2)) {
                ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n2, coordinator);
                this.setRestrictedAttribute(this.getDownlinkFrequencyAttrName(), n, coordinator);
                if (managedObject != null) {
                    ManagedObject managedObject2 = this.createEUtranFrequencyIfNotExists(n, coordinator);
                    this.createOurEUtranFreqRelationIfNotExists(n, coordinator, n2, managedObject2);
                    List list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, EUTRAN_CELL_RELATION_MOTYPE, coordinator);
                    this.removeAllCellRelations(list, coordinator);
                    this.createEUtranFreqRelationsAndCellRelations(list, n, managedObject2, coordinator);
                }
            }
            logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
        }
        catch (Exception exception) {
            String string = ExceptionHelper.appendReason((String)"Unable to perform action changeFrequency due to: ", (Throwable)exception);
            logger.info(THIS_CLASS, string);
            throw new ChangeFrequencyException(string);
        }
    }

    public abstract String getDownlinkFrequencyAttrName();

    private ManagedObject createEUtranFrequencyIfNotExists(Integer n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n, coordinator);
        if (managedObject == null) {
            managedObject = this.createNewEUtranFrequency(n, coordinator);
        }
        return managedObject;
    }

    private void createOurEUtranFreqRelationIfNotExists(Integer n, Coordinator coordinator, Integer n2, ManagedObject managedObject) throws MoAccessException, NoSuchAttributeException {
        ManagedObject managedObject2 = this.findMatchingEUtranFreqRelWithEarfcn(n, coordinator);
        ManagedObject managedObject3 = this.findMatchingEUtranFreqRelWithEarfcn(n2, coordinator);
        if (managedObject2 == null && managedObject3 != null) {
            AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject3, coordinator);
            attrListImpl.addAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, (Object)managedObject);
            managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQ_RELATION, attrListImpl, n.toString(), (ManagedObject)this, coordinator);
        }
    }

    private ManagedObject findMatchingEUtranFrequencyWithEarfcn(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(earfcn=" + n + ", coordiantor=" + coordinator + ")");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(EUTRAN_FREQUENCY_MOTYPE);
        ManagedObject managedObject = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                Integer n2 = (Integer)managedObject2.getAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, coordinator);
                if (!n.equals(n2)) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(matchEutranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject findMatchingEUtranFreqRelWithEarfcn(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingEUtranFreqRelationWithEarfcn(earfcn=" + n + ", coordiantor=" + coordinator + ")");
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2;
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals(EUTRAN_FREQ_RELATION) || !n.equals((managedObject2 = (ManagedObject)managedObject3.getAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, coordinator)).getAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, coordinator))) continue;
            managedObject = managedObject3;
            break;
        }
        logger.traceReturn(THIS_CLASS, "findMatchingEUtranFreqRelationWithEarfcn(matchEutranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject createNewEUtranFrequency(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createNewEUtranFrequency(earfcn=" + n + ")");
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        attrListImpl.addAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, (Object)n);
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(EUTRA_NETWORK_LDN);
        logger.traceReturn(THIS_CLASS, "createNewEUtranFrequency()");
        return ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQUENCY_MOTYPE, attrListImpl, n.toString(), managedObject, coordinator);
    }

    private void removeAllCellRelations(List list, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "removeAllCellRelations(cellRelations(size)=" + list.size() + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            managedObject.delete(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "removeAllCellRelations()");
    }

    private void createEUtranFreqRelationsAndCellRelations(List list, Integer n, ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createEUtranFreqRelations(cellWithCellRelationsPointingToUs(size)=" + list.size() + ", earfcn=" + n + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            ManagedObject managedObject3 = managedObject2.getParent().getParent();
            ManagedObject managedObject4 = this.getFreqRelation(managedObject, managedObject3.getChildren(), coordinator);
            if (managedObject4 == null) {
                string = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject2.getParent(), coordinator);
                string.addAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, (Object)managedObject);
                managedObject4 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQ_RELATION, (AttrListImpl)string, n.toString(), managedObject3, coordinator);
            }
            string = managedObject2.getAttribute(E_UTRAN_CELL_RELATION_ID_ATTRIBUTE, coordinator).toString();
            this.createEUtranCellRelation(managedObject2, managedObject4, string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createEUtranFreqRelations()");
    }

    private ManagedObject getFreqRelation(ManagedObject managedObject, MoIterator moIterator, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3;
            ManagedObject managedObject4 = moIterator.nextMo();
            if (!managedObject4.getType().equals(EUTRAN_FREQ_RELATION) || !(managedObject3 = (ManagedObject)managedObject4.getAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, coordinator)).getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
            managedObject2 = managedObject4;
            break;
        }
        return managedObject2;
    }

    private void createEUtranCellRelation(ManagedObject managedObject, ManagedObject managedObject2, String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createEUtranCellRelation(cellRelation=[" + managedObject.getLocalDistinguishedName() + "], freqRelation=[" + managedObject2.getLocalDistinguishedName() + "])");
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject, coordinator);
        attrListImpl.addAttribute(NEIGHBOR_CELL_REF, (Object)this);
        ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_CELL_RELATION_MOTYPE, attrListImpl, string, managedObject2, coordinator);
        logger.traceReturn(THIS_CLASS, "createEUtranCellRelation()");
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc(ldn[" + string + "], attributeName[" + string2 + "], value[" + object + "])");
        String string3 = this.getLocalDistinguishedName();
        if (string3.equals(string)) {
            this.updateOwnAttributesDueToReceivedAvc(string2, object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    private void updateOwnAttributesDueToReceivedAvc(String string, Object object, Coordinator coordinator) throws MoAccessException {
        if ("operationalState".equals(string)) {
            this.checkAutomaticActionAilg(object, coordinator);
        } else if (HOSTING_DIGITAL_UNIT_ATTRIBUTE.equals(string)) {
            this.updateLatestHostingDigitalUnitDueToReceivedAvc(object, coordinator);
        }
    }

    private void checkAutomaticActionAilg(Object object, Coordinator coordinator) throws MoAccessException {
        if (null != object && 1 == (Integer)object) {
            StringBuffer stringBuffer = new StringBuffer();
            Integer n = (Integer)this.getAttribute(ZZZ_TEMPORARY_25_ATTRIBUTE, coordinator);
            if (null != n && n == 1) {
                if (this.getAttribute("ailgRef", coordinator) == null) {
                    String string = "The reference (ailgRef) to the AirIfLoadProfile MO on " + this.getLocalDistinguishedName() + " is not set.";
                    logger.info(THIS_CLASS, string);
                } else if (AilgAndMbmsActivationCheckWrapper.getInstance().checkIfMbmsIsActivated((ManagedObject)this, coordinator, stringBuffer)) {
                    logger.info(THIS_CLASS, stringBuffer.toString());
                } else {
                    this.actionStartAilg(coordinator);
                }
            }
        }
    }

    private void updateLatestHostingDigitalUnitDueToReceivedAvc(Object object, Coordinator coordinator) throws MoAccessException {
        if (null != object && !(object instanceof NullManagedObject)) {
            this.setReadOnlyAttribute(ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF, object, coordinator);
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem()");
        Integer n = (Integer)this.getAttribute(ADMINISTRATIVE_STATE_ATTRIBUTE, coordinator);
        Integer n2 = (Integer)this.getAttribute("operationalState", coordinator);
        if (null != n && null != n2 && 2 == n && 0 == n2) {
            logger.info(THIS_CLASS, "AdminState will be set to LOCK when current AdminState is SHUT_DOWN and OperationalState is Disable");
            this.setAttribute(ADMINISTRATIVE_STATE_ATTRIBUTE, new Integer(0), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    private void registerForAVCNotifications(String string, String string2) {
        logger.traceEnter(THIS_CLASS, "registerForAVCNotifications(motype[" + string + "], attributeName[" + string2 + "])");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, string2);
        logger.traceReturn(THIS_CLASS, "registerForAVCNotifications()");
    }

    private void unregisterForAVCNotifications(String string, String string2) {
        logger.traceEnter(THIS_CLASS, "unregisterForAVCNotifications(motype[" + string + "], attributeName[" + string2 + "])");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, string, string2);
        logger.traceReturn(THIS_CLASS, "unregisterForAVCNotifications()");
    }

    private void createSectorCarrierRefWhenNotContained(AttrList attrList, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "createSectorCarrierRefWhenNotContained( no of attributes = " + attrList.size() + ")");
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute(ATTR_SECTOR_CARRIER_REF, coordinator);
        if (managedObjectArray.length == 0) {
            logger.traceDebug(THIS_CLASS, "OLD OSS used!");
            int n = attrList.indexOf(ATTR_SECTOR_FUNCTION_REF);
            ManagedObject managedObject = null;
            if (-1 != n) {
                managedObject = (ManagedObject)attrList.getValue(n);
            }
            if (null == managedObject) {
                logger.traceError(THIS_CLASS, "sectorFunctionRef attribute is null in EUtranCell");
                throw new ProcessingFailureException("sectorFunctionRef attribute is null in EUtranCell");
            }
            ManagedObject managedObject2 = this.findOrphanSectorCarrier(managedObject, coordinator);
            if (managedObject2 == null) {
                this.createSectorCarrierMoSetAttribute(attrList, coordinator);
            } else {
                ManagedObject[] managedObjectArray2 = new ManagedObject[]{managedObject2};
                this.setAttribute(ATTR_SECTOR_CARRIER_REF, managedObjectArray2, coordinator);
                logger.traceDebug(THIS_CLASS, "EUtranCell.sectorCarrierRef have been auto set to orphanSectorCarrier for backward compatible");
            }
        }
        logger.traceReturn(THIS_CLASS, "createSectorCarrierRefWhenNotContained()");
    }

    public static boolean judgeIfOldOss(AttrList attrList) throws NotHandledAttributeTypeException, MoNotFoundException {
        boolean bl = false;
        int n = attrList.indexOf(ATTR_SECTOR_FUNCTION_REF);
        ManagedObject managedObject = null;
        if (-1 != n && null != (managedObject = (ManagedObject)attrList.getValue(n))) {
            logger.traceDebug(THIS_CLASS, "Create sectorCarrier automaticlly");
            bl = true;
        }
        return bl;
    }

    private AttrListImpl getAttrListForSectorCarrier(AttrList attrList) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        this.setSpecificAttributeForSectorCarrier(attrListImpl, attrList, ATTR_NO_OF_RX_ANTENNAS);
        this.setSpecificAttributeForSectorCarrier(attrListImpl, attrList, ATTR_NO_OF_TX_ANTENNAS);
        this.setSpecificAttributeForSectorCarrier(attrListImpl, attrList, ATTR_PART_OF_SECTOR_POWER);
        this.setSpecificAttributeForSectorCarrier(attrListImpl, attrList, ATTR_SECTOR_FUNCTION_REF);
        return attrListImpl;
    }

    private void setSpecificAttributeForSectorCarrier(AttrListImpl attrListImpl, AttrList attrList, String string) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (-1 != n) {
            attrListImpl.addAttribute(string, attrList.getValue(n));
        }
    }

    private int findValidRdnForSectorCarrier() {
        int n;
        for (n = 1; n < 48; ++n) {
            String string = SECTOR_CARRIER_LDN_BASE + Integer.toString(n);
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string);
            if (null == managedObject) break;
        }
        return n;
    }

    private boolean isMovedToSectorCarrier(String string) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ATTR_NO_OF_RX_ANTENNAS);
        arrayList.add(ATTR_NO_OF_TX_ANTENNAS);
        arrayList.add(ATTR_SECTOR_FUNCTION_REF);
        arrayList.add(ATTR_MAXIMUM_TRANSMISSION_POWER);
        arrayList.add(ATTR_NO_OF_USED_RX_ANTENNAS);
        arrayList.add(ATTR_NO_OF_USED_TX_ANTENNAS);
        arrayList.add(ATTR_PART_OF_SECTOR_POWER);
        if (arrayList.contains(string)) {
            bl = true;
        }
        return bl;
    }

    private ManagedObject[] getSectorCarrierRef(Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute(ATTR_SECTOR_CARRIER_REF, coordinator);
        if (null == managedObjectArray[0]) {
            logger.info(THIS_CLASS, "getSectorCarrierRef(), sectorCarrierRef[0] is null");
            throw new MoAccessException("getSectorCarrierRef(), sectorCarrierRef[0] is null"){};
        }
        return managedObjectArray;
    }

    private ManagedObject findOrphanSectorCarrier(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject2 = null;
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(ATTR_RESERVED_BY, coordinator);
        if (null != managedObjectArray) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject[] managedObjectArray2;
                ManagedObject managedObject3 = managedObjectArray[i];
                if (!MO_TYPE_SECTOR_CARRIER.equalsIgnoreCase(managedObject3.getType()) || (managedObjectArray2 = (ManagedObject[])managedObject3.getAttribute(ATTR_RESERVED_BY, coordinator)).length != 0) continue;
                managedObject2 = managedObject3;
            }
        }
        return managedObject2;
    }

    private void createSectorCarrierMoSetAttribute(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(MO_TYPE_SECTOR_CARRIER);
        GenericMaoFactory genericMaoFactory = (GenericMaoFactory)this.genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        if (genericMaoFactory == null) {
            logger.traceError(THIS_CLASS, "Mo Factory not found SectorCarrier");
            throw new ProcessingFailureException("Mo Factory not found SectorCarrier");
        }
        AttrListImpl attrListImpl = this.getAttrListForSectorCarrier(attrList);
        int n = this.findValidRdnForSectorCarrier();
        ManagedObject managedObject = this.getParent();
        ManagedObject managedObject2 = genericMaoFactory.createMo(managedObject, (AttrList)attrListImpl, Integer.toString(n), null, coordinator);
        if (null == managedObject2) {
            logger.traceError(THIS_CLASS, "createMo SectorCarrier failed!");
            throw new ProcessingFailureException("createMo SectorCarrier failed!");
        }
        ManagedObject[] managedObjectArray = new ManagedObject[]{managedObject2};
        this.setAttribute(ATTR_SECTOR_CARRIER_REF, managedObjectArray, coordinator);
        logger.traceDebug(THIS_CLASS, "EUtranCell.sectorCarrierRef have been auto set to auto created SectorCarrier Mo for backward compatible");
    }

    private AttributeUtilities.Pair handleAttributeMovedToSectorCarrier(AttributeUtilities.Pair pair, String string, Object object, Coordinator coordinator) throws MoAccessException {
        AttributeUtilities.Pair pair2 = pair;
        if (this.isMovedToSectorCarrier(string)) {
            pair2 = this.handleDeprecatedSectorCarrierRelatedAttr(string, object, coordinator);
        }
        return pair2;
    }

    public void setMeasuredMaxNoOfUsersInCell(int n) throws InactiveTransactionException, TransactionRolledBackException {
        logger.traceEnter(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
        Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
        Coordinator coordinator = control.getCoordinator();
        try {
            Integer n2 = (Integer)this.getAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, coordinator);
            if (n > n2) {
                logger.traceDebug(THIS_CLASS, "New measuredMaxNoOfUsersInCell value = " + n + "is greater than the old value = " + n2);
                this.setReadOnlyAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, new Integer(n), coordinator);
                control.getTerminator().commit();
            }
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception message: " + (Object)((Object)moAccessException));
            control.getTerminator().rollback();
        }
        logger.traceReturn(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
    }
}

