/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.rnh.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.DateTimeHelper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.SameFreqRefInExternalCellRelationValidator;
import se.ericsson.lte.rbs.omf.common.validator.SiblingSameMoTypeValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public abstract class AbstractExternalEUtranCellMaoImplBase
extends AbstractGenericAttributeValidatorMao {
    public static final Integer PCI_CONFLICT_NO = new Integer(0);
    public static final Integer PCI_CONFLICT_YES = new Integer(2);
    public static final Integer PCI_CONFLICT_YES_CONFLICTING_CELL = new Integer(3);
    public static final String PCI_CONFLICT = "pciConflict";
    private static final String EUTRAN_FREQUENCY_MOTYPE = "EUtranFrequency";
    private static final String EUTRAN_CELL_RELATION_MOTYPE = "EUtranCellRelation";
    private static final String EUTRAN_FREQ_RELATION = "EUtranFreqRelation";
    private static final String EUTRA_NETWORK_LDN = "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1";
    private static final String ADDITIONAL_FREQBAND_LIST = "additionalFreqBandList";
    protected static final String EUTRAN_FREQUENCY_REF = "eutranFrequencyRef";
    private static final String NEIGHBOR_CELL_REF = "neighborCellRef";
    private static final String LOCAL_CELL_ID = "localCellId";
    private static final String E_UTRAN_CELL_RELATION_ID = "EUtranCellRelationId";
    private static final String OPERATION_CREATE = "create";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION = "operation";
    private static final String LDN = "ldn";
    private static final String SUCCESS = "success";
    private static final Class THIS_CLASS = AbstractExternalEUtranCellMaoImplBase.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public AbstractExternalEUtranCellMaoImplBase(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException, AttrValueNotUniqueException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ExternalEUtranCellMaoImplBase()");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR, AttributeUtilities.LAST_MODIFICATION_EUTRAN_NOT_MODIFIED, coordinator);
        logger.traceReturn(THIS_CLASS, "ExternalEUtranCellMaoImplBase()");
    }

    public AbstractExternalEUtranCellMaoImplBase(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ExternalEUtranCellMaoImplBase(recover)");
        logger.traceReturn(THIS_CLASS, "ExternalEUtranCellMaoImplBase(recover)");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addElement("createdBy", (Object)AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR);
        ((AttrListImpl)attrList).addElement("lastModification", (Object)AttributeUtilities.LAST_MODIFICATION_EUTRAN_NOT_MODIFIED);
        ((AttrListImpl)attrList).addElement("freqBand", (Object)new Integer(0));
        Integer[] integerArray = new Integer[]{new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        ((AttrListImpl)attrList).addElement(ADDITIONAL_FREQBAND_LIST, (Object)integerArray);
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    public void actionChangeFrequency(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionChangeFrequency(earfcn=" + n + ", coordinator=" + coordinator + ")");
        ArrayList arrayList = new ArrayList();
        ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n, coordinator);
        if (managedObject == null) {
            managedObject = this.createNewUtranFrequency(n, arrayList, coordinator);
        }
        this.setEUtranFrequencyRefAttribute(managedObject, coordinator);
        List list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, EUTRAN_CELL_RELATION_MOTYPE, coordinator);
        this.removeAllCellRelations(list, arrayList, coordinator);
        this.createEUtranFreqRelations(list, n, managedObject, arrayList, coordinator);
        Integer[] integerArray = new Integer[]{new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        this.setAttributeWithoutValidation(ADDITIONAL_FREQBAND_LIST, integerArray, coordinator);
        logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
    }

    public Struct[] actionPnpChangeFrequency(int n, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "actionPnpChangeFrequency(earfcn=" + n + ", coordinator=" + coordinator + ")");
        ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n, coordinator);
        ArrayList arrayList = new ArrayList();
        List list = null;
        try {
            list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, EUTRAN_CELL_RELATION_MOTYPE, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new ChangeFrequencyException("Could not read references to this MO: " + moAccessException.toString());
        }
        if (managedObject == null) {
            try {
                managedObject = this.createNewUtranFrequency(n, arrayList, coordinator);
            }
            catch (ChangeFrequencyException changeFrequencyException) {
                this.removeAllCellRelations(list, arrayList, coordinator);
                try {
                    this.delete(coordinator);
                    this.addPerformedOperation(arrayList, this.getLocalDistinguishedName(), OPERATION_DELETE, true);
                }
                catch (MoAccessException moAccessException) {
                    throw new ChangeFrequencyException("Could not delete MO [" + this.getLocalDistinguishedName() + "]. Got exception:" + moAccessException.toString());
                }
            }
        }
        if (managedObject != null) {
            this.removeAllCellRelations(list, arrayList, coordinator);
            this.setEUtranFrequencyRefAttribute(managedObject, coordinator);
            try {
                this.createEUtranFreqRelations(list, n, managedObject, arrayList, coordinator);
            }
            catch (ChangeFrequencyException changeFrequencyException) {
                // empty catch block
            }
        }
        logger.traceReturn(THIS_CLASS, "actionPnpChangeFrequency()");
        return arrayList.toArray(new Struct[arrayList.size()]);
    }

    private void addPerformedOperation(List list, String string, String string2, boolean bl) {
        logger.traceEnter(THIS_CLASS, "addPerformedOperation(ldn=" + string + ", operation=" + string2 + ", success=" + bl + ")");
        StructImpl structImpl = new StructImpl();
        structImpl.addElement(LDN, (Object)string);
        structImpl.addElement(OPERATION, (Object)string2);
        structImpl.addElement(SUCCESS, (Object)bl);
        list.add(structImpl);
        logger.traceReturn(THIS_CLASS, "addPerformedOperation()");
    }

    private ManagedObject findMatchingEUtranFrequencyWithEarfcn(int n, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(earfcn=" + n + ")");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(EUTRAN_FREQUENCY_MOTYPE);
        ManagedObject managedObject = null;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            try {
                Integer n2 = (Integer)managedObject2.getAttribute("arfcnValueEUtranDl", coordinator);
                if (n2 != n) continue;
                managedObject = managedObject2;
                break;
            }
            catch (MoAccessException moAccessException) {
                throw new ChangeFrequencyException("Could not read attribute arfcnValueEUtranDl from MO " + managedObject2.getLocalDistinguishedName());
            }
        }
        logger.traceReturn(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(matchEutranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject createNewUtranFrequency(int n, List list, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "createNewUtranFrequency(earfcn=" + n + ")");
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        Integer n2 = new Integer(n);
        attrListImpl.addAttribute("arfcnValueEUtranDl", (Object)n2);
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(EUTRA_NETWORK_LDN);
        logger.traceReturn(THIS_CLASS, "createNewUtranFrequency()");
        return this.createMo(EUTRAN_FREQUENCY_MOTYPE, managedObject, Integer.toString(n), attrListImpl, list, coordinator, null);
    }

    private void setEUtranFrequencyRefAttribute(ManagedObject managedObject, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "setEUtranFrequencyRefAttribute(eutranFrequency=" + managedObject.getLocalDistinguishedName() + ")");
        try {
            this.setAttribute(EUTRAN_FREQUENCY_REF, managedObject, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new ChangeFrequencyException("Caught exception when setting new reference on attribute eutranFrequencyRef: " + moAccessException.toString());
        }
        logger.traceReturn(THIS_CLASS, "setEUtranFrequencyRefAttribute()");
    }

    private void removeAllCellRelations(List list, List list2, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "removeAllCellRelations(cellRelations(size)=" + list.size() + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            try {
                managedObject.delete(coordinator);
                this.addPerformedOperation(list2, managedObject.getLocalDistinguishedName(), OPERATION_DELETE, true);
            }
            catch (MoAccessException moAccessException) {
                throw new ChangeFrequencyException("Could not delete EUtranCellRelation: " + managedObject.toString() + ", Exception: " + moAccessException.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "removeAllCellRelations()");
    }

    private void createEUtranFreqRelations(List list, int n, ManagedObject managedObject, List list2, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "createEUtranFreqRelations(cellWithCellRelationsPointingToUs(size)=" + list.size() + ", earfcn=" + n + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            ManagedObject managedObject3 = managedObject2.getParent();
            ManagedObject managedObject4 = managedObject3.getParent();
            ManagedObject managedObject5 = this.getFreqRelation(managedObject, managedObject4.getChildren(), coordinator);
            if (managedObject5 == null) {
                object = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject3, coordinator);
                object.addAttribute(EUTRAN_FREQUENCY_REF, (Object)managedObject);
                managedObject5 = this.createMo(EUTRAN_FREQ_RELATION, managedObject4, Integer.toString(n), (AttrListImpl)object, list2, coordinator, null);
            }
            try {
                object = managedObject2.getAttribute(E_UTRAN_CELL_RELATION_ID, coordinator).toString();
                this.createEUtranCellRelation(managedObject2, managedObject5, (String)object, list2, coordinator);
            }
            catch (Exception exception) {
                throw new ChangeFrequencyException("Could not read EUtranCellRelationIdattribute, Exception: " + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "createEUtranFreqRelations()");
    }

    private ManagedObject getFreqRelation(ManagedObject managedObject, MoIterator moIterator, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "getFreqRelation()");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals(EUTRAN_FREQ_RELATION)) continue;
            try {
                ManagedObject managedObject4 = (ManagedObject)managedObject3.getAttribute(EUTRAN_FREQUENCY_REF, coordinator);
                if (!managedObject4.getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
                managedObject2 = managedObject3;
                break;
            }
            catch (MoAccessException moAccessException) {
                throw new ChangeFrequencyException("Could not get attribute eutranFrequencyRef from LDN: " + managedObject3.toString() + ", Exception: " + moAccessException.toString());
            }
        }
        logger.traceEnter(THIS_CLASS, "getFreqRelation()");
        return managedObject2;
    }

    private void createEUtranCellRelation(ManagedObject managedObject, ManagedObject managedObject2, String string, List list, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "createEUtranCellRelation(cellRelation=[" + managedObject.getLocalDistinguishedName() + "], freqRelation=[" + managedObject2.getLocalDistinguishedName() + "])");
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject, coordinator);
        attrListImpl.addAttribute(NEIGHBOR_CELL_REF, (Object)this);
        this.createMo(EUTRAN_CELL_RELATION_MOTYPE, managedObject2, string, attrListImpl, list, coordinator, managedObject);
        logger.traceReturn(THIS_CLASS, "createEUtranCellRelation()");
    }

    private ManagedObject createMo(String string, ManagedObject managedObject, String string2, AttrListImpl attrListImpl, List list, Coordinator coordinator, ManagedObject managedObject2) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "createMo(moType=" + string + ", parent=" + managedObject.getLocalDistinguishedName() + ", identity=" + string2 + ")");
        try {
            ManagedObject managedObject3 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, string, attrListImpl, string2, managedObject, coordinator);
            this.addPerformedOperation(list, managedObject3.getLocalDistinguishedName(), OPERATION_CREATE, true);
            this.setTimeParameters(managedObject3, coordinator, managedObject2);
            logger.traceReturn(THIS_CLASS, "createMo(mo=" + managedObject3.getLocalDistinguishedName() + ")");
            return managedObject3;
        }
        catch (MoAccessException moAccessException) {
            String string3 = managedObject.getLocalDistinguishedName() + "," + string + "=" + string2;
            this.addPerformedOperation(list, string3, OPERATION_CREATE, false);
            throw new ChangeFrequencyException("Could not create new MO [" + string3 + "]. Got exception: " + moAccessException.toString());
        }
    }

    private void setTimeParameters(ManagedObject managedObject, Coordinator coordinator, ManagedObject managedObject2) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setTimeParameters()");
        GenericMao genericMao = (GenericMao)managedObject;
        String[] stringArray = ChangeFrequencyHelper.getInstance().getAttributesToRead(this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType()).getAttributes(), genericMao.getType(), true);
        if (managedObject2 != null && managedObject2.getAttribute("createdBy", coordinator).toString().equalsIgnoreCase(AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR.toString())) {
            this.setReadOnlyAttributeIfItExist(genericMao, "createdBy", AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR, stringArray, coordinator);
        } else {
            this.setReadOnlyAttributeIfItExist(genericMao, "createdBy", AttributeUtilities.CREATED_BY_EUTRAN_X2, stringArray, coordinator);
        }
        this.setReadOnlyAttributeIfItExist(genericMao, "lastModification", AttributeUtilities.LAST_MODIFICATION_EUTRAN_NOT_MODIFIED, stringArray, coordinator);
        this.setReadOnlyAttributeIfItExist(genericMao, "timeOfCreation", DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"), stringArray, coordinator);
        logger.traceReturn(THIS_CLASS, "setTimeParameters()");
    }

    private void setReadOnlyAttributeIfItExist(GenericMao genericMao, String string, Object object, String[] stringArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setReadOnlyAttributeIfItExist()");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            genericMao.setReadOnlyAttribute(string, object, coordinator);
            break;
        }
        logger.traceReturn(THIS_CLASS, "setReadOnlyAttributeIfItExist()");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        this.registerValidator(LOCAL_CELL_ID, new SiblingSameMoTypeValidator(LOCAL_CELL_ID, true, this.genericMaoContext));
        this.registerValidator(EUTRAN_FREQUENCY_REF, new SameFreqRefInExternalCellRelationValidator(EUTRAN_FREQUENCY_REF));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_EUTRAN_OPERATOR_MODIFICATION, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preDelete()");
        AttributeUtilities.setModificationAttrAtDelete(this, coordinator);
        this.handlePciConflict(coordinator);
        super.preDelete(coordinator);
        logger.traceReturn(THIS_CLASS, "preDelete()");
    }

    private void handlePciConflict(Coordinator coordinator) throws MoAccessException {
        Integer[] integerArray = (Integer[])this.getAttribute(PCI_CONFLICT, coordinator);
        boolean bl = false;
        for (int i = 0; i < integerArray.length; ++i) {
            if (!integerArray[i].equals(PCI_CONFLICT_YES) && !integerArray[i].equals(PCI_CONFLICT_YES_CONFLICTING_CELL)) continue;
            bl = true;
            integerArray[i] = PCI_CONFLICT_NO;
        }
        if (bl) {
            this.setAttribute(PCI_CONFLICT, integerArray, coordinator);
        }
    }
}

