/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.rnh.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;

public class ChangeFrequencyHelper {
    private static final Class THIS_CLASS = ChangeFrequencyHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public static ChangeFrequencyHelper getInstance() {
        return new ChangeFrequencyHelper();
    }

    public ManagedObject createMo(GenericMaoContext genericMaoContext, String string, AttrListImpl attrListImpl, String string2, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createMo(): moType=" + string);
        MoMetaData moMetaData = genericMaoContext.getMoMetaDataFinder().getMoData(string);
        MaoFactory maoFactory = genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        ManagedObject managedObject2 = maoFactory.createMo(managedObject, (AttrList)attrListImpl, string2, null, coordinator);
        logger.traceReturn(THIS_CLASS, "createMo()");
        return managedObject2;
    }

    public AttrListImpl copyAttributes(GenericMaoContext genericMaoContext, ManagedObject managedObject, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "copyAttributes()");
        AttrListImpl attrListImpl = new AttrListImpl(genericMaoContext.getMoRepositoryWrapper());
        String string = managedObject.getType();
        String[] stringArray = this.getAttributesToRead(genericMaoContext.getMoMetaDataFinder().getMoData(string).getAttributes(), string, false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                Object object = managedObject.getAttribute(stringArray[i], coordinator);
                attrListImpl.addAttribute(string2, object);
                logger.traceDebug(THIS_CLASS, "Copy attribute [" + string2 + "] with value [" + object + "]");
                continue;
            }
            catch (MoAccessException moAccessException) {
                throw new ChangeFrequencyException("Could not read attribute [" + string2 + "] from MO [" + managedObject.toString() + "]. Got exception: " + moAccessException.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "copyAttributes()");
        return attrListImpl;
    }

    public String[] getAttributesToRead(Map map, String string, boolean bl) {
        logger.traceEnter(THIS_CLASS, "getAttributesToRead(moType[" + string + "], getAllParameters[" + bl + "])");
        Iterator iterator = map.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AttributeMetaData attributeMetaData = (AttributeMetaData)map.get(string2);
            if (bl) {
                arrayList.add(string2);
                continue;
            }
            if (attributeMetaData.isReadOnly() || attributeMetaData.isPmAttribute() || string2.equals(string + "Id") || string2.endsWith("Ref")) continue;
            arrayList.add(string2);
        }
        logger.traceReturn(THIS_CLASS, "getAttributesToRead(Number of attributes to read: " + arrayList.size() + ")");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public List findReferensesToMo(ManagedObject managedObject, String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "findReferensesToMo()");
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute("reservedBy", coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            String string2 = managedObjectArray[i].getType();
            if (!string.equals(string2)) continue;
            arrayList.add(managedObjectArray[i]);
        }
        logger.traceReturn(THIS_CLASS, "findReferensesToMo()");
        return arrayList;
    }
}

