/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.rnh.common;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.transactionlistener.TransactionTypeList;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.lte.rbs.omf.common.DateTimeHelper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.UniqueCombinationValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public class ExternalUtranCellBaseMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final String UTRAN_FREQUENCY = "UtranFrequency";
    private static final String UTRAN_CELL_RELATION = "UtranCellRelation";
    private static final String UTRAN_FREQ_RELATION = "UtranFreqRelation";
    private static final String UTRA_NETWORK_LDN = "ManagedElement=1,ENodeBFunction=1,UtraNetwork=1";
    private static final String ARFCN_VALUE_UTRAN_DL = "arfcnValueUtranDl";
    private static final String ACTION_CHANGE_FREQUENCY_ERR_MSG = "Unable to perform action changeFrequency due to: ";
    private static final String PLMN_IDENTITY = "plmnIdentity";
    private static final String CELL_IDENTITY = "cellIdentity";
    private static final String UTRAN_CELL_RELATION_ID = "UtranCellRelationId";
    private static final Class THIS_CLASS = ExternalUtranCellBaseMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ExternalUtranCellBaseMaoImpl(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor ExternalUtranCellTDDMaoImpl()");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_IRAT_OPERATOR, AttributeUtilities.LAST_MODIFICATION_UTRAN_NOT_MODIFIED, coordinator);
        logger.traceReturn(THIS_CLASS, "Constructor ExternalUtranCellTDDMaoImpl()");
    }

    public ExternalUtranCellBaseMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor ExternalUtranCellFDDMaoImpl(recover)");
        logger.traceReturn(THIS_CLASS, "Constructor ExternalUtranCellFDDMaoImpl(recover)");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        this.setModificationAttributes(string, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preDelete()");
        super.preDelete(coordinator);
        this.setModificationAttributes("", coordinator);
        logger.traceReturn(THIS_CLASS, "preDelete()");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_OPERATOR);
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    protected void registerValidators() {
        String[] stringArray = new String[]{CELL_IDENTITY, PLMN_IDENTITY};
        String[] stringArray2 = new String[]{this.getMoType()};
        this.registerValidator(CELL_IDENTITY, new UniqueCombinationValidator(CELL_IDENTITY, stringArray, stringArray2, this.genericMaoContext));
        this.registerValidator(PLMN_IDENTITY, new UniqueCombinationValidator(PLMN_IDENTITY, stringArray, stringArray2, this.genericMaoContext));
    }

    private void setModificationAttributes(String string, Coordinator coordinator) throws MoAccessException {
        if (!(string.equals("timeOfLastModification") || string.equals("lastModification") || string.equals("timeOfCreation") || string.equals("createdBy"))) {
            this.setReadOnlyAttribute("timeOfLastModification", DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"), coordinator);
            if (!TransactionTypeList.getInstance().isNonBlocking(coordinator)) {
                this.setReadOnlyAttribute("lastModification", AttributeUtilities.LAST_MODIFICATION_UTRAN_OPERATOR_MODIFICATION, coordinator);
            }
        }
    }

    public void actionChangeFrequency(Integer n, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "actionChangeFrequency(" + n + ")");
        try {
            if (this.frequencyChanged(n, coordinator)) {
                ManagedObject managedObject = this.createNewUtranFrequencyIfNeeded(n, coordinator);
                ManagedObject managedObject2 = this.createExternalUtranCellFdd(managedObject, coordinator);
                List list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, UTRAN_CELL_RELATION, coordinator);
                if (!list.isEmpty()) {
                    List list2 = ChangeFrequencyHelper.getInstance().findReferensesToMo(managedObject, UTRAN_FREQ_RELATION, coordinator);
                    this.createUtranCellRelationsAndParents(n, managedObject, managedObject2, list, list2, coordinator);
                }
                this.deleteOldMos(coordinator, list);
            }
        }
        catch (NotUniqueIdException notUniqueIdException) {
            throw new ChangeFrequencyException(notUniqueIdException.getMessage());
        }
        catch (MoAccessException moAccessException) {
            String string = ExceptionHelper.appendReason((String)ACTION_CHANGE_FREQUENCY_ERR_MSG, (Throwable)moAccessException);
            logger.info(THIS_CLASS, string);
            throw new ChangeFrequencyException(string);
        }
        logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
    }

    private boolean frequencyChanged(Integer n, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = false;
        Integer n2 = (Integer)this.getParent().getAttribute(ARFCN_VALUE_UTRAN_DL, coordinator);
        if (!n.equals(n2)) {
            bl = true;
        }
        return bl;
    }

    private ManagedObject createNewUtranFrequencyIfNeeded(Integer n, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        ManagedObject managedObject = null;
        managedObject = this.findUtranFreqWithCorrectFreq(n, coordinator);
        String string = n.toString();
        if (managedObject == null) {
            ManagedObject managedObject2 = moRepositoryWrapper.lookup(UTRA_NETWORK_LDN);
            AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
            attrListImpl.addAttribute(ARFCN_VALUE_UTRAN_DL, (Object)n);
            managedObject = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, UTRAN_FREQUENCY, attrListImpl, string, managedObject2, coordinator);
        }
        return managedObject;
    }

    private ManagedObject findUtranFreqWithCorrectFreq(Integer n, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject = null;
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(UTRAN_FREQUENCY);
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            Integer n2 = (Integer)managedObject2.getAttribute(ARFCN_VALUE_UTRAN_DL, coordinator);
            if (n.intValue() != n2.intValue()) continue;
            managedObject = managedObject2;
            break;
        }
        return managedObject;
    }

    private ManagedObject createExternalUtranCellFdd(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NotUniqueIdException {
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        String string = this.getRdnId(coordinator);
        String string2 = managedObject.getLocalDistinguishedName() + "," + this.getMoType() + "=" + string;
        ManagedObject managedObject2 = moRepositoryWrapper.lookup(string2);
        if (managedObject2 != null) {
            String string3 = "ExternalUtranCell already exists with LDN: " + string2;
            logger.info(THIS_CLASS, string3);
            throw new NotUniqueIdException(string3);
        }
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, (ManagedObject)this, coordinator);
        managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, this.getMoType(), attrListImpl, string, managedObject, coordinator);
        return managedObject2;
    }

    private void createUtranCellRelationsAndParents(Integer n, ManagedObject managedObject, ManagedObject managedObject2, List list, List list2, Coordinator coordinator) throws MoAccessException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject3 = (ManagedObject)iterator.next();
            ManagedObject managedObject4 = this.createUtranFreqRelationIfNeeded(n, managedObject, managedObject3, list2, coordinator);
            String string = managedObject3.getAttribute(UTRAN_CELL_RELATION_ID, coordinator).toString();
            this.createUtranCellRelation(managedObject2, managedObject4, string, coordinator);
        }
    }

    private ManagedObject createUtranFreqRelationIfNeeded(Integer n, ManagedObject managedObject, ManagedObject managedObject2, List list, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject3 = null;
        ManagedObject managedObject4 = managedObject2.getParent();
        ManagedObject managedObject5 = managedObject4.getParent();
        managedObject3 = this.findUtranFreqRelation(list, managedObject5);
        if (managedObject3 == null) {
            managedObject3 = this.createUtranFreqRelation(n, managedObject4, managedObject, managedObject5, coordinator);
        }
        return managedObject3;
    }

    private ManagedObject findUtranFreqRelation(List list, ManagedObject managedObject) {
        ManagedObject managedObject2 = null;
        Iterator iterator = list.iterator();
        String string = managedObject.getLocalDistinguishedName();
        while (iterator.hasNext()) {
            ManagedObject managedObject3 = (ManagedObject)iterator.next();
            String string2 = managedObject3.getParent().getLocalDistinguishedName();
            if (!string.equals(string2)) continue;
            managedObject2 = managedObject3;
            break;
        }
        return managedObject2;
    }

    private ManagedObject createUtranFreqRelation(Integer n, ManagedObject managedObject, ManagedObject managedObject2, ManagedObject managedObject3, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject4 = null;
        String string = n.toString();
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject, coordinator);
        attrListImpl.addAttribute("utranFrequencyRef", (Object)managedObject2);
        managedObject4 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, UTRAN_FREQ_RELATION, attrListImpl, string, managedObject3, coordinator);
        return managedObject4;
    }

    private void createUtranCellRelation(ManagedObject managedObject, ManagedObject managedObject2, String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        AttrListImpl attrListImpl = new AttrListImpl(moRepositoryWrapper);
        attrListImpl.addAttribute("externalUtranCellFDDRef", (Object)managedObject);
        ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, UTRAN_CELL_RELATION, attrListImpl, string, managedObject2, coordinator);
    }

    private void deleteOldMos(Coordinator coordinator, List list) throws MoHasChildrenException, MoAccessException {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ManagedObject managedObject = (ManagedObject)iterator.next();
                managedObject.delete(coordinator);
            }
        }
        this.delete(coordinator);
    }

    private static class NotUniqueIdException
    extends Throwable {
        public NotUniqueIdException(String string) {
            super(string);
        }
    }
}

