/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.sectorcarrier;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.ForbiddenSetAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SectorCarrierModificationValidator;
import se.ericsson.lte.rbs.omf.common.validator.SectorCarrierRfBranchRefValidator;

public class SectorCarrierMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = SectorCarrierMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "SectorCarrier";
    public static final String ATTR_NO_OF_RX_ANTENNAS = "noOfRxAntennas";
    public static final String ATTR_NO_OF_TX_ANTENNAS = "noOfTxAntennas";
    public static final String PART_OF_SECTOR_POWER = "partOfSectorPower";
    public static final String PRS_ENABLED = "prsEnabled";
    public static final String RF_BRANCH_RX_REF = "rfBranchRxRef";
    public static final String RF_BRANCH_TX_REF = "rfBranchTxRef";

    public SectorCarrierMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public SectorCarrierMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "registerValidators()");
        this.registerValidator(ATTR_NO_OF_RX_ANTENNAS, new SectorCarrierModificationValidator(ATTR_NO_OF_RX_ANTENNAS));
        this.registerValidator(ATTR_NO_OF_TX_ANTENNAS, new SectorCarrierModificationValidator(ATTR_NO_OF_TX_ANTENNAS));
        this.registerValidator(PART_OF_SECTOR_POWER, new SectorCarrierModificationValidator(PART_OF_SECTOR_POWER));
        this.registerValidator(PRS_ENABLED, new SectorCarrierModificationValidator(PRS_ENABLED));
        this.registerValidator(RF_BRANCH_RX_REF, new SectorCarrierModificationValidator(RF_BRANCH_RX_REF));
        this.registerValidator(RF_BRANCH_TX_REF, new SectorCarrierModificationValidator(RF_BRANCH_TX_REF));
        this.registerValidator(RF_BRANCH_RX_REF, new SectorCarrierRfBranchRefValidator(RF_BRANCH_RX_REF));
        this.registerValidator(RF_BRANCH_TX_REF, new SectorCarrierRfBranchRefValidator(RF_BRANCH_TX_REF));
        this.registerValidator(PART_OF_SECTOR_POWER, new ForbiddenSetAttributeValidator(PART_OF_SECTOR_POWER, new String[]{MO_TYPE}, new String[]{PART_OF_SECTOR_POWER}, new Object[]{new Integer(0)}, this.genericMaoContext));
        logger.traceReturn(THIS_CLASS, "registerValidators()");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "delete()");
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            GenericMao genericMao = (GenericMao)moIterator.nextMo();
            logger.traceDebug(THIS_CLASS, "child: " + genericMao.getLocalDistinguishedName());
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            logger.traceDebug(THIS_CLASS, "check that child MO of SectorCarrierMo is System Crated MO : " + moMetaData.isSystemCreated());
            genericMao.deleteInternal(coordinator);
            logger.traceDebug(THIS_CLASS, "child deleted");
        }
        super.delete(coordinator);
        logger.traceReturn(((Object)((Object)this)).getClass(), "delete()");
    }
}

