/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.securityhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;

public class SecurityHandlingMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = SecurityHandlingMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "SecurityHandling";
    protected static final String CIPHERING_ALGO_PRIO_ATTR = "cipheringAlgoPrio";
    protected static final Integer CIPHERING_ALGORITHM_EEA0 = new Integer(0);
    protected static final Integer CIPHERING_ALGORITHM_EEA1 = new Integer(1);
    protected static final Integer CIPHERING_ALGORITHM_EEA2 = new Integer(2);
    protected static final Integer CIPHERING_ALGORITHM_EEA3 = new Integer(3);
    protected static final String CIPHERING_ALGORITHMS_ATTR = "cipheringAlgorithms";
    private static final Integer CIPHERING_ALGORITHMS_EEA3 = new Integer(16);
    private static final Integer[][] CIPHERING_ALGORITHMS_TO_PRIO_VALUES = new Integer[][]{{CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA0}, {CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA2}, {CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA0}, {CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA1}, {CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA2}, {CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA1}, {CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA2}, {CIPHERING_ALGORITHM_EEA1, CIPHERING_ALGORITHM_EEA0}, {CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA1}, {CIPHERING_ALGORITHM_EEA2, CIPHERING_ALGORITHM_EEA0}, {CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA1}, {CIPHERING_ALGORITHM_EEA0, CIPHERING_ALGORITHM_EEA2}, {CIPHERING_ALGORITHM_EEA1}, {CIPHERING_ALGORITHM_EEA2}, {CIPHERING_ALGORITHM_EEA0}, {CIPHERING_ALGORITHM_EEA3}, {CIPHERING_ALGORITHM_EEA3}};
    protected static final String INTEGRITY_PROTECT_ALGO_PRIO_ATTR = "integrityProtectAlgoPrio";
    protected static final Integer INTEGRITY_PROTECTION_ALGORITHM_ID_EIA1 = new Integer(1);
    protected static final Integer INTEGRITY_PROTECTION_ALGORITHM_ID_EIA2 = new Integer(2);
    protected static final Integer INTEGRITY_PROTECTION_ALGORITHM_ID_EIA3 = new Integer(3);
    protected static final String INTEGRITY_PROTECTION_ALGORITHMS_ATTR = "integrityProtectionAlgorithms";
    private static final Integer INTEGRITY_PROTECTION_ALGORITHMS_EIA3 = new Integer(9);
    private static final Integer[][] INTEGRITY_PROTECTION_ALGORITHMS_TO_PRIO_VALUES = new Integer[][]{null, null, null, null, null, {INTEGRITY_PROTECTION_ALGORITHM_ID_EIA1, INTEGRITY_PROTECTION_ALGORITHM_ID_EIA2}, {INTEGRITY_PROTECTION_ALGORITHM_ID_EIA2, INTEGRITY_PROTECTION_ALGORITHM_ID_EIA1}, {INTEGRITY_PROTECTION_ALGORITHM_ID_EIA1}, {INTEGRITY_PROTECTION_ALGORITHM_ID_EIA2}, {INTEGRITY_PROTECTION_ALGORITHM_ID_EIA3}};

    public SecurityHandlingMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        this.removeAttributesDuringCreate(attrList, CIPHERING_ALGORITHMS_ATTR);
        this.removeAttributesDuringCreate(attrList, INTEGRITY_PROTECTION_ALGORITHMS_ATTR);
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    public SecurityHandlingMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    public void setAttribute(String string, Object integerArray, Coordinator coordinator) throws MoAccessException {
        String string2 = string;
        Integer[] integerArray2 = integerArray;
        if (CIPHERING_ALGORITHMS_ATTR.equals(string)) {
            string2 = CIPHERING_ALGO_PRIO_ATTR;
            integerArray2 = CIPHERING_ALGORITHMS_TO_PRIO_VALUES[(Integer)integerArray];
        } else if (INTEGRITY_PROTECTION_ALGORITHMS_ATTR.equals(string) && this.isIntegrityPriorityWithinRange(integerArray)) {
            string2 = INTEGRITY_PROTECT_ALGO_PRIO_ATTR;
            integerArray2 = INTEGRITY_PROTECTION_ALGORITHMS_TO_PRIO_VALUES[(Integer)integerArray];
        }
        super.setAttribute(string2, integerArray2, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CIPHERING_ALGORITHMS_ATTR)) {
                stringArray[i] = CIPHERING_ALGO_PRIO_ATTR;
                objectArray[i] = CIPHERING_ALGORITHMS_TO_PRIO_VALUES[(Integer)objectArray[i]];
                continue;
            }
            if (!stringArray[i].equals(INTEGRITY_PROTECTION_ALGORITHMS_ATTR) || !this.isIntegrityPriorityWithinRange(objectArray[i])) continue;
            stringArray[i] = INTEGRITY_PROTECT_ALGO_PRIO_ATTR;
            objectArray[i] = INTEGRITY_PROTECTION_ALGORITHMS_TO_PRIO_VALUES[(Integer)objectArray[i]];
        }
        super.setAttributes(stringArray, objectArray, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        String string2 = string;
        Object object = null;
        if (CIPHERING_ALGORITHMS_ATTR.equals(string)) {
            Integer[] integerArray = (Integer[])super.getAttribute(CIPHERING_ALGO_PRIO_ATTR, coordinator);
            object = this.getAlgorithmsFromPrio(integerArray, CIPHERING_ALGORITHM_EEA3, CIPHERING_ALGORITHMS_EEA3, CIPHERING_ALGORITHMS_TO_PRIO_VALUES);
        } else if (INTEGRITY_PROTECTION_ALGORITHMS_ATTR.equals(string)) {
            Integer[] integerArray = (Integer[])super.getAttribute(INTEGRITY_PROTECT_ALGO_PRIO_ATTR, coordinator);
            object = this.getAlgorithmsFromPrio(integerArray, INTEGRITY_PROTECTION_ALGORITHM_ID_EIA3, INTEGRITY_PROTECTION_ALGORITHMS_EIA3, INTEGRITY_PROTECTION_ALGORITHMS_TO_PRIO_VALUES);
        } else {
            object = super.getAttribute(string2, coordinator);
        }
        return object;
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (CIPHERING_ALGORITHMS_ATTR.equals(stringArray[i])) {
                object = this.getAlgorithmsFromPrio((Integer[])this.getAttribute(CIPHERING_ALGO_PRIO_ATTR, coordinator), CIPHERING_ALGORITHM_EEA3, CIPHERING_ALGORITHMS_EEA3, CIPHERING_ALGORITHMS_TO_PRIO_VALUES);
                hashMap.put(CIPHERING_ALGORITHMS_ATTR, object);
                continue;
            }
            if (INTEGRITY_PROTECTION_ALGORITHMS_ATTR.equals(stringArray[i])) {
                object = this.getAlgorithmsFromPrio((Integer[])this.getAttribute(INTEGRITY_PROTECT_ALGO_PRIO_ATTR, coordinator), INTEGRITY_PROTECTION_ALGORITHM_ID_EIA3, INTEGRITY_PROTECTION_ALGORITHMS_EIA3, INTEGRITY_PROTECTION_ALGORITHMS_TO_PRIO_VALUES);
                hashMap.put(INTEGRITY_PROTECTION_ALGORITHMS_ATTR, object);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        Object[] objectArray = super.getAttributes(arrayList.toArray(new String[arrayList.size()]), coordinator);
        return this.combineAttributeLists(stringArray, arrayList, objectArray, hashMap);
    }

    protected void registerValidators() {
    }

    private boolean isIntegrityPriorityWithinRange(Object object) {
        int n = (Integer)object;
        return n > 4 && n < 10;
    }

    private Object getAlgorithmsFromPrio(Integer[] integerArray, Integer n, Integer n2, Integer[][] integerArray2) {
        Object object = null;
        if (n.equals(integerArray[0])) {
            object = n2;
        } else {
            Integer[] integerArray3 = this.removeUnvantedPrio(integerArray, n);
            object = this.convertFromPrioToAlgortihms(integerArray3, integerArray2);
        }
        return object;
    }

    private Object convertFromPrioToAlgortihms(Integer[] integerArray, Integer[][] integerArray2) {
        Integer n = null;
        for (int i = 0; i < integerArray2.length; ++i) {
            if (!Arrays.equals(integerArray2[i], (Object[])integerArray)) continue;
            n = new Integer(i);
            break;
        }
        return n;
    }

    private Integer[] removeUnvantedPrio(Integer[] integerArray, Integer n) {
        List<Integer> list = Arrays.asList(integerArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            if (n.equals(n2)) continue;
            arrayList.add(n2);
        }
        Integer[] integerArray2 = new Integer[arrayList.size()];
        arrayList.toArray(integerArray2);
        return integerArray2;
    }

    private void removeAttributesDuringCreate(AttrList attrList, String string) {
        int n = attrList.indexOf(string);
        if (n != -1) {
            attrList.removeElementAt(n);
            logger.traceDebug(THIS_CLASS, "Remove attribute [" + string + "] from attributeList");
        }
    }
}

