/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.utrancellrelation;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.LimitUtranCellRelationsValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueExternalUtranCellFddRelationValidator;

public class UtranCellRelationMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = UtranCellRelationMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String UTRAN_CELL_RELATION = "UtranCellRelation";
    private static final String EXTERNAL_UTRAN_CELL_FDD_REF = "externalUtranCellFDDRef";

    public UtranCellRelationMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, UTRAN_CELL_RELATION, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "UtranCellRelationMaoImpl()");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_IRAT_OPERATOR, AttributeUtilities.LAST_MODIFICATION_UTRAN_NOT_MODIFIED, coordinator);
        logger.traceReturn(THIS_CLASS, "UtranCellRelationMaoImpl()");
    }

    public UtranCellRelationMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_UTRAN_OPERATOR_MODIFICATION, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    protected void registerValidators() {
        this.registerValidator(EXTERNAL_UTRAN_CELL_FDD_REF, new LimitUtranCellRelationsValidator(EXTERNAL_UTRAN_CELL_FDD_REF));
        this.registerValidator(EXTERNAL_UTRAN_CELL_FDD_REF, new UniqueExternalUtranCellFddRelationValidator(EXTERNAL_UTRAN_CELL_FDD_REF));
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_OPERATOR);
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }
}

