/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.omfapplication;

import java.io.IOException;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextAlreadyExists;
import se.ericsson.crbs.omf.omfapplication.OmfContextCreateFailureException;
import se.ericsson.crbs.omf.omfapplication.OmfContextFactoryFactory;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaSignalHandler;
import se.ericsson.lte.rbs.omf.mao.ima.proxy.ImaProxy;
import se.ericsson.lte.rbs.omf.omfapplication.MimVersionHandler;
import se.ericsson.lte.rbs.omf.omfapplication.MoMetaDataNamesNoam;
import se.ericsson.lte.rbs.omf.omfapplication.PlugInUnitSubscriber;
import se.ericsson.lte.rbs.omf.omfapplication.PmAttributeImpl;

public class OmfApplication
implements Mopplet {
    private static AbstractLogger logger = LoggingService.getLogger();
    private final OmfContext theOmfContext;
    protected ImaProxy imaProxy;

    public OmfApplication() {
        logger.traceEnter(this.getClass(), "OmfApplication");
        OmfContext omfContext = null;
        try {
            logger.traceDebug(this.getClass(), "Creating OMF Context.");
            MoMetaDataNamesNoam moMetaDataNamesNoam = new MoMetaDataNamesNoam();
            omfContext = OmfContextFactoryFactory.getOmfContextFactoryInstance((String)"").createOmfContext(new OmfContextId("NOAM"), (PmAttribute)new PmAttributeImpl(), (MoMetaDataNames)moMetaDataNamesNoam);
        }
        catch (IOException iOException) {
            logger.traceError(this.getClass(), "OmfApplication(): Error in OmfApplication Constructor!" + iOException.getMessage());
        }
        catch (OmfContextAlreadyExists omfContextAlreadyExists) {
            logger.traceError(this.getClass(), "OmfApplication(): Error in OmfApplication Constructor!" + omfContextAlreadyExists.getMessage());
        }
        catch (OmfContextCreateFailureException omfContextCreateFailureException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextCreateFailureException.getMessage());
        }
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public OmfApplication(OmfContext omfContext) {
        logger.traceEnter(this.getClass(), "OmfApplication");
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public void init() {
        logger.traceEnter(this.getClass(), "init");
        logger.info(this.getClass(), "LM Loaded - lteRbsNoamLm");
        logger.info(this.getClass(), "Starting lteRbsNoamLm");
        this.theOmfContext.getGenericFactoryInitializer().initializeFactories();
        logger.traceReturn(this.getClass(), "init");
    }

    public void start() {
        logger.traceEnter(this.getClass(), "start");
        this.theOmfContext.getGenericFactoryInitializer().startFactories();
        MimVersionHandler mimVersionHandler = new MimVersionHandler(this.theOmfContext);
        mimVersionHandler.parseEnBMOMAndSetMim();
        this.theOmfContext.getGenericFactoryInitializer().synch();
        this.startImaProxy();
        this.startPlugInUnitSubscriber();
        logger.info(this.getClass(), "LM Started - lteRbsNoamLm");
        logger.traceReturn(this.getClass(), "start");
    }

    private void startImaProxy() {
        logger.traceEnter(this.getClass(), "startImaProxy()");
        if ("TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            logger.traceDebug(this.getClass(), "Are not calling imaProxy:startService() because of UnitTest mode");
        } else {
            this.imaProxy = new ImaProxy(this.theOmfContext);
            new ImaSignalHandler(this.imaProxy, this.theOmfContext);
            this.imaProxy.startService();
        }
        logger.traceReturn(this.getClass(), "startImaProxy()");
    }

    private void startPlugInUnitSubscriber() {
        logger.traceEnter(this.getClass(), "startPlugInUnitSubscriber()");
        PlugInUnitSubscriber.getInstance().start(this.theOmfContext);
        logger.traceReturn(this.getClass(), "startPlugInUnitSubscriber()");
    }
}

