/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmapplication;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmapplication.CalendarWrapper;
import se.ericsson.lte.rbs.omf.pmapplication.TimerWrapper;
import se.ericsson.lte.rbs.omf.pmcommon.PmMisc;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler;

public class PmROPTimer
extends TimerTask {
    private static final Class THIS_CLASS = PmROPTimer.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static Timer timer;
    private final PmStatHandler pmStatHandler;
    private final PmMisc pmMisc;
    private static final long PERIOD = 450000L;
    private static final long LAG = 300000L;
    private static boolean isMidROP;
    private static String message;
    private static final long TIMER_RECRT_LAG = 10000L;
    private static int ropPeriodOccuredWhenNotCompleted;

    public PmROPTimer(PmStatHandler pmStatHandler, PmMisc pmMisc, boolean bl) {
        logger.info(THIS_CLASS, "Creating PmROPTimer class");
        if (pmStatHandler == null) {
            logger.traceError(THIS_CLASS, "Constructor inputPmStatHandler is null");
        } else {
            pmStatHandler.addPmROPTimerTSInfo("PmROPTimer() constructor, createTimer:" + bl);
        }
        if (pmMisc == null) {
            logger.traceError(THIS_CLASS, "Constructor inputPmMisc is null");
        }
        this.pmStatHandler = pmStatHandler;
        this.pmMisc = pmMisc;
        if (bl) {
            this.createTimer();
        }
        logger.info(THIS_CLASS, "PmROPTimer created");
    }

    private void createTimer() {
        this.pmStatHandler.addPmROPTimerTSInfo("createTimer");
        try {
            if (message != null && message.length() > 0) {
                logger.info(THIS_CLASS, message);
            }
            timer = TimerWrapper.getInstance().createNewTimer();
        }
        catch (RuntimeException runtimeException) {
            message = "\n" + this.getExceptionInfor(runtimeException) + "\n";
            logger.traceError(THIS_CLASS, message);
            this.recreateTimer(1);
        }
    }

    private void recreateTimer(int n) {
        this.pmStatHandler.addPmROPTimerTSInfo("recreateTimer attempt:" + n);
        try {
            TimerWrapper.getInstance().sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            logger.traceDebug(THIS_CLASS, "Method recreateTimer, wait got interrupted: " + interruptedException);
        }
        message = message + "Count of attempts to recreate Timer : " + n + "\n";
        try {
            timer = TimerWrapper.getInstance().createNewTimer();
        }
        catch (RuntimeException runtimeException) {
            message = "\n" + this.getExceptionInfor(runtimeException) + "\n";
            logger.traceError(THIS_CLASS, message);
            this.recreateTimer(n + 1);
        }
    }

    private String getExceptionInfor(RuntimeException runtimeException) {
        String string = "Caught RuntimeException at " + DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()) + ": \n";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        runtimeException.printStackTrace(printWriter);
        return string + stringWriter.toString();
    }

    public void start() {
        String string = DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        Calendar calendar = PmROPTimer.getROPTime();
        String string2 = DateFormat.getDateTimeInstance().format(calendar.getTime());
        logger.traceTimer(THIS_CLASS, "End of ROP timer started " + string + ", first ROP will occur " + string2);
        this.pmStatHandler.addPmROPTimerTSInfo("PmROPTimer.start() localStartTime: " + string + ", first ROP will occur " + string2);
        timer.scheduleAtFixedRate((TimerTask)this, calendar.getTime(), 450000L);
    }

    public static Calendar getROPTime() {
        int n;
        Calendar calendar = CalendarWrapper.getInstance().getCalendar();
        int n2 = calendar.get(12);
        if (n2 >= 0 && n2 < 15) {
            n = 15;
        } else if (n2 < 30) {
            n = 30;
        } else if (n2 < 45) {
            n = 45;
        } else {
            n = 0;
            calendar.set(10, calendar.get(10) + 1);
        }
        calendar.set(12, n);
        calendar.set(13, 0);
        return calendar;
    }

    public void run() {
        this.pmStatHandler.addPmROPTimerTSInfo("PmROPTimer.run() isMidROP: " + isMidROP);
        long l = Calendar.getInstance().getTime().getTime();
        long l2 = l - this.scheduledExecutionTime();
        logger.traceDebug(THIS_CLASS, "Time Now: " + l);
        logger.traceDebug(THIS_CLASS, "Time Diff: " + l2);
        if (TimerWrapper.getInstance().timerOutOfSyn(l2, 300000L)) {
            logger.traceGeneral(THIS_CLASS, "System Clock has been changed");
            timer.cancel();
            this.cancel();
            this.createTimer();
            Calendar calendar = PmROPTimer.getROPTime();
            String string = DateFormat.getDateTimeInstance().format(calendar.getTime());
            logger.traceGeneral(THIS_CLASS, "Next ROP scheduled for " + string);
            logger.info(THIS_CLASS, "Next ROP scheduled for " + string);
            this.pmStatHandler.addPmROPTimerTSInfo("Time out of synch. Next ROP scheduled at: " + string + ". Time Now: " + l + ". Time diff: " + l2);
            timer.scheduleAtFixedRate((TimerTask)new PmROPTimer(this.pmStatHandler, this.pmMisc, false), calendar.getTime(), 450000L);
            isMidROP = false;
            return;
        }
        this.printIfPmStatHandlerNotCompleted();
        this.adjustisMidROPAtScheduledExecutionTime();
        if (TimerWrapper.getInstance().isMidROP(isMidROP)) {
            if (this.pmStatHandler.isCompleted()) {
                String string = DateFormat.getDateTimeInstance().format(new Date(this.scheduledExecutionTime()));
                logger.traceTimer(THIS_CLASS, "Mid ROP reached at " + string);
                this.pmStatHandler.startMidRopReset();
                this.pmMisc.controlMEAttributes();
            }
            this.printTroubeShootingInfoInMidRop();
            isMidROP = false;
        } else {
            if (message != null && message.length() > 0) {
                logger.info(THIS_CLASS, message);
            }
            if (this.pmStatHandler.isCompleted()) {
                String string = DateFormat.getDateTimeInstance().format(new Date(this.scheduledExecutionTime()));
                logger.traceTimer(THIS_CLASS, "End of ROP reached at " + string);
                this.pmStatHandler.startScan();
            }
            isMidROP = true;
        }
    }

    private void printTroubeShootingInfoInMidRop() {
        this.pmStatHandler.printScannersDebugInfo();
        boolean bl = !this.pmStatHandler.isCompleted();
        this.pmStatHandler.getProxy().printTroubleShootingInfo(bl);
        this.pmStatHandler.printTroubleShootingInfo(bl);
    }

    private void printIfPmStatHandlerNotCompleted() {
        if (!this.pmStatHandler.isCompleted()) {
            if (ropPeriodOccuredWhenNotCompleted > 0) {
                logger.traceError(THIS_CLASS, "PmStatHandler is not completed at ROP or MidROP. This will affect counter contents of ROP-files." + ropPeriodOccuredWhenNotCompleted);
            } else {
                logger.info(THIS_CLASS, "PmStatHandler is not completed at ROP or MidROP. " + ropPeriodOccuredWhenNotCompleted);
            }
            ++ropPeriodOccuredWhenNotCompleted;
        }
    }

    private void adjustisMidROPAtScheduledExecutionTime() {
        boolean bl = true;
        long l = (this.scheduledExecutionTime() - this.scheduledExecutionTime() % 1000L) % 36000000L;
        String string = DateFormat.getDateTimeInstance().format(new Date(this.scheduledExecutionTime()));
        if (l == 0L || l % 900000L == 0L) {
            bl = false;
        }
        if (TimerWrapper.getInstance().isMidROP(isMidROP) != bl) {
            logger.traceError(THIS_CLASS, "scheduled at " + string + ", timeMaskedHour: " + l + "ms, set to isMidROP: " + bl);
            isMidROP = bl;
        }
    }

    static {
        isMidROP = false;
        message = null;
        ropPeriodOccuredWhenNotCompleted = 0;
    }
}

