/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmevent;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.pms.generic.DestinationAddress;
import se.ericsson.cello.pms.generic.Filter;
import se.ericsson.cello.pms.generic.FilterInfo;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.InvalidFilterException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.InvalidTriggeringObjectException;
import se.ericsson.cello.pms.generic.MonitoringTaskAccess;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OperationFailedException;
import se.ericsson.cello.pms.generic.OutputMode;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmevent.EventHelper;
import se.ericsson.lte.rbs.omf.pmevent.EventProperties;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmActivateCellTraceScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmDeactivateCellTraceScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;

public class PmCellTraceScanner
implements MonitoringTaskAccess {
    private static final Class THIS_CLASS = PmCellTraceScanner.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private FilterInfo filterInfo;
    private final MonitoringTaskInfo taskInfo;
    private final ScannerId scannerId;
    private final int internalScannerId;
    private final PmProxyI pmProxy;
    private final PmWrapperProviderI pmWrapperProvider;
    private static final int SCANNER_ID_BASE = 10000;

    public PmCellTraceScanner(int n, PmProxyI pmProxyI, PmWrapperProviderI pmWrapperProviderI) {
        this.internalScannerId = 10000 + n;
        String string = new String("PREDEF." + this.internalScannerId + ".CELLTRACE");
        this.scannerId = new ScannerId(string);
        this.filterInfo = null;
        this.taskInfo = new MonitoringTaskInfo(this.scannerId, string, PerformanceMonitoringState.SUSPENDED, new ObservationClass[0], new ObservationObject[0], GranularityPeriod.MINUTES_15, GranularityPeriod.MINUTES_15);
        this.pmProxy = pmProxyI;
        this.pmWrapperProvider = pmWrapperProviderI;
        PmsPortalImpl.getPortal().registerScanner((Object)this, this.taskInfo.getId());
        logger.traceGeneral(THIS_CLASS, "Predefined event scanner " + string + " created and registered in PMS");
    }

    public void delete() throws InvalidPerformanceMonitoringTypeException {
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public MonitoringTaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public FilterInfo lookupFilter() throws InvalidPerformanceMonitoringTypeException {
        return this.filterInfo;
    }

    public void setFilter(FilterInfo filterInfo) throws InvalidPerformanceMonitoringTypeException, InvalidObservationObjectListException, InvalidFilterException, InvalidTriggeringObjectException {
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, this.filterInfoToString(filterInfo));
        }
        if (this.taskInfo.getState() == PerformanceMonitoringState.ACTIVE) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, set filter not allowed, scanner " + this.scannerId.getName() + " is active");
            throw new InvalidFilterException();
        }
        this.validateEvents(filterInfo);
        if (this.hasFilter(filterInfo)) {
            this.validateFilter(filterInfo);
        }
        this.validateOutPutMode(filterInfo);
        if (filterInfo.getOutputMode().value() == 1 || filterInfo.getOutputMode().value() == 2) {
            this.validateDestinationAddress(filterInfo);
        }
        this.validateTraceReference(filterInfo);
        this.filterInfo = filterInfo;
    }

    public void setState(PerformanceMonitoringState performanceMonitoringState) throws OverloadException, OperationFailedException {
        if (LogHelper.traceGeneralEnabled(THIS_CLASS)) {
            logger.traceGeneral(THIS_CLASS, "Setting state for scanner " + this.scannerId.getName() + " to " + this.stateToString(performanceMonitoringState));
        }
        if (performanceMonitoringState == PerformanceMonitoringState.SUSPENDED) {
            this.handleSuspended();
        } else if (performanceMonitoringState == PerformanceMonitoringState.ACTIVE) {
            this.checkState();
            this.checkFilterInfo();
            try {
                int[] nArray = this.getEventIds(this.filterInfo);
                int n = this.getUeFraction(this.filterInfo);
                boolean bl = this.getAsn1(this.filterInfo);
                int[] nArray2 = this.getCells(this.filterInfo);
                String string = this.filterInfo.getTraceReference();
                char[] cArray = this.filterInfo.getDestinationAddress().ip_address.toCharArray();
                int n2 = cArray.length;
                int n3 = 0;
                if (this.filterInfo.getDestinationAddress() != null) {
                    n3 = this.filterInfo.getDestinationAddress().port;
                }
                int n4 = this.filterInfo.getOutputMode().value();
                this.pmProxy.sendSignal((Signal)new OmfPmActivateCellTraceScannerInd(string, this.internalScannerId, n, n3, n4, bl, nArray2, n2, cArray, nArray));
            }
            catch (PmNoClientConnectedException pmNoClientConnectedException) {
                throw new OperationFailedException(pmNoClientConnectedException.getMessage());
            }
            this.taskInfo.setState(performanceMonitoringState);
        } else {
            String string = "Operation failed, unknown scanner state: " + (performanceMonitoringState == null ? "NULL" : Integer.toString(performanceMonitoringState.value()));
            logger.traceAbnormal(THIS_CLASS, string);
            throw new OperationFailedException(string);
        }
        this.taskInfo.setState(performanceMonitoringState);
    }

    private void checkState() throws OperationFailedException {
        if (this.taskInfo.getState() == PerformanceMonitoringState.ACTIVE) {
            String string = "Operation failed, scanner " + this.scannerId.getName() + " already ACTIVE.";
            logger.traceAbnormal(THIS_CLASS, string);
            throw new OperationFailedException(string);
        }
    }

    private void checkFilterInfo() throws OperationFailedException {
        if (this.filterInfo == null) {
            String string = "Operation failed, no filter criteria has been set for scanner " + this.scannerId.getName();
            logger.traceAbnormal(THIS_CLASS, string);
            throw new OperationFailedException(string);
        }
    }

    private void handleSuspended() throws OperationFailedException {
        if (this.taskInfo.getState() == PerformanceMonitoringState.SUSPENDED) {
            String string = "Operation failed, scanner " + this.scannerId.getName() + " already SUSPENDED.";
            logger.traceAbnormal(THIS_CLASS, string);
            throw new OperationFailedException(string);
        }
        try {
            this.pmProxy.sendSignal((Signal)new OmfPmDeactivateCellTraceScannerInd(this.internalScannerId));
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            throw new OperationFailedException("PmNoClientConnectedException: " + pmNoClientConnectedException.getMessage());
        }
    }

    protected boolean isActive() {
        boolean bl = this.taskInfo.getState() == PerformanceMonitoringState.ACTIVE;
        return bl;
    }

    protected void reactivate() {
        logger.traceDebug(THIS_CLASS, "Reactivating scanner " + this.scannerId.getName());
        if (this.isActive()) {
            try {
                int[] nArray = this.getEventIds(this.filterInfo);
                int n = this.getUeFraction(this.filterInfo);
                boolean bl = this.getAsn1(this.filterInfo);
                int[] nArray2 = this.getCells(this.filterInfo);
                String string = this.filterInfo.getTraceReference();
                char[] cArray = this.filterInfo.getDestinationAddress().ip_address.toCharArray();
                int n2 = cArray.length + 1;
                int n3 = 0;
                if (this.filterInfo.getDestinationAddress() != null) {
                    n3 = this.filterInfo.getDestinationAddress().port;
                }
                int n4 = this.filterInfo.getOutputMode().value();
                this.pmProxy.sendSignal((Signal)new OmfPmActivateCellTraceScannerInd(string, this.internalScannerId, n, n3, n4, bl, nArray2, n2, cArray, nArray));
            }
            catch (PmNoClientConnectedException pmNoClientConnectedException) {
                return;
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, "Request to reactivate scanner ignored, state is suspended");
        }
    }

    private void validateEvents(FilterInfo filterInfo) throws InvalidObservationObjectListException {
        if (filterInfo.getObservationObjectList() == null) {
            logger.traceError(THIS_CLASS, "ObservationObject list is null");
            throw new InvalidObservationObjectListException(null);
        }
        if (filterInfo.getObservationObjectList().length == 0) {
            logger.traceDebug(THIS_CLASS, "No observation objects (events) in filter, scanner will be cleared");
            if (this.hasFilter(filterInfo)) {
                logger.traceError(THIS_CLASS, "Filter exists for scanner without observation objects");
                throw new InvalidObservationObjectListException(null);
            }
        } else {
            ObservationObject[] observationObjectArray = filterInfo.getObservationObjectList();
            for (int i = 0; i < observationObjectArray.length; ++i) {
                ObservationObject observationObject = observationObjectArray[i];
                String[] stringArray = observationObject.instance_attribute_list;
                if (stringArray == null || stringArray.length == 0) {
                    logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, no events in attribute list");
                    throw new InvalidObservationObjectListException(filterInfo.getObservationObjectList());
                }
                this.checkIfExistingEvent(filterInfo, stringArray);
            }
        }
    }

    private void checkIfExistingEvent(FilterInfo filterInfo, String[] stringArray) throws InvalidObservationObjectListException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (EventHelper.isExistingEvent(stringArray[i])) continue;
            if (LogHelper.traceAbnormalEnabled(THIS_CLASS)) {
                logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, event " + stringArray[i] + " do not exist");
            }
            throw new InvalidObservationObjectListException(filterInfo.getObservationObjectList());
        }
    }

    private boolean hasFilter(FilterInfo filterInfo) {
        Filter filter = filterInfo.getFilter();
        boolean bl = filter != null && filter.attribute_name != null && filter.attribute_name.length != 0;
        return bl;
    }

    private void validateFilter(FilterInfo filterInfo) throws InvalidFilterException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < filterInfo.getFilter().attribute_name.length; ++i) {
            if (filterInfo.getFilter().attribute_name[i].equals("UE_FRACTION")) {
                this.checkFilterAttrValue(filterInfo, i);
                this.checkIfFiltersHasAttribute(filterInfo, bl, i);
                bl = true;
                this.checkUeFraction(filterInfo, i);
                continue;
            }
            if (filterInfo.getFilter().attribute_name[i].equals("ASN1")) {
                this.checkFilterAttrValue(filterInfo, i);
                this.checkIfFiltersHasAttribute(filterInfo, bl2, i);
                bl2 = true;
                this.checkAsn1(filterInfo, i);
                continue;
            }
            if (filterInfo.getFilter().attribute_name[i].equals("CELL")) {
                this.checkFilterAttrValue(filterInfo, i);
                this.checkIfFiltersHasAttribute(filterInfo, bl3, i);
                bl3 = true;
                this.checkCell(filterInfo, i);
                continue;
            }
            if (LogHelper.traceAbnormalEnabled(THIS_CLASS)) {
                logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, attribute " + filterInfo.getFilter().attribute_name[i] + " not supported");
            }
            throw new InvalidFilterException();
        }
    }

    private void checkIfFiltersHasAttribute(FilterInfo filterInfo, boolean bl, int n) throws InvalidFilterException {
        if (bl) {
            if (LogHelper.traceAbnormalEnabled(THIS_CLASS)) {
                logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, multiple occurens of attribute " + filterInfo.getFilter().attribute_name[n]);
            }
            throw new InvalidFilterException();
        }
    }

    private void checkFilterAttrValue(FilterInfo filterInfo, int n) throws InvalidFilterException {
        if (filterInfo.getFilter().attribute_value == null || filterInfo.getFilter().attribute_value[n] == null) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value missing for attribute " + filterInfo.getFilter().attribute_name[n]);
            throw new InvalidFilterException();
        }
    }

    private void checkUeFraction(FilterInfo filterInfo, int n) throws InvalidFilterException {
        int n2 = new Integer(filterInfo.getFilter().attribute_value[n]);
        if (n2 < 1 || n2 > 1000) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value " + n2 + " for attribute " + filterInfo.getFilter().attribute_name[n] + " is out of range");
            throw new InvalidFilterException();
        }
    }

    private void checkAsn1(FilterInfo filterInfo, int n) throws InvalidFilterException {
        String string = filterInfo.getFilter().attribute_value[n];
        if (!string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value " + string + " for attribute " + filterInfo.getFilter().attribute_name[n] + " is not valid");
            throw new InvalidFilterException();
        }
    }

    private void checkCell(FilterInfo filterInfo, int n) throws InvalidFilterException {
        String string = filterInfo.getFilter().attribute_value[n];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n2 = 0;
        boolean bl = true;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (++n2 > 24) {
                bl = false;
                string2 = "too many occurences of";
                break;
            }
            ManagedObject managedObject = this.pmWrapperProvider.getMoRepository().lookup(string3);
            if (managedObject == null) {
                bl = false;
                string2 = "invalid value " + string3 + " for";
                break;
            }
            try {
                managedObject.getAttribute("cellId", null);
            }
            catch (MoAccessException moAccessException) {
                bl = false;
                string2 = "invalid value " + string3 + " for";
                break;
            }
        }
        if (!bl) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, " + string2 + " attribute " + filterInfo.getFilter().attribute_name[n]);
            throw new InvalidFilterException();
        }
    }

    private void validateOutPutMode(FilterInfo filterInfo) throws InvalidFilterException {
        OutputMode outputMode = filterInfo.getOutputMode();
        if (outputMode == null) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value missing for output mode.");
            throw new InvalidFilterException();
        }
    }

    private void validateDestinationAddress(FilterInfo filterInfo) throws InvalidFilterException {
        DestinationAddress destinationAddress = filterInfo.getDestinationAddress();
        if (destinationAddress == null) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value missing for destination address.");
            throw new InvalidFilterException();
        }
        String string = destinationAddress.ip_address;
        int n = destinationAddress.port;
        if (n < 0) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, port is invalid for destination address.");
            throw new InvalidFilterException();
        }
        if (!this.validIpAddress(string)) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, ip address is invalid for destination address.");
            throw new InvalidFilterException();
        }
    }

    private boolean validIpAddress(String string) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = bl = string.indexOf(58) > 0;
        if (!bl && string.indexOf(46) < 0) {
            bl2 = false;
        }
        bl2 = bl ? this.validIpv6Address(string) : this.validIpv4Address(string);
        return bl2;
    }

    private boolean validIpv4Address(String string) {
        boolean bl = true;
        if (string == null) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                block7: {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        int n2 = new Integer(string2);
                        if (n2 < 0 || n2 > 255) {
                            bl = false;
                        }
                        break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                ++n;
            }
            if (bl) {
                bl = n == 4;
            }
        }
        return bl;
    }

    private boolean validIpv6Address(String string) {
        boolean bl = true;
        int n = this.countDoubleColons(string);
        if (string == null || n > 1) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() > 4 || !this.containsHexChars(string2)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                bl = n2 == 8 && n == 0 || n2 < 8 && n == 1;
            }
        }
        return bl;
    }

    private boolean containsHexChars(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if ("0123456789ABCDEFabcdef".indexOf(string.charAt(i)) >= 0) continue;
            bl = false;
        }
        return bl;
    }

    private int countDoubleColons(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = string;
        while (n2 < string2.length() && n2 >= 0) {
            n2 = string2.indexOf("::");
            if (n2 <= 0) continue;
            string2 = string2.substring(n2 + 1);
            ++n;
        }
        return n;
    }

    private void validateTraceReference(FilterInfo filterInfo) throws InvalidFilterException {
        String string = filterInfo.getTraceReference();
        if (string == null) {
            logger.traceAbnormal(THIS_CLASS, "Operation failed, invalid filter, value missing for trace reference.");
            throw new InvalidFilterException();
        }
    }

    private int[] getEventIds(FilterInfo filterInfo) {
        int n;
        ObservationObject[] observationObjectArray = filterInfo.getObservationObjectList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = null;
        EventProperties eventProperties = null;
        ObservationObject observationObject = null;
        String[] stringArray = null;
        for (int i = 0; i < observationObjectArray.length; ++i) {
            observationObject = observationObjectArray[i];
            stringArray = observationObject.instance_attribute_list;
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                eventProperties = EventHelper.getEventProperties(string);
                if (eventProperties == null || eventProperties.isDeprecated()) continue;
                arrayList.add(new Integer(eventProperties.getId()));
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    private int getUeFraction(FilterInfo filterInfo) {
        int n;
        if (this.hasFilter(filterInfo)) {
            String string = "1000";
            String[] stringArray = filterInfo.getFilter().attribute_name;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("UE_FRACTION")) continue;
                string = filterInfo.getFilter().attribute_value[i];
            }
            n = new Integer(string);
        } else {
            n = 1000;
        }
        return n;
    }

    private boolean getAsn1(FilterInfo filterInfo) {
        boolean bl;
        if (this.hasFilter(filterInfo)) {
            String string = "true";
            String[] stringArray = filterInfo.getFilter().attribute_name;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("ASN1")) continue;
                string = filterInfo.getFilter().attribute_value[i];
            }
            bl = Boolean.valueOf(string);
        } else {
            bl = true;
        }
        return bl;
    }

    private int[] getCells(FilterInfo filterInfo) {
        int n;
        Object[] objectArray;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.hasFilter(filterInfo)) {
            objectArray = filterInfo.getFilter().attribute_name;
            block2: for (n = 0; n < objectArray.length; ++n) {
                if (!objectArray[n].equals("CELL")) continue;
                String string = filterInfo.getFilter().attribute_value[n];
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ManagedObject managedObject = this.pmWrapperProvider.getMoRepository().lookup(string2);
                    try {
                        Integer n2 = (Integer)managedObject.getAttribute("cellId", null);
                        arrayList.add(n2);
                    }
                    catch (MoAccessException moAccessException) {
                        break block2;
                    }
                }
                break;
            }
        }
        objectArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray[n] = (String)((Object)((Integer)arrayList.get(n)));
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("Name = ").append(this.scannerId.getName());
        stringBuffer.append("; State = ").append(this.stateToString(this.taskInfo.getState()));
        stringBuffer.append("; Event id's = ");
        int[] nArray = this.getEventIds(this.filterInfo);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private String stateToString(PerformanceMonitoringState performanceMonitoringState) {
        String string = performanceMonitoringState == PerformanceMonitoringState.ACTIVE ? "ACTIVE" : "SUSPENDED";
        return string;
    }

    private String filterInfoToString(FilterInfo filterInfo) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("\nFilterInfo object {\n  ObservationObjectList: ");
        ObservationObject[] observationObjectArray = filterInfo.getObservationObjectList();
        if (observationObjectArray == null || observationObjectArray.length == 0) {
            if (observationObjectArray == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append("<N/A>");
            }
        } else {
            stringBuffer.append('\n');
            for (int i = 0; i < observationObjectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.observationObjectToString(observationObjectArray[i]));
            }
        }
        stringBuffer.append(this.filterToString(filterInfo.getFilter()));
        stringBuffer.append("\nTrace reference: ");
        stringBuffer.append(filterInfo.getTraceReference());
        stringBuffer.append("\nOutput mode: ");
        this.setOutputMode(filterInfo, stringBuffer);
        stringBuffer.append("\nDestination address: ");
        if (filterInfo.getDestinationAddress() == null) {
            stringBuffer.append(filterInfo.getDestinationAddress());
        } else {
            stringBuffer.append(filterInfo.getDestinationAddress().ip_address);
            stringBuffer.append(':');
            stringBuffer.append(filterInfo.getDestinationAddress().port);
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private void setOutputMode(FilterInfo filterInfo, StringBuffer stringBuffer) {
        if (filterInfo.getOutputMode() == null) {
            stringBuffer.append(filterInfo.getOutputMode());
        } else {
            stringBuffer.append(filterInfo.getOutputMode().value());
        }
    }

    private String observationObjectToString(ObservationObject observationObject) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String[] stringArray = observationObject.instance_list;
        String[] stringArray2 = observationObject.instance_attribute_list;
        stringBuffer.append("  ObservationObject object {\n    Instances : ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("\n                ").append(string);
        }
        stringBuffer.append("\n    Attributes: ");
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            EventProperties eventProperties = EventHelper.getEventProperties(string);
            int n = -1;
            if (eventProperties != null) {
                n = eventProperties.getId();
            }
            if (i == 0) {
                stringBuffer.append(string + '(' + n + ')');
                continue;
            }
            stringBuffer.append("\n                " + string + '(' + n + ')');
        }
        stringBuffer.append("\n  }");
        return stringBuffer.toString();
    }

    private String filterToString(Filter filter) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n  Filter object {");
        if (filter == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("\n    AttNames : ");
            String[] stringArray = filter.attribute_name;
            String[] stringArray2 = filter.attribute_value;
            this.setFilterAttrName(filter, stringBuffer, stringArray);
            stringBuffer.append("\n    AttValues: ");
            if (filter.attribute_value == null) {
                stringBuffer.append("null");
            } else if (filter.attribute_value.length == 0) {
                stringBuffer.append("N/A");
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i != 0) continue;
                    String string = stringArray2[i];
                    if (i == 0) {
                        stringBuffer.append(string);
                        continue;
                    }
                    stringBuffer.append("\n                 ").append(string);
                }
            }
        }
        stringBuffer.append("\n  }");
        return stringBuffer.toString();
    }

    private void setFilterAttrName(Filter filter, StringBuffer stringBuffer, String[] stringArray) {
        if (filter.attribute_name == null) {
            stringBuffer.append("<null>");
        } else if (filter.attribute_name.length == 0) {
            stringBuffer.append("N/A");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (i == 0) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append("\n               ").append(string);
            }
        }
    }
}

