/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmevent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmevent.PmCellTraceScanner;
import se.ericsson.lte.rbs.omf.pmevent.PmUETraceScanner;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmActivateUeTraceScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmDeactivateUeTraceScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;

public class PmEventHandler
implements PmProxyListenerI {
    private static final Class THIS_CLASS = PmEventHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final PmProxyI pmProxy;
    private final PmCellTraceScanner[] cellTraceScanners = new PmCellTraceScanner[6];
    private final Map ueTraceScanners = new HashMap();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private final String[] signals = new String[]{"ConnToServerReq", "OmfPmActivateUeTraceScannerInd", "OmfPmDeactivateUeTraceScannerInd"};

    public PmEventHandler(PmProxyI pmProxyI, PmWrapperProviderI pmWrapperProviderI) {
        logger.info(THIS_CLASS, "Register all event scanners in PMS");
        PmWrapperProviderI pmWrapperProviderI2 = pmWrapperProviderI;
        this.pmProxy = pmProxyI;
        this.pmProxy.register(this, this.signals);
        for (int i = 0; i < this.cellTraceScanners.length; ++i) {
            this.cellTraceScanners[i] = new PmCellTraceScanner(i, this.pmProxy, pmWrapperProviderI2);
        }
    }

    public void receiveSignal(AbstractPmInSignal abstractPmInSignal) throws PmUnsupportedSignalException {
        logger.traceEnter(THIS_CLASS, "receiveSignal");
        if (abstractPmInSignal instanceof ConnToServerReq) {
            logger.traceGeneral(THIS_CLASS, "PmEventHandler received connToServerReq");
            this.signalConnToServerReq();
        } else if (abstractPmInSignal instanceof OmfPmActivateUeTraceScannerInd) {
            logger.traceGeneral(THIS_CLASS, "PmEventHandler received OmfPmActivateUeTraceScannerInd");
            this.signalOmfPmActivateUeTraceScannerInd((OmfPmActivateUeTraceScannerInd)abstractPmInSignal);
        } else if (abstractPmInSignal instanceof OmfPmDeactivateUeTraceScannerInd) {
            logger.traceGeneral(THIS_CLASS, "PmEventHandler received OmfPmDeactivateUeTraceScannerInd");
            this.signalOmfPmDeactivateUeTraceScannerInd((OmfPmDeactivateUeTraceScannerInd)abstractPmInSignal);
        } else {
            throw new PmUnsupportedSignalException();
        }
        logger.traceReturn(THIS_CLASS, "receiveSignal");
    }

    private void signalConnToServerReq() {
        logger.traceEnter(THIS_CLASS, "signalConnToServerReq");
        if (this.pmProxy.isClientConnected()) {
            logger.traceGeneral(THIS_CLASS, "PM Controller reconnecting, reactivating cell trace scanners, removing UE trace scanners");
            for (int i = 0; i < this.cellTraceScanners.length; ++i) {
                if (!this.cellTraceScanners[i].isActive()) continue;
                this.cellTraceScanners[i].reactivate();
            }
            Iterator iterator = this.ueTraceScanners.values().iterator();
            while (iterator.hasNext()) {
                PmUETraceScanner pmUETraceScanner = (PmUETraceScanner)iterator.next();
                pmUETraceScanner.deregister();
            }
            this.ueTraceScanners.clear();
            Object var1_3 = null;
        }
        logger.traceReturn(THIS_CLASS, "signalConnToServerReq");
    }

    private void signalOmfPmActivateUeTraceScannerInd(OmfPmActivateUeTraceScannerInd omfPmActivateUeTraceScannerInd) {
        logger.traceEnter(THIS_CLASS, "signalOmfPmActivateUeTraceScannerInd");
        String string = this.resolveTraceRef(omfPmActivateUeTraceScannerInd.getTraceRef());
        PmUETraceScanner pmUETraceScanner = new PmUETraceScanner(omfPmActivateUeTraceScannerInd.getScannerId(), string);
        if (this.ueTraceScanners.size() >= 16) {
            logger.traceError(THIS_CLASS, "PM Controller trying to activate more than 16 UE trace scanners");
        }
        if (this.ueTraceScanners.containsKey(new Integer(pmUETraceScanner.getInternalScannerId()))) {
            logger.traceError(THIS_CLASS, "Scanner " + pmUETraceScanner.getTaskInfo().getName() + " already created, will be overwritten");
        }
        this.ueTraceScanners.put(new Integer(pmUETraceScanner.getInternalScannerId()), pmUETraceScanner);
        logger.traceGeneral(THIS_CLASS, "UE trace scanner " + pmUETraceScanner.getTaskInfo().getName() + " is activated");
        logger.traceReturn(THIS_CLASS, "signalOmfPmActivateUeTraceScannerInd");
    }

    private void signalOmfPmDeactivateUeTraceScannerInd(OmfPmDeactivateUeTraceScannerInd omfPmDeactivateUeTraceScannerInd) {
        logger.traceEnter(THIS_CLASS, "signalOmfPmDeactivateUeTraceScannerInd");
        PmUETraceScanner pmUETraceScanner = (PmUETraceScanner)this.ueTraceScanners.remove(new Integer(omfPmDeactivateUeTraceScannerInd.getScannerId()));
        if (pmUETraceScanner == null) {
            logger.traceError(THIS_CLASS, "PM Controller trying to remove non existing UE trace scanner " + omfPmDeactivateUeTraceScannerInd.getScannerId());
        } else {
            pmUETraceScanner.deregister();
            logger.traceGeneral(THIS_CLASS, "UE Trace scanner " + pmUETraceScanner.getTaskInfo().getName() + " is deactivated");
            pmUETraceScanner = null;
        }
        logger.traceReturn(THIS_CLASS, "signalOmfPmDeactivateUeTraceScannerInd");
    }

    private String resolveTraceRef(byte[] byArray) {
        char[] cArray = new char[12];
        for (int i = 0; i < byArray.length - 2; ++i) {
            cArray[2 * i] = HEX_CHARS[(byArray[i] & 0xF0) >>> 4];
            cArray[2 * i + 1] = HEX_CHARS[byArray[i] & 0xF];
        }
        return new String(cArray);
    }
}

