/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmevent;

import se.ericsson.cello.pms.generic.FilterInfo;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.InvalidFilterException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.InvalidTriggeringObjectException;
import se.ericsson.cello.pms.generic.MonitoringTaskAccess;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OperationFailedException;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class PmUETraceScanner
implements MonitoringTaskAccess {
    private static final Class THIS_CLASS = PmUETraceScanner.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final FilterInfo filterInfo;
    private final MonitoringTaskInfo taskInfo;
    private final int internalScannerId;
    private final String identity;

    public PmUETraceScanner(int n, String string) {
        this.internalScannerId = n;
        String string2 = new String("PREDEF." + this.internalScannerId + ".UETRACE." + string);
        ScannerId scannerId = new ScannerId(string2);
        this.filterInfo = null;
        this.identity = "Name = " + scannerId.getName();
        this.taskInfo = new MonitoringTaskInfo(scannerId, string2, PerformanceMonitoringState.ACTIVE, new ObservationClass[0], new ObservationObject[0], GranularityPeriod.MINUTES_15, GranularityPeriod.MINUTES_15);
        PmsPortalImpl.getPortal().registerScanner((Object)this, this.taskInfo.getId());
        logger.traceGeneral(THIS_CLASS, "UE Trace scanner " + string2 + " created and registered in PMS");
    }

    protected int getInternalScannerId() {
        return this.internalScannerId;
    }

    protected void deregister() {
        PmsPortalImpl.getPortal().deregisterScanner(this.taskInfo.getId());
    }

    public void delete() throws InvalidPerformanceMonitoringTypeException {
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public MonitoringTaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public FilterInfo lookupFilter() throws InvalidPerformanceMonitoringTypeException {
        return this.filterInfo;
    }

    public void setFilter(FilterInfo filterInfo) throws InvalidPerformanceMonitoringTypeException, InvalidObservationObjectListException, InvalidFilterException, InvalidTriggeringObjectException {
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public void setState(PerformanceMonitoringState performanceMonitoringState) throws OverloadException, OperationFailedException {
        throw new OperationFailedException("setState() is not allowed for UE Trace scanners.");
    }

    public String toString() {
        return this.identity;
    }
}

