/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmpget;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroInfoProvider;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmpget.PmGetCounterValuesI;
import se.ericsson.lte.rbs.omf.pmpget.PmPgetFailureException;
import se.ericsson.lte.rbs.omf.pmpget.PmPgetSignalReceiver;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmCollectInstantCountersRej;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmCollectInstantCountersReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchInstantCountersAppCfm;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchInstantCountersAppReq;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelperException;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler;

public class PmGetCounterValues
implements PmGetCounterValuesI,
PmProxyListenerI {
    private static final Class THIS_CLASS = PmGetCounterValues.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int MAX_NO_OF_COUNTS_IN_COLLECT_REQ = 15750;
    private final PmProxyI pmProxy;
    private final PmStatHandler pmStatHandler;
    private final PmWrapperProviderI pmWrapperProvider;
    private final PmPgetSignalReceiver pmPgetSignalReciever;
    private String ldn;
    private int froId;
    private String moType;
    private List reqCountersInclSubCounters;
    private int[] requestedCounters;
    private int[] nrOfSubCounters;
    private int[] counteredValues;
    private final Map counterIndexMap = new HashMap();
    private final String[] signals = new String[]{"ConnToServerReq"};

    public PmGetCounterValues(PmProxyI pmProxyI, PmStatHandler pmStatHandler, PmWrapperProviderI pmWrapperProviderI) {
        this.pmProxy = pmProxyI;
        this.pmProxy.register(this, this.signals);
        this.pmStatHandler = pmStatHandler;
        this.pmWrapperProvider = pmWrapperProviderI;
        this.pmPgetSignalReciever = new PmPgetSignalReceiver(pmProxyI);
    }

    public void receiveSignal(AbstractPmInSignal abstractPmInSignal) throws PmUnsupportedSignalException {
        if (abstractPmInSignal instanceof ConnToServerReq) {
            if (!this.pmProxy.isClientConnected()) {
                ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
                serviceRepository.addService((Object)this, PmGetCounterValuesI.class, null);
            }
        } else {
            throw new PmUnsupportedSignalException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getCounterValues(String string, String[] stringArray) throws PmPgetFailureException {
        PmGetCounterValues pmGetCounterValues = this;
        synchronized (pmGetCounterValues) {
            this.ldn = string;
            this.requestedCounters = new int[stringArray.length];
            this.nrOfSubCounters = new int[stringArray.length];
            Arrays.fill(this.nrOfSubCounters, 0);
            this.froId = 0;
            ManagedObject managedObject = this.pmWrapperProvider.getMoRepository().lookup(this.ldn);
            this.moType = managedObject.getType();
            try {
                this.froId = ((FroInfoProvider)managedObject).getFroId(null);
            }
            catch (MoAccessException moAccessException) {
                throw new PmPgetFailureException("Function failure, unknown MO - " + string);
            }
            this.reqCountersInclSubCounters = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n;
                    this.requestedCounters[i] = n = CounterHelper.getCounterId(this.moType, stringArray[i]);
                    this.reqCountersInclSubCounters.add(new Integer(n));
                    int n2 = CounterHelper.getCounterType(n);
                    if (!this.isPdfType(n2)) continue;
                    int n3 = CounterHelper.getNoOfValues(n);
                    this.nrOfSubCounters[i] = n3 - 1;
                    for (int j = 1; j < n3; ++j) {
                        if (!CounterHelper.isSubCounter(n + j)) {
                            throw new PmPgetFailureException("Counter " + n + " missing sub counter " + (n + j));
                        }
                        this.reqCountersInclSubCounters.add(new Integer(n + j));
                    }
                    continue;
                }
                catch (CounterHelperException counterHelperException) {
                    throw new PmPgetFailureException("Function failure, unknown Counter - " + stringArray[i]);
                }
            }
            int[] nArray = this.prepare();
            this.fetchCounters(nArray);
            int[][] nArray2 = this.organizeCounterValues();
            this.requestedCounters = null;
            this.nrOfSubCounters = null;
            this.reqCountersInclSubCounters = null;
            this.counterIndexMap.clear();
            return nArray2;
        }
    }

    private boolean isPdfType(int n) {
        return n == 5 || n == 8;
    }

    private int[] prepare() {
        this.counteredValues = new int[this.reqCountersInclSubCounters.size()];
        this.counterIndexMap.clear();
        for (int i = 0; i < this.reqCountersInclSubCounters.size(); ++i) {
            this.counterIndexMap.put(this.reqCountersInclSubCounters.get(i), new Integer(i));
        }
        int[] nArray = this.pmStatHandler.getActiveCounters(this.moType);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        this.setCounterValues(nArray, arrayList);
        int[] nArray2 = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            nArray2[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray2;
    }

    private void setCounterValues(int[] nArray, List list) {
        for (int i = 0; i < this.reqCountersInclSubCounters.size(); ++i) {
            int n = (Integer)this.reqCountersInclSubCounters.get(i);
            if (CounterHelper.isCounterUnSupported(n)) {
                logger.traceAbnormal(THIS_CLASS, "Counter Id: " + n + " of Counter Type: " + CounterHelper.getCounterTypeAsString(n) + " is not Supported");
                this.counteredValues[i] = -2;
                continue;
            }
            boolean bl = false;
            for (int j = 0; !bl && j < nArray.length; ++j) {
                if (n != nArray[j]) continue;
                bl = true;
                this.counteredValues[i] = 0;
                list.add(this.reqCountersInclSubCounters.get(i));
            }
            if (bl) continue;
            this.counteredValues[i] = -1;
        }
    }

    private void fetchCounters(int[] nArray) throws PmPgetFailureException {
        Object object;
        logger.traceGeneral(THIS_CLASS, "Request to get instant counter values MO: " + this.ldn + ", no of requestedCounters: " + this.requestedCounters.length + ", no of reqCountersInclSubCounters: " + this.reqCountersInclSubCounters.size() + ", no of activeCounters: " + nArray.length);
        int n = nArray.length / 15750;
        int n2 = nArray.length % 15750;
        for (int i = 0; i < n; ++i) {
            object = new int[15750];
            System.arraycopy(nArray, i * 15750, object, 0, 15750);
            logger.traceGeneral(THIS_CLASS, "Sequence of split sub request: " + (i + 1) + ", no of counters in req: " + ((int[])object).length + ", first counter id: " + object[0] + ", last counter id: " + object[15749]);
            BlockingQueue blockingQueue = this.performSignaling((int[])object);
            this.dequeueCounterValues(blockingQueue);
        }
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, nArray.length - n2, nArray2, 0, n2);
            logger.traceGeneral(THIS_CLASS, "Sequence of split sub request: " + (n + 1) + ", no of counters in req: " + nArray2.length + ", first counter id: " + nArray2[0] + ", last counter id: " + nArray2[n2 - 1]);
            object = this.performSignaling(nArray2);
            this.dequeueCounterValues((BlockingQueue)object);
        }
    }

    private BlockingQueue performSignaling(int[] nArray) throws PmPgetFailureException {
        this.pmPgetSignalReciever.clear();
        try {
            this.pmProxy.sendSignal((Signal)new OmfPmCollectInstantCountersReq(this.froId, nArray.length, nArray));
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            throw new PmPgetFailureException("Function not available");
        }
        BlockingQueue blockingQueue = this.pmPgetSignalReciever.getSignalQueue(5000L);
        AbstractPmInSignal abstractPmInSignal = null;
        try {
            abstractPmInSignal = (AbstractPmInSignal)((Object)blockingQueue.dequeue());
        }
        catch (InterruptedException interruptedException) {
            throw new PmPgetFailureException("Function failure, interuppted response");
        }
        if (abstractPmInSignal instanceof OmfPmCollectInstantCountersRej) {
            throw new PmPgetFailureException("Function busy");
        }
        if (abstractPmInSignal instanceof OmfPmFetchInstantCountersAppCfm) {
            throw new PmPgetFailureException("Function failure, unexpected response");
        }
        this.pmPgetSignalReciever.clear();
        blockingQueue = null;
        try {
            this.pmProxy.sendSignal((Signal)new OmfPmFetchInstantCountersAppReq(this.froId));
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            throw new PmPgetFailureException("Function not available");
        }
        blockingQueue = this.pmPgetSignalReciever.getSignalQueue(1000L);
        return blockingQueue;
    }

    private void dequeueCounterValues(BlockingQueue blockingQueue) throws PmPgetFailureException {
        AbstractPmInSignal abstractPmInSignal = null;
        OmfPmFetchInstantCountersAppCfm omfPmFetchInstantCountersAppCfm = null;
        do {
            if ((abstractPmInSignal = this.getSignal(blockingQueue)) instanceof OmfPmFetchInstantCountersAppCfm) {
                omfPmFetchInstantCountersAppCfm = (OmfPmFetchInstantCountersAppCfm)abstractPmInSignal;
                int n = omfPmFetchInstantCountersAppCfm.getNoOfCounterDataTriplets();
                for (int i = 0; i < n; ++i) {
                    int n2 = omfPmFetchInstantCountersAppCfm.getFroId(i);
                    int n3 = omfPmFetchInstantCountersAppCfm.getCounterId(i);
                    int n4 = omfPmFetchInstantCountersAppCfm.getCounterDataValue(i);
                    boolean bl = omfPmFetchInstantCountersAppCfm.isSuspect(i);
                    Integer n5 = (Integer)this.counterIndexMap.get(new Integer(n3));
                    if (this.isNotFroId(n5, n2)) {
                        throw new PmPgetFailureException("Function failure, corrupt data: " + n5 + ", " + n2);
                    }
                    if (CounterHelper.isCounterUnSupported(n3)) {
                        logger.traceError(THIS_CLASS, "Counter Id: " + n3 + " of Counter Type: " + CounterHelper.getCounterTypeAsString(n3) + " is not Supported");
                        n4 = -2;
                    } else if (bl) {
                        n4 = -2;
                    }
                    this.counteredValues[n5.intValue()] = n4;
                }
            } else {
                throw new PmPgetFailureException("Function failure, unexpected response");
            }
        } while (!omfPmFetchInstantCountersAppCfm.isEndOfData());
        logger.traceDebug(THIS_CLASS, "Returning instant counter values for MO " + this.ldn);
    }

    private AbstractPmInSignal getSignal(BlockingQueue blockingQueue) throws PmPgetFailureException {
        AbstractPmInSignal abstractPmInSignal = null;
        if (blockingQueue.isEmpty()) {
            logger.traceError(THIS_CLASS, "Expected OmfPmFetchInstantCountersAppCfm signal missing");
            throw new PmPgetFailureException("Function failure, corrupt data");
        }
        try {
            logger.traceDebug(THIS_CLASS, "Trying to enqueue signal");
            abstractPmInSignal = (AbstractPmInSignal)((Object)blockingQueue.dequeue());
            logger.traceDebug(THIS_CLASS, "Signal enqueued");
        }
        catch (InterruptedException interruptedException) {
            throw new PmPgetFailureException("Function failure, interuppted response");
        }
        return abstractPmInSignal;
    }

    private boolean isNotFroId(Integer n, int n2) {
        return n == null || n2 != this.froId;
    }

    private int[][] organizeCounterValues() {
        int[][] nArrayArray = new int[this.requestedCounters.length][];
        for (int i = 0; i < this.requestedCounters.length; ++i) {
            int n = this.requestedCounters[i];
            nArrayArray[i] = CounterHelper.getCounterType(n) == 8 ? this.compressCounterValues(i, n) : this.regularCounterValues(i, n);
        }
        return nArrayArray;
    }

    private int[] regularCounterValues(int n, int n2) {
        int n3 = this.nrOfSubCounters[n];
        int[] nArray = new int[n3 + 1];
        Integer n4 = (Integer)this.counterIndexMap.get(new Integer(n2));
        nArray[0] = this.counteredValues[n4];
        for (int i = 1; i <= n3; ++i) {
            int n5 = n2 + i;
            Integer n6 = (Integer)this.counterIndexMap.get(new Integer(n5));
            nArray[i] = this.counteredValues[n6];
        }
        return nArray;
    }

    private int[] compressCounterValues(int n, int n2) {
        int n3 = this.nrOfSubCounters[n];
        Integer n4 = (Integer)this.counterIndexMap.get(new Integer(n2));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 0;
        for (int i = 0; i <= n3; ++i) {
            int n6 = n4 + i;
            int n7 = this.counteredValues[n6];
            if (n7 <= 0) continue;
            arrayList.add(n5 * 2, new Integer(i));
            arrayList.add(n5 * 2 + 1, new Integer(n7));
            ++n5;
        }
        arrayList.add(0, new Integer(n5));
        int[] nArray = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n8 = 0;
        while (iterator.hasNext()) {
            nArray[n8] = (Integer)iterator.next();
            ++n8;
        }
        return nArray;
    }
}

