/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmproxy;

import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmevent.OmfPmEvents;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmOutSignal;

public class OmfPmActivateCellTraceScannerInd
extends AbstractPmOutSignal {
    private static final int SIGNAL_NUMBER = 23232522;
    private static final Class THIS_CLASS = OmfPmActivateCellTraceScannerInd.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String traceId;
    private final int scannerId;
    private final int ueFraction;
    private final boolean asn1;
    private final int noOfCells;
    private final int[] cells;
    private final int ipAddressLength;
    private final char[] ipAddress;
    private final int port;
    private final int outPutMode;
    private final int noOfEvents;
    private final int[] eventIds;

    public OmfPmActivateCellTraceScannerInd(String string, int n, int n2, int n3, int n4, boolean bl, int[] nArray, int n5, char[] cArray, int[] nArray2) {
        super("OmfPmActivateCellTraceScannerInd", 23232522);
        this.traceId = string;
        this.scannerId = n;
        this.ueFraction = n2;
        this.port = n3;
        this.outPutMode = n4;
        this.asn1 = bl;
        this.noOfCells = nArray.length;
        this.cells = nArray;
        this.ipAddressLength = n5;
        this.ipAddress = cArray;
        this.noOfEvents = nArray2.length;
        this.eventIds = nArray2;
    }

    public void initSend(SignalOutputStream signalOutputStream) throws IOException {
        if (LogHelper.traceParamEnabled(THIS_CLASS)) {
            logger.traceParam(THIS_CLASS, "Parameters for signal OmfPmActivateCellTraceScannerInd: " + this.toString());
        }
        this.sendTraceId(signalOutputStream);
        signalOutputStream.writeS32(this.scannerId);
        signalOutputStream.writeU16(this.ueFraction);
        signalOutputStream.writeU16(this.port);
        signalOutputStream.writeU16(this.outPutMode);
        signalOutputStream.writeOSBOOLEAN(this.asn1);
        signalOutputStream.writeU32((long)this.noOfCells);
        this.sendCellList(signalOutputStream);
        signalOutputStream.writeU16(this.ipAddressLength);
        signalOutputStream.writeU16(0);
        this.sendIpAddress(signalOutputStream);
        signalOutputStream.writeU32((long)this.noOfEvents);
        this.sendEventIdList(signalOutputStream);
        signalOutputStream.writeU16(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("SignalNo = ").append(23232522);
        stringBuffer.append(" TraceId = ").append(this.traceId);
        stringBuffer.append(" ScannerId = ").append(this.scannerId);
        stringBuffer.append(" UeFraction = ").append(this.ueFraction);
        stringBuffer.append(" Port = ").append(this.port);
        stringBuffer.append(" OutPutMode = ").append(this.outPutMode);
        stringBuffer.append(" ASN1 = ").append(this.asn1);
        stringBuffer.append(" NoOfCells = ").append(this.noOfCells);
        stringBuffer.append(" CELLs = {");
        stringBuffer.append(this.convertIntegerList(this.cells));
        stringBuffer.append("} IpAddressLength = ").append(this.ipAddressLength);
        stringBuffer.append(" IpAddress = ").append(this.ipAddress);
        stringBuffer.append(" NoOfEvents = ").append(this.noOfEvents);
        stringBuffer.append(" Events = {");
        stringBuffer.append(this.convertIntegerList(this.eventIds)).append('}');
        return stringBuffer.toString();
    }

    private String convertIntegerList(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = nArray.length < 5 ? nArray.length : 5;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        if (nArray.length > 10) {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    private void sendTraceId(SignalOutputStream signalOutputStream) throws IOException {
        byte[] byArray = this.convertTraceId(this.traceId);
        if (byArray.length > 8) {
            throw new IOException("Attribute TraceId is too long! Maximum 8 Bytes allowed, actual length: " + byArray.length);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        signalOutputStream.writeS8Array(byArray2);
    }

    private void sendEventIdList(SignalOutputStream signalOutputStream) throws IOException {
        if (this.eventIds != null) {
            int n;
            for (n = 0; n < this.eventIds.length; ++n) {
                signalOutputStream.writeU16(this.eventIds[n]);
                logger.traceDebug(((Object)((Object)this)).getClass(), "Event id: " + this.eventIds[n]);
            }
            while (n < OmfPmEvents.pmEvents.length) {
                signalOutputStream.writeU16(0);
                ++n;
            }
        }
    }

    private void sendIpAddress(SignalOutputStream signalOutputStream) throws IOException {
        if (this.ipAddress != null) {
            int n;
            for (n = 0; n < this.ipAddress.length; ++n) {
                signalOutputStream.writeU8((int)this.ipAddress[n]);
            }
            while (n < 40) {
                signalOutputStream.writeU8(0);
                ++n;
            }
        }
    }

    private void sendCellList(SignalOutputStream signalOutputStream) throws IOException {
        if (this.cells != null) {
            int n;
            for (n = 0; n < this.cells.length; ++n) {
                signalOutputStream.writeU32((long)this.cells[n]);
            }
            while (n < 24) {
                signalOutputStream.writeU32(0L);
                ++n;
            }
        }
    }

    protected byte[] convertTraceId(String string) {
        char[] cArray = string.toCharArray();
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = Character.digit(cArray[i * 2], 16);
            int n4 = n3 << 4 | (n2 = Character.digit(cArray[i * 2 + 1], 16));
            if (n4 > 127) {
                n4 -= 256;
            }
            byArray[i] = (byte)n4;
        }
        return byArray;
    }
}

