/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmproxy;

import enea.ose.io.SignalInputStream;
import java.io.IOException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;

public class OmfPmFetchInstantCountersAppCfm
extends AbstractPmInSignal {
    private static final int SIGNAL_NUMBER = 23232529;
    private static final Class THIS_CLASS = OmfPmFetchInstantCountersAppCfm.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private int froId;
    private boolean endOfData;
    private int counterDataLength;
    private int[] counterData;

    public OmfPmFetchInstantCountersAppCfm() {
        super("OmfPmFetchInstantCountersAppCfm", 23232529);
    }

    public int getFroId(int n) {
        return this.counterData[n * 3 + 1];
    }

    public boolean isEndOfData() {
        return this.endOfData;
    }

    public int getNoOfCounterDataTriplets() {
        return this.counterDataLength;
    }

    public int getCounterId(int n) {
        return this.counterData[n * 3];
    }

    public int getCounterDataValue(int n) {
        return this.counterData[n * 3 + 2] & Integer.MAX_VALUE;
    }

    public boolean isSuspect(int n) {
        return (this.counterData[n * 3 + 2] & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    protected boolean initReceive(SignalInputStream signalInputStream) throws IOException {
        this.endOfData = signalInputStream.readS8() != 0;
        this.counterDataLength = signalInputStream.readS32();
        this.counterData = new int[this.counterDataLength * 3];
        for (int i = 0; i < this.counterDataLength; ++i) {
            this.counterData[i * 3] = signalInputStream.readS32();
            this.counterData[i * 3 + 1] = signalInputStream.readS32();
            this.counterData[i * 3 + 2] = signalInputStream.readS32();
        }
        logger.traceParam(THIS_CLASS, "Parameters for signal OmfPmFetchInstantCountersAppCfm: " + this.toString());
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("SignalNo = ").append(23232529);
        stringBuffer.append(" froId = ");
        if (this.counterDataLength > 0) {
            stringBuffer.append(this.froId);
        } else {
            stringBuffer.append("N/A");
        }
        stringBuffer.append(" counterDataLenght = ").append(this.counterDataLength);
        stringBuffer.append(" counterData [counterId, froId, value] = ");
        if (this.counterDataLength == 0) {
            stringBuffer.append("[<noCounterData>]");
        } else {
            for (int i = 0; i < this.counterDataLength; ++i) {
                stringBuffer.append(" [");
                stringBuffer.append(this.counterData[i * 3] + ",");
                stringBuffer.append(this.counterData[i * 3 + 1] + ",");
                if (this.isSuspect(i)) {
                    stringBuffer.append(" <suspect> ]");
                    continue;
                }
                stringBuffer.append(this.counterData[i * 3 + 2] + "]");
            }
        }
        stringBuffer.append(" endOfData = ").append(this.endOfData);
        return stringBuffer.toString();
    }
}

