/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelperException;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterProperties;
import se.ericsson.lte.rbs.omf.pmstatistic.OmfPmCounters;

public final class CounterHelper {
    private static final Class THIS_CLASS = CounterHelper.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final char STRING_KEY_SEPARATOR = ':';
    private static final SortedMap counterPropertiesPerId = new TreeMap();
    private static final SortedMap counterPropertiesPerName = new TreeMap();
    private static final SortedMap counterIdPerName = new TreeMap();
    private static final SortedMap gaugeCounters = new TreeMap();
    public static final int UNSUPPORTED_COUNTER = -2;
    public static final int SUSPECT_MARK_COUNT_WHOLE_MO = -1;
    public static final int SUSPECT_MARK_COUNT_NOT_WHOLE_MO = -2;

    private CounterHelper() {
    }

    private static void initializeCounterProperties() {
        for (int i = 0; i < OmfPmCounters.moTypes.length; ++i) {
            CounterProperties[] counterPropertiesArray = OmfPmCounters.allCounters[i];
            for (int j = 0; j < counterPropertiesArray.length; ++j) {
                CounterProperties counterProperties = counterPropertiesArray[j];
                counterPropertiesPerId.put(new Integer(counterProperties.getId()), counterProperties);
                counterPropertiesPerName.put(CounterHelper.createStringKey(OmfPmCounters.moTypes[i], counterProperties.getName()), counterProperties);
                counterIdPerName.put(CounterHelper.createStringKey(OmfPmCounters.moTypes[i], counterProperties.getName()), new Integer(counterProperties.getId()));
                if (!counterProperties.isGauge()) continue;
                gaugeCounters.put(CounterHelper.createStringKey(OmfPmCounters.moTypes[i], counterProperties.getName()), counterProperties);
            }
        }
    }

    public static boolean isMoTypeUnknown(ObservationClass[] observationClassArray) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            bl = false;
            for (n = 0; n < OmfPmCounters.moTypes.length && !bl; ++n) {
                if (!string.equals(OmfPmCounters.moTypes[n])) continue;
                bl = true;
            }
            if (!bl) break;
        }
        return !bl;
    }

    public static int getNoOfMoTypes() {
        return OmfPmCounters.moTypes.length - 1;
    }

    public static String getMoType(int n) {
        String string = n < 0 || n >= OmfPmCounters.moTypes.length ? "" : OmfPmCounters.moTypes[n];
        return string;
    }

    public static String[] getCounters(String string) {
        String[] stringArray;
        Collection collection = CounterHelper.getCounterProperties(string).values();
        String[] stringArray2 = new String[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CounterProperties counterProperties = (CounterProperties)iterator.next();
            if (counterProperties.isSubCounter()) continue;
            stringArray2[n++] = counterProperties.getName();
        }
        if (n < stringArray2.length) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        } else {
            stringArray = stringArray2;
        }
        if ("ENodeBFunction".equals(string)) {
            String[] stringArray3 = CounterHelper.getCounters("Fake");
            int n2 = stringArray3.length + stringArray.length;
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            System.arraycopy(stringArray3, 0, stringArray2, stringArray.length, stringArray3.length);
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        }
        return stringArray;
    }

    public static int[] getNoOfElements(String string) {
        int[] nArray;
        Collection collection = CounterHelper.getCounterProperties(string).values();
        int[] nArray2 = new int[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CounterProperties counterProperties = (CounterProperties)iterator.next();
            if (counterProperties.isSubCounter()) continue;
            nArray2[n++] = counterProperties.getNoOfValues();
        }
        if (n < nArray2.length) {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        } else {
            nArray = nArray2;
        }
        if ("ENodeBFunction".equals(string)) {
            int[] nArray3 = CounterHelper.getNoOfElements("Fake");
            int n2 = nArray3.length + nArray.length;
            nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            System.arraycopy(nArray3, 0, nArray2, nArray.length, nArray3.length);
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        return nArray;
    }

    public static int getNoOfValues(int n) {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        return counterProperties.getNoOfValues();
    }

    public static int[] getCounterIds(ObservationClass[] observationClassArray) {
        Object object;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (observationClassArray != null && observationClassArray.length > 0) {
            for (n = 0; n < observationClassArray.length; ++n) {
                object = observationClassArray[n].class_attribute_list;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    try {
                        int n2 = CounterHelper.getCounterId(observationClassArray[n].object_class_name, (String)object[i]);
                        arrayList.add(new Integer(n2));
                        CounterHelper.findSubcounters(arrayList, n2);
                        continue;
                    }
                    catch (CounterHelperException counterHelperException) {
                        logger.traceAbnormal(THIS_CLASS, counterHelperException.getMessage());
                    }
                }
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Integer)arrayList.get(n);
            nArray[n] = (Integer)object;
        }
        return nArray;
    }

    private static void findSubcounters(List list, int n) throws CounterHelperException {
        int[] nArray = null;
        int n2 = CounterHelper.getCounterType(n);
        if (n2 == 5 || n2 == 8) {
            nArray = CounterHelper.getSubCounters(n);
            for (int i = 0; i < nArray.length; ++i) {
                list.add(new Integer(nArray[i]));
            }
        }
    }

    public static int[] getCounterIds(ObservationClass observationClass) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (observationClass != null) {
            String[] stringArray = observationClass.class_attribute_list;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n = CounterHelper.getCounterId(observationClass.object_class_name, stringArray[i]);
                    arrayList.add(new Integer(n));
                    CounterHelper.findSubcounters(arrayList, n);
                    continue;
                }
                catch (CounterHelperException counterHelperException) {
                    logger.traceAbnormal(THIS_CLASS, counterHelperException.getMessage());
                }
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            nArray[i] = n;
        }
        return nArray;
    }

    public static int getCounterId(String string, String string2) throws CounterHelperException {
        Integer n = (Integer)counterIdPerName.get(CounterHelper.createStringKey(string, string2));
        if (n == null && "ENodeBFunction".equals(string)) {
            n = (Integer)counterIdPerName.get(CounterHelper.createStringKey("Fake", string2));
        }
        if (n == null) {
            throw new CounterHelperException("Counter " + string2 + " not found.");
        }
        return n;
    }

    public static int getCounterType(int n) {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        return counterProperties.getCounterType();
    }

    public static boolean isCounterUnSupported(int n) {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        boolean bl = counterProperties.isSupported();
        return !bl;
    }

    public static String getCounterTypeAsString(int n) {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        return counterProperties.getCounterTypeAsString();
    }

    public static String getCountersString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(": ");
        String[] stringArray = CounterHelper.getCounters(string);
        int[] nArray = CounterHelper.getNoOfElements(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(", ").append(nArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    public static boolean isSubCounter(int n) throws CounterHelperException {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        if (counterProperties == null) {
            throw new CounterHelperException("Counter with id " + n + " not found.");
        }
        return counterProperties.isSubCounter();
    }

    public static List getGaugeCounters(String string) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = gaugeCounters.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            arrayList.add(gaugeCounters.get(string2));
        }
        return arrayList;
    }

    public static CounterProperties getGaugeCounter(int n) {
        CounterProperties counterProperties = null;
        Iterator iterator = gaugeCounters.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (((CounterProperties)gaugeCounters.get(string)).getId() != n) continue;
            counterProperties = (CounterProperties)gaugeCounters.get(string);
            break;
        }
        return counterProperties;
    }

    private static SortedMap getCounterProperties(String string) {
        return counterPropertiesPerName.subMap(string, string + ':' + '\uffff');
    }

    private static int[] getSubCounters(int n) throws CounterHelperException {
        CounterProperties counterProperties = (CounterProperties)counterPropertiesPerId.get(new Integer(n));
        int n2 = counterProperties.getNoOfValues() - 1;
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            CounterProperties counterProperties2 = (CounterProperties)counterPropertiesPerId.get(new Integer(n + i + 1));
            if (counterProperties2 == null || !counterProperties2.isSubCounter()) {
                throw new CounterHelperException("OmfPmCounters.java class error. PDF counter " + n + " missing sub counter " + n + i + 1);
            }
            nArray[i] = counterProperties2.getId();
        }
        return nArray;
    }

    private static String createStringKey(String string, String string2) {
        return string + ':' + string2;
    }

    public static int pmLicConnectedUsersDistrPdf2CorrespondingPercentValue(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 5;
                break;
            }
            case 1: {
                n2 = 10;
                break;
            }
            case 2: {
                n2 = 15;
                break;
            }
            case 3: {
                n2 = 20;
                break;
            }
            case 4: {
                n2 = 25;
                break;
            }
            case 5: {
                n2 = 30;
                break;
            }
            case 6: {
                n2 = 35;
                break;
            }
            case 7: {
                n2 = 40;
                break;
            }
            case 8: {
                n2 = 45;
                break;
            }
            case 9: {
                n2 = 50;
                break;
            }
            case 10: {
                n2 = 55;
                break;
            }
            case 11: {
                n2 = 60;
                break;
            }
            case 12: {
                n2 = 65;
                break;
            }
            case 13: {
                n2 = 70;
                break;
            }
            case 14: {
                n2 = 75;
                break;
            }
            case 15: {
                n2 = 80;
                break;
            }
            case 16: {
                n2 = 85;
                break;
            }
            case 17: {
                n2 = 90;
                break;
            }
            case 18: {
                n2 = 95;
                break;
            }
            case 19: {
                n2 = 100;
                break;
            }
            case 20: {
                n2 = 125;
                break;
            }
            case 21: {
                n2 = 150;
                break;
            }
            case 22: {
                n2 = 200;
                break;
            }
            case 23: {
                n2 = 65535;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    static {
        CounterHelper.initializeCounterProperties();
    }
}

