/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.pms.generic.MeasuredDataReusable;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroInfoProvider;
import se.ericsson.lte.rbs.omf.pmcommon.PmMisc;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatCounterValueException;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatValueStorage;

public class PmStatObservedMoStorage {
    private static final String E_NODE_B_FUNCTION_MO_TYPE = "ENodeBFunction";
    private static final Class THIS_CLASS = PmStatObservedMoStorage.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final PmStatValueStorage[] valueStorages;
    private final Map[] observedMoMaps;
    private final String[] observedMoTypes;
    private final List lookedUpMos;
    private final PmWrapperProviderI pmWrapperProvider;

    public PmStatObservedMoStorage(ObservationClass[] observationClassArray, PmWrapperProviderI pmWrapperProviderI) {
        logger.traceGeneral(THIS_CLASS, "Creating observed MO storage and value storage");
        this.pmWrapperProvider = pmWrapperProviderI;
        ArrayList<PmStatValueStorage> arrayList = new ArrayList<PmStatValueStorage>();
        this.lookedUpMos = new ArrayList();
        this.observedMoMaps = new HashMap[observationClassArray.length];
        this.observedMoTypes = new String[observationClassArray.length];
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            String[] stringArray = observationClassArray[i].class_attribute_list;
            this.observedMoTypes[i] = string;
            this.observedMoMaps[i] = new HashMap();
            this.moRepositoryLookUp(string);
            if (this.lookedUpMos.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "No MO is added as observed");
            } else {
                Iterator iterator = this.lookedUpMos.iterator();
                while (iterator.hasNext()) {
                    LookedUpMo lookedUpMo = (LookedUpMo)iterator.next();
                    String string2 = this.createObservedMoKey(string, lookedUpMo.froId);
                    ObservedMo observedMo = new ObservedMo(lookedUpMo.ldn, lookedUpMo.froId, string, i);
                    Map map = this.getObservedMoMap(string);
                    map.put(string2, observedMo);
                    if (!LogHelper.traceDebugEnabled(THIS_CLASS)) continue;
                    logger.traceDebug(THIS_CLASS, "MO " + lookedUpMo.toString() + " is added as observed");
                }
            }
            arrayList.add(new PmStatValueStorage(string, this.getLookedUpMosLdns(), stringArray, this.pmWrapperProvider));
        }
        this.valueStorages = arrayList.toArray(new PmStatValueStorage[arrayList.size()]);
    }

    private Map getObservedMoMap(String string) {
        Map map = null;
        for (int i = 0; i < this.observedMoTypes.length; ++i) {
            if (!string.equalsIgnoreCase(this.observedMoTypes[i])) continue;
            map = this.observedMoMaps[i];
            break;
        }
        return map;
    }

    public void setMeasuredData(int n, int n2, int n3, boolean bl) throws PmStatCounterValueException {
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, this.toString());
        }
        if (n < 0) {
            logger.traceError(THIS_CLASS, "Unvalid counter Id " + n);
        } else {
            String string = this.getMoTypeFromCounterId(n);
            String string2 = this.createObservedMoKey(n2, string);
            Map map = this.getObservedMoMap(string);
            if (map == null) {
                logger.traceError(THIS_CLASS, "No observed Mo for Counter id:" + n + ", Mo Type:" + string);
            } else {
                ObservedMo observedMo = (ObservedMo)map.get(string2);
                if (observedMo == null) {
                    throw new PmStatCounterValueException("MO with id " + n2 + " is not an observed MO");
                }
                this.valueStorages[observedMo.containerIndex].setMeasuredData(observedMo.ldn, n, n2, n3, bl);
            }
        }
    }

    public void validateMeasuredData() {
        for (int i = 0; i < this.valueStorages.length; ++i) {
            this.valueStorages[i].validateMeasuredData();
        }
    }

    public void setSuspectFlag() {
        for (int i = 0; i < this.valueStorages.length; ++i) {
            this.valueStorages[i].setSuspectFlag();
        }
    }

    public MeasuredDataReusable[] getMeasuredData() {
        MeasuredDataReusable[] measuredDataReusableArray = new MeasuredDataReusable[this.valueStorages.length];
        for (int i = 0; i < measuredDataReusableArray.length; ++i) {
            measuredDataReusableArray[i] = this.valueStorages[i].getMeasuredData();
        }
        return measuredDataReusableArray;
    }

    public void reset() {
        for (int i = 0; i < this.valueStorages.length; ++i) {
            ObservedMo observedMo;
            String string = this.valueStorages[i].getMoType();
            long l = PmMisc.startTime();
            Thread.yield();
            long l2 = PmMisc.timeSpent(l);
            logger.traceDebug(THIS_CLASS, "Mid ROP refresh of MO type " + string + " started after yield: " + l2);
            if (this.valueStorages[i].isLocked()) {
                logger.traceDebug(THIS_CLASS, "ValueStorage locked by PMS, creating new");
                this.valueStorages[i].recreate(this.getObservedMosLdns(string));
            }
            this.moRepositoryLookUp(string);
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = this.lookedUpMos.iterator();
            while (iterator.hasNext()) {
                LookedUpMo lookedUpMo = (LookedUpMo)iterator.next();
                String string2 = this.createObservedMoKey(string, lookedUpMo.froId);
                Map map = this.getObservedMoMap(string);
                observedMo = (ObservedMo)map.get(string2);
                if (observedMo == null) {
                    this.handleUnknownObservedMo(string, string2, lookedUpMo, i);
                } else if (observedMo.ldn.equals(lookedUpMo.ldn)) {
                    this.handleLnownLdnObservedMo(observedMo, lookedUpMo);
                } else {
                    this.handleUnknownLdnObservedMo(string, string2, observedMo, lookedUpMo, linkedList, i);
                }
                linkedList.add(lookedUpMo.ldn);
            }
            this.validateUpdated(string, i);
            this.valueStorages[i].resetMeasuredDataValues();
            observedMo = null;
        }
    }

    private void handleUnknownLdnObservedMo(String string, String string2, ObservedMo observedMo, LookedUpMo lookedUpMo, List list, int n) {
        Map map = this.getObservedMoMap(string);
        map.remove(string2);
        if (!list.contains(observedMo.ldn)) {
            this.valueStorages[n].removeObservedMo(observedMo.ldn);
        }
        ObservedMo observedMo2 = new ObservedMo(lookedUpMo.ldn, lookedUpMo.froId, string, n);
        observedMo2.setUpdated(true);
        map.put(string2, observedMo2);
        this.valueStorages[n].addObservedMo(lookedUpMo.ldn);
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, "MO " + observedMo.toString() + " is replaced with " + lookedUpMo.toString() + " as observed");
        }
    }

    private void handleLnownLdnObservedMo(ObservedMo observedMo, LookedUpMo lookedUpMo) {
        observedMo.setUpdated(true);
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, "MO " + lookedUpMo.toString() + " is reset");
        }
    }

    private void handleUnknownObservedMo(String string, String string2, LookedUpMo lookedUpMo, int n) {
        ObservedMo observedMo = new ObservedMo(lookedUpMo.ldn, lookedUpMo.froId, string, n);
        observedMo.setUpdated(true);
        Map map = this.getObservedMoMap(string);
        map.put(string2, observedMo);
        this.valueStorages[n].addObservedMo(lookedUpMo.ldn);
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, "MO " + lookedUpMo.toString() + " is added as observed");
        }
    }

    private void validateUpdated(String string, int n) {
        Map map = this.getObservedMoMap(string);
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ObservedMo observedMo = (ObservedMo)iterator.next();
                if (observedMo.updated) {
                    observedMo.setUpdated(false);
                    continue;
                }
                iterator.remove();
                if (this.pmWrapperProvider.getMoRepository().lookup(observedMo.ldn) == null) {
                    this.valueStorages[n].removeObservedMo(observedMo.ldn);
                }
                if (!LogHelper.traceDebugEnabled(THIS_CLASS)) continue;
                logger.traceDebug(THIS_CLASS, "MO " + observedMo.toString() + " removed as observed");
            }
        }
    }

    public void completeGaugeCollection() {
        for (int i = 0; i < this.valueStorages.length; ++i) {
            this.valueStorages[i].completeGaugeCollection();
        }
    }

    private void moRepositoryLookUp(String string) {
        logger.traceDebug(THIS_CLASS, "Getting instances for " + string + " in repository");
        this.lookedUpMos.clear();
        MoIterator moIterator = this.pmWrapperProvider.getMoRepository().lookupType(string);
        if (moIterator == null || moIterator.size() == 0) {
            logger.traceDebug(THIS_CLASS, "No MO found");
        } else {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                String string2 = managedObject.getLocalDistinguishedName();
                if (managedObject.getClass().toString().indexOf("Deprecated") != -1) continue;
                try {
                    int n = ((FroInfoProvider)managedObject).getFroId(null);
                    LookedUpMo lookedUpMo = new LookedUpMo(string2, n);
                    this.lookedUpMos.add(lookedUpMo);
                    if (!LogHelper.traceDebugEnabled(THIS_CLASS)) continue;
                    logger.traceDebug(THIS_CLASS, "MO found: " + lookedUpMo.toString());
                }
                catch (MoAccessException moAccessException) {
                    logger.traceError(THIS_CLASS, moAccessException.getMessage());
                }
            }
        }
    }

    private String[] getObservedMosLdns(String string) {
        String[] stringArray;
        Map map = this.getObservedMoMap(string);
        if (map == null) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[map.size()];
            int n = 0;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ObservedMo observedMo = (ObservedMo)iterator.next();
                if (!observedMo.moType.equals(string)) continue;
                stringArray[n++] = observedMo.ldn;
            }
        }
        return stringArray;
    }

    private String[] getLookedUpMosLdns() {
        String[] stringArray = new String[this.lookedUpMos.size()];
        int n = 0;
        Iterator iterator = this.lookedUpMos.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((LookedUpMo)iterator.next()).ldn;
        }
        return stringArray;
    }

    private String createObservedMoKey(int n, String string) {
        String string2 = "Fake".equals(string) ? this.createObservedMoKey(E_NODE_B_FUNCTION_MO_TYPE, n) : this.createObservedMoKey(string, n);
        return string2;
    }

    private String getMoTypeFromCounterId(int n) {
        int n2 = (n >> 16) - 1;
        String string = CounterHelper.getMoType(n2);
        if ("Fake".equals(string)) {
            string = E_NODE_B_FUNCTION_MO_TYPE;
        }
        return string;
    }

    private String createObservedMoKey(String string, int n) {
        return new String(string + n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("PmStatObservedMoStorage Object {\n  Observed MO's:");
        for (int i = 0; i < this.observedMoMaps.length; ++i) {
            Iterator iterator = this.observedMoMaps[i].values().iterator();
            while (iterator.hasNext()) {
                ObservedMo observedMo = (ObservedMo)iterator.next();
                stringBuffer.append(observedMo.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private class ObservedMo {
        private final String ldn;
        private final int froId;
        private final String moType;
        private final int containerIndex;
        private boolean updated;

        public ObservedMo(String string, int n, String string2, int n2) {
            this.ldn = string;
            this.froId = n;
            this.moType = string2;
            this.containerIndex = n2;
            this.updated = false;
        }

        public void setUpdated(boolean bl) {
            this.updated = bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append('\"').append(this.ldn);
            stringBuffer.append("\"(").append(this.froId);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    private class LookedUpMo {
        private final String ldn;
        private final int froId;

        public LookedUpMo(String string, int n) {
            this.ldn = string;
            this.froId = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append('\"').append(this.ldn);
            stringBuffer.append("\"(").append(this.froId);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

