/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import enea.ose.system.Signal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.MeasuredDataReusable;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.ValueContainerUpdatable;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmActivateCounterScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmDeactivateCounterScannerInd;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchScannerDataCfm;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatCounterValueException;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatObservedMoStorage;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScannerFactory;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScannerHistory;

public class PmStatScanner
extends BasicScanner {
    private static final Class THIS_CLASS = PmStatScanner.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final int scannerId;
    private final int[] counterIds;
    private int scannerState = 1;
    private boolean held = false;
    private boolean scanInvoked = false;
    private boolean scanComplete = false;
    private boolean firstROP = true;
    private int scanCounter = 0;
    private final ObservationClass[] observationClasses;
    private final PmProxyI pmProxy;
    private final PmStatHandler pmStatHandler;
    private PmStatObservedMoStorage observedMoStorage;
    private final PmStatScannerHistory scannerHistory;

    public static PmStatScanner create(PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator, int n, ObservationClass[] observationClassArray, PmStatHandler pmStatHandler) throws GranularityAndAttributeActivationException, OverloadException {
        PerformanceMonitoringState performanceMonitoringState2 = performanceMonitoringState;
        if ("PREDEF.STATS".equals(string) && PerformanceMonitoringState.SUSPENDED.equals(performanceMonitoringState)) {
            performanceMonitoringState2 = PerformanceMonitoringState.ACTIVE;
        }
        logger.traceEnter(THIS_CLASS, "create(" + string + "), state: " + (PerformanceMonitoringState.ACTIVE == performanceMonitoringState2 ? "active" : "suspended"));
        PerformanceMonitoringState performanceMonitoringState3 = pmStatHandler.isCompleted() ? performanceMonitoringState2 : PerformanceMonitoringState.SUSPENDED;
        PmStatScanner pmStatScanner = new PmStatScanner(GranularityPeriod.MINUTES_15, performanceMonitoringState3, dataConsumer, string, coordinator, n, observationClassArray, pmStatHandler, performanceMonitoringState);
        if (!pmStatHandler.isCompleted() && performanceMonitoringState2 == PerformanceMonitoringState.ACTIVE) {
            logger.traceDebug(THIS_CLASS, "PmStatHandler is not complete, setting scanner " + string + " as held.");
            pmStatScanner.setAsHeld(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "create(" + string + ")");
        return pmStatScanner;
    }

    PmStatScanner(GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator, int n, ObservationClass[] observationClassArray, PmStatHandler pmStatHandler, PerformanceMonitoringState performanceMonitoringState2) {
        super(granularityPeriod, performanceMonitoringState, dataConsumer, string, coordinator);
        logger.traceGeneral(THIS_CLASS, "Creating scanner " + string);
        this.scannerId = n;
        this.observationClasses = observationClassArray;
        this.counterIds = CounterHelper.getCounterIds(this.observationClasses);
        this.pmStatHandler = pmStatHandler;
        this.pmStatHandler.addScanner(this);
        this.pmProxy = this.pmStatHandler.getProxy();
        this.scannerHistory = new PmStatScannerHistory();
        this.scannerHistory.setInitialStateFromFactory(performanceMonitoringState2);
        if (performanceMonitoringState == PerformanceMonitoringState.ACTIVE) {
            this.scannerState = 0;
            this.activate();
            this.scannerHistory.addStateChange("CON");
        } else {
            logger.traceGeneral(THIS_CLASS, "scanner " + string + " should not be activated.");
        }
    }

    public void setScannerState(PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException {
        super.setScannerState(performanceMonitoringState, coordinator);
        logger.traceGeneral(THIS_CLASS, "State for scanner " + this.getTracePrefix() + " set to " + (performanceMonitoringState.equals(PerformanceMonitoringState.ACTIVE) ? "ACTIVE" : "SUSPENDED") + ".");
        if (performanceMonitoringState.equals(PerformanceMonitoringState.ACTIVE) && this.scannerState == 1) {
            this.scannerState = 0;
            this.activate();
            this.scannerHistory.addStateChange("ACT");
        } else if (performanceMonitoringState.equals(PerformanceMonitoringState.SUSPENDED) && this.scannerState == 0) {
            this.scannerState = 1;
            this.deactivate();
            this.scannerHistory.addStateChange("SUS");
        }
    }

    public void release() {
        if (this.held) {
            logger.traceDebug(THIS_CLASS, "Releasing scanner " + this.getTracePrefix());
            this.activate();
            this.scannerHistory.addStateChange("REL");
            this.held = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        try {
            logger.traceGeneral(THIS_CLASS, "Activating scanner " + this.getTracePrefix());
            this.observedMoStorage = new PmStatObservedMoStorage(this.observationClasses, this.pmStatHandler.getWrapperProvider());
            logger.traceDebug(THIS_CLASS, "Value storage created");
            this.createAndSendOmfPmActivateCounterScannerIndSignals();
            logger.traceGeneral(THIS_CLASS, "Scanner " + this.getTracePrefix() + " is activated");
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            logger.traceError(THIS_CLASS, " Scanner " + this.getTracePrefix() + " not activated", (Throwable)pmNoClientConnectedException);
            this.scannerHistory.addError("E01");
            this.scannerHistory.addException(pmNoClientConnectedException);
        }
        finally {
            this.firstROP = true;
        }
    }

    private void createAndSendOmfPmActivateCounterScannerIndSignals() throws PmNoClientConnectedException {
        Object object;
        logger.traceEnter(THIS_CLASS, "createAndSendOmfPmActivateCounterScannerIndSignals()");
        int n = this.counterIds.length / 15750;
        int n2 = this.counterIds.length % 15750;
        for (int i = 0; i < n; ++i) {
            object = new int[15750];
            System.arraycopy(this.counterIds, i * 15750, object, 0, 15750);
            int n3 = i == n - 1 && n2 == 0 ? 1 : 0;
            OmfPmActivateCounterScannerInd omfPmActivateCounterScannerInd = new OmfPmActivateCounterScannerInd(this.scannerId, n3, this.counterIds.length, ((int[])object).length, (int[])object);
            this.pmProxy.sendSignal((Signal)omfPmActivateCounterScannerInd);
        }
        if (n2 > 0) {
            int[] nArray = new int[n2];
            System.arraycopy(this.counterIds, this.counterIds.length - n2, nArray, 0, n2);
            object = (Object)new OmfPmActivateCounterScannerInd(this.scannerId, 1, this.counterIds.length, nArray.length, nArray);
            this.pmProxy.sendSignal((Signal)object);
        }
        logger.traceReturn(THIS_CLASS, "createAndSendOmfPmActivateCounterScannerIndSignals()");
    }

    private void setAsHeld(Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException {
        super.setScannerState(PerformanceMonitoringState.ACTIVE, coordinator);
        this.scannerState = 0;
        this.held = true;
        this.scannerHistory.setWasHeld();
        logger.traceDebug(THIS_CLASS, "Scanner " + this.getTracePrefix() + " held, PM Application not yet started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reactivate() {
        try {
            this.observedMoStorage.reset();
            this.createAndSendOmfPmActivateCounterScannerIndSignals();
            logger.info(THIS_CLASS, "Scanner " + this.getTracePrefix() + " reactivated");
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            logger.traceError(THIS_CLASS, "PmStatScanner:reactivate scannerId - " + this.scannerId + " Exception caught: " + ExceptionHelper.convertToString((Throwable)pmNoClientConnectedException));
            this.scannerHistory.addError("E02");
            this.scannerHistory.addException(pmNoClientConnectedException);
        }
        finally {
            this.firstROP = true;
        }
    }

    public boolean isHeld() {
        return this.held;
    }

    public boolean isActive() {
        boolean bl = this.scannerState == 0;
        return bl;
    }

    public boolean isSuspended() {
        boolean bl = this.scannerState == 1;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        try {
            this.pmProxy.sendSignal((Signal)new OmfPmDeactivateCounterScannerInd(this.scannerId));
            logger.traceGeneral(THIS_CLASS, "Scanner " + this.getTracePrefix() + " is deactivated");
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            logger.traceDebug(THIS_CLASS, pmNoClientConnectedException.getMessage());
        }
        finally {
            this.observedMoStorage = null;
        }
    }

    public void delete(Coordinator coordinator) {
        if (this.getName().equalsIgnoreCase("PREDEF.STATS")) {
            logger.traceAbnormal(THIS_CLASS, "Attempt to delete predefined counter scanner (only allowed at upgrade) " + this.getName() + ", ignored.");
            return;
        }
        this.deleteScanner(coordinator);
    }

    private void deleteScanner(Coordinator coordinator) {
        if (this.isActive()) {
            this.deactivate();
            this.scannerHistory.addStateChange("DEL");
        }
        PmStatScannerFactory.getInstance().freeScannerId(this.getScannerId());
        this.pmStatHandler.removeScanner(this);
        super.delete(coordinator);
        logger.traceGeneral(THIS_CLASS, this.getTracePrefix() + "Scanner deleted.");
    }

    public void init() {
        logger.traceGeneral(THIS_CLASS, this.getTracePrefix() + "Init invoked.");
        this.scan();
    }

    public void scan() {
        if (this.pmStatHandler.isCompleted()) {
            logger.traceGeneral(THIS_CLASS, "Scan request for scanner " + this.getTracePrefix() + " from PMS. First ROP = " + this.firstROP);
            this.scanInvoked = true;
            if (this.isSuspended()) {
                logger.traceError(THIS_CLASS, "Scanner " + this.getTracePrefix() + " suspended, scan will be ignored");
                this.scannerHistory.addError("E03");
                return;
            }
            if (this.firstROP) {
                logger.traceGeneral(THIS_CLASS, this.getTracePrefix() + " First ROP for scanner.");
                if (this.scanCounter > 4) {
                    logger.traceError(THIS_CLASS, "PM counters are not reported! Not reported last " + this.scanCounter + " ROP periods. Workaround: Restart JVM! Trouble shooting info:\n" + this.pmStatHandler.tracePmROPTimerTS());
                }
                ++this.scanCounter;
            }
        }
    }

    public void printScannerDebugInfo() {
        PerformanceMonitoringState performanceMonitoringState = super.getScannerState();
        boolean bl = PerformanceMonitoringState.ACTIVE.equals(performanceMonitoringState) != this.isActive();
        if (LogHelper.traceDebugEnabled(PmStatScanner.class) || bl) {
            Exception exception;
            String string;
            String string2 = "Trouble Shooting info for " + this.getTracePrefix();
            string2 = string2 + " BasicScanner(CPP) is active: " + PerformanceMonitoringState.ACTIVE.equals(performanceMonitoringState);
            string2 = string2 + " PmStatScanner is active: " + this.isActive() + " (" + this.scannerState + ")";
            string2 = string2 + " InitialStateFromFactory was active: " + PerformanceMonitoringState.ACTIVE.equals(this.scannerHistory.getInitialStateFromFactory());
            string2 = string2 + " isHeld: " + this.isHeld();
            string2 = string2 + " wasHeld: " + this.scannerHistory.isWasHeld();
            this.traceDebugOrInfo(string2, bl);
            String string3 = this.scannerHistory.getStateChanges();
            if (string3.length() > 0) {
                this.traceDebugOrInfo("State change history: " + string3, bl);
            }
            if ((string = this.scannerHistory.getErrors()).length() > 0) {
                this.traceDebugOrInfo("Error history: " + string, bl);
            }
            if ((exception = this.scannerHistory.getLastException()) != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                this.traceDebugOrInfo("Last exception (occured in history): " + exception.getMessage() + " " + stringWriter.toString(), bl);
            }
        }
    }

    private void traceDebugOrInfo(String string, boolean bl) {
        if (bl) {
            logger.info(THIS_CLASS, string);
        } else {
            logger.traceDebug(THIS_CLASS, string);
        }
    }

    public void receiveSignal(OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm) {
        logger.traceGeneral(THIS_CLASS, "Receiving measured data for scanner " + this.getTracePrefix());
        if (this.isSuspended()) {
            this.fetchedDataIfSuspended();
        } else if (this.scanComplete) {
            this.fetchedDataIfAlreadyCollected();
        } else if (omfPmFetchScannerDataCfm.getNoOfCounterDataTriplets() == 0 && !omfPmFetchScannerDataCfm.isEndOfData()) {
            this.fetchedDataIfEmptySignal();
        } else {
            this.setMeasuredData(omfPmFetchScannerDataCfm);
            if (omfPmFetchScannerDataCfm.isEndOfData()) {
                logger.traceGeneral(THIS_CLASS, "'End of data' flag received for scanner " + this.getTracePrefix());
                this.completeCollection();
            }
        }
    }

    private void fetchedDataIfSuspended() {
        logger.traceError(THIS_CLASS, "Scanner " + this.getTracePrefix() + " is suspended, received " + " measured data ignored");
    }

    private void fetchedDataIfAlreadyCollected() {
        logger.traceError(THIS_CLASS, this.getTracePrefix() + "Received measured data ignored, end of data already received");
    }

    private void fetchedDataIfEmptySignal() {
        logger.traceError(THIS_CLASS, "No 'data' or 'end of data' sent from PmController for scanner " + this.getTracePrefix());
    }

    private void setMeasuredData(OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm) {
        int n = omfPmFetchScannerDataCfm.getNoOfCounterDataTriplets();
        for (int i = 0; i < n; ++i) {
            int n2 = omfPmFetchScannerDataCfm.getCounterId(i);
            int n3 = omfPmFetchScannerDataCfm.getFroId(i);
            int n4 = omfPmFetchScannerDataCfm.getCounterDataValue(i);
            boolean bl = omfPmFetchScannerDataCfm.isSuspect(i);
            try {
                this.observedMoStorage.setMeasuredData(n2, n3, n4, bl);
                continue;
            }
            catch (PmStatCounterValueException pmStatCounterValueException) {
                if (pmStatCounterValueException.isErrorException()) {
                    logger.traceError(THIS_CLASS, pmStatCounterValueException.getMessage());
                    continue;
                }
                logger.traceGeneral(THIS_CLASS, pmStatCounterValueException.getMessage());
            }
        }
    }

    protected void handleScannerData(OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm) {
        this.setMeasuredData(omfPmFetchScannerDataCfm);
        if (omfPmFetchScannerDataCfm.isEndOfData()) {
            logger.traceGeneral(THIS_CLASS, "'End of data' flag received for scanner " + this.getTracePrefix());
            this.completeCollection();
        }
    }

    private void completeCollection() {
        this.scanComplete = true;
        this.observedMoStorage.validateMeasuredData();
        this.observedMoStorage.completeGaugeCollection();
    }

    public void push() {
        if (this.firstROP) {
            this.firstROP = false;
            logger.traceGeneral(THIS_CLASS, "First ROP for scanner " + this.getTracePrefix() + ", push to PMS ignored");
        } else if (this.scanInvoked) {
            MeasuredDataReusable[] measuredDataReusableArray;
            if (!this.scanComplete) {
                this.observedMoStorage.setSuspectFlag();
                logger.traceGeneral(THIS_CLASS, "All measured data for scanner " + this.getTracePrefix() + " is tagged as suspect");
            }
            if ((measuredDataReusableArray = this.observedMoStorage.getMeasuredData()) == null) {
                logger.traceError(THIS_CLASS, "No measured data for scanner " + this.getTracePrefix() + " pushed, invalid storage(null)");
            } else if (measuredDataReusableArray.length == 0) {
                logger.traceAbnormal(THIS_CLASS, "No measured data for scanner " + this.getTracePrefix() + " pushed, invalid storage (no storage exist)");
            } else {
                if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
                    logger.traceDebug(THIS_CLASS, "Pushing measured data for scanner " + this.getTracePrefix() + " to PMS \n" + this.getMeasuredDataString((MeasuredData[])measuredDataReusableArray));
                }
                this.destination.push((MeasuredData[])measuredDataReusableArray, this.getSeqNo());
                logger.traceGeneral(THIS_CLASS, "Measured data for scanner " + this.getTracePrefix() + " pushed to PMS");
            }
        } else {
            logger.traceError(THIS_CLASS, "No measured data for scanner " + this.getTracePrefix() + " pushed, no scan request from PMS received");
        }
    }

    public void reset() {
        logger.traceGeneral(THIS_CLASS, "Starting Mid ROP reset of scanner " + this.getTracePrefix());
        this.scanInvoked = false;
        this.scanComplete = false;
        try {
            this.observedMoStorage.reset();
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Unknown exception caught:" + exception.getClass().getName() + ", " + exception.getMessage());
        }
        logger.traceDebug(THIS_CLASS, "Mid ROP reset of scanner " + this.getTracePrefix() + " completed");
    }

    public String getName() {
        return this.name;
    }

    public int getScannerId() {
        return this.scannerId;
    }

    public int[] getCounters(String string) {
        int[] nArray = null;
        for (int i = 0; i < this.observationClasses.length; ++i) {
            if (!this.observationClasses[i].object_class_name.equals(string)) continue;
            nArray = CounterHelper.getCounterIds(this.observationClasses[i]);
        }
        return nArray;
    }

    public boolean isFirstROP() {
        return this.firstROP;
    }

    private String getMeasuredDataString(MeasuredData[] measuredDataArray) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        for (int i = 0; i < measuredDataArray.length; ++i) {
            MeasuredDataReusable measuredDataReusable = (MeasuredDataReusable)measuredDataArray[i];
            Iterator iterator = measuredDataReusable.getMeasuredValuesIterator();
            while (iterator.hasNext()) {
                ValueContainerUpdatable valueContainerUpdatable = (ValueContainerUpdatable)iterator.next();
                stringBuffer.append("ValueContainerUpdatable Object {\n  MO:");
                stringBuffer.append(valueContainerUpdatable.getMoId());
                stringBuffer.append("\n  IntValues:");
                for (int j = 0; j < valueContainerUpdatable.getIntValues().length; ++j) {
                    stringBuffer.append(valueContainerUpdatable.getIntValues()[j]);
                    if (j >= valueContainerUpdatable.getIntValues().length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\n  ObjValues:");
                Object[] objectArray = valueContainerUpdatable.getObjectValues();
                if (objectArray.length == 0) {
                    stringBuffer.append('-');
                }
                this.appendValues(stringBuffer, objectArray);
                stringBuffer.append("\n}");
            }
        }
        return stringBuffer.toString();
    }

    private void appendValues(StringBuffer stringBuffer, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            int[] nArray = (int[])objectArray[i];
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append(nArray[j]);
                if (j >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
    }

    public final String getTracePrefix() {
        return this.name + '(' + this.scannerId + ')';
    }

    public String toString() {
        return this.name + '.' + this.scannerId;
    }
}

