/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.omg.CORBA.INITIALIZE;
import se.ericsson.cello.pkimgmt.PkiClient;
import se.ericsson.cello.pkimgmt.PkiClientException;
import se.ericsson.cello.pkimgmt.PkiClientMgr;
import se.ericsson.security.corba.CertificateUtil;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class X509TrustManager
implements javax.net.ssl.X509TrustManager {
    protected final javax.net.ssl.X509TrustManager standardTrustManager;
    protected final KeyStore keystore;
    List trustedCertList = new ArrayList();
    protected X509Certificate[] localCertificate;
    public static final String trustedCertsPath;
    protected final long poolingWait = 1500L;
    private static final int OK = 0;
    private static final int NOK = 1;
    private static final int TC_NOK = 2;
    private static final int Dont_Know = 3;
    protected final long GRACE_PERIOD_MILLIS = 3599000L;
    protected static TraceErrorLogger logger;
    private static final Class thisClass;
    static /* synthetic */ Class class$se$ericsson$security$corba$X509TrustManager;

    public X509TrustManager(String string, String string2) throws NoSuchAlgorithmException, KeyStoreException {
        this.keystore = this.prepareKeystore();
        this.localCertificate = this.prepareLocalCertificate(string, string2);
        logger.trace(1, thisClass, "Default TrustManager algorithm: " + TrustManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.keystore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("X509 trust manager not supported");
        }
        this.standardTrustManager = (javax.net.ssl.X509TrustManager)trustManagerArray[0];
    }

    public X509Certificate[] getAcceptedIssuers() {
        logger.trace(1, this.getClass(), "getAcceptedIssuers");
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.standardTrustManager.getAcceptedIssuers().clone();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            logger.trace(1, this.getClass(), x509CertificateArray[i].getIssuerDN().getName());
        }
        return x509CertificateArray;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException, IllegalArgumentException {
        logger.trace(1, this.getClass(), "checkClientTrusted, authType = " + string);
        if (string == null || x509CertificateArray == null || string.length() == 0 || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("Null or zero-length parameters!!");
        }
        boolean bl = this.compareCertificates(x509CertificateArray);
        if (bl) {
            logger.trace(1, this.getClass(), "SSL/TLS peer is using local certificate.");
            if (!this.validateCertificate(x509CertificateArray, this.localCertificate)) {
                throw new CertificateException("Invalid certificate when checking locally");
            }
        } else {
            try {
                logger.trace(1, this.getClass(), "SSL/TLS peer is using corba peer certificate.");
                if (!this.getRevocationStatus(x509CertificateArray, this.trustedCertList)) {
                    throw new CertificateException("Certificate has been revoked");
                }
                this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
                logger.trace(1, this.getClass(), "Client is trusted");
            }
            catch (CertificateException certificateException) {
                logger.trace(1, this.getClass(), "Invalid certificate when checking by standard trust manager " + certificateException.getMessage());
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    logger.trace(1, this.getClass(), ((Object)x509CertificateArray[i].getSubjectDN()).toString());
                    if (!x509CertificateArray[i].hasUnsupportedCriticalExtension()) continue;
                    logger.trace(1, this.getClass(), "hasUnsupportedCriticalExtension");
                }
                throw new CertificateException("Invalid certificate when checking by standard trust manager. " + certificateException.getMessage());
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IllegalArgumentException, CertificateException {
        this.standardTrustManager.checkServerTrusted(x509CertificateArray, string);
    }

    protected boolean compareCertificates(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray.length != this.localCertificate.length) {
            return false;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (x509CertificateArray[i].equals(this.localCertificate[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean getRevocationStatus(X509Certificate[] x509CertificateArray, List list) {
        X509Certificate x509Certificate = this.getTrustedCert(x509CertificateArray, list);
        if (x509Certificate != null) {
            logger.trace(1, this.getClass(), "trusted certificate response: " + x509Certificate.getSigAlgName());
            PkiClient pkiClient = PkiClientMgr.getPkiClient();
            try {
                int n = 0;
                long l = 1500L;
                int n2 = pkiClient.getRevocStatus(x509CertificateArray, x509Certificate, n);
                if (n2 == 3) {
                    while (l <= 6000L) {
                        n = (l += 1500L) < 6000L ? 0 : 1;
                        try {
                            Thread.sleep(1500L);
                            n2 = pkiClient.getRevocStatus(x509CertificateArray, x509Certificate, n);
                            if (n2 != 3) continue;
                            logger.info(this.getClass(), "Certificate revocation response is Don't Know after " + l / 1000L + " second");
                            return true;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return true;
                }
                if (n2 == 0) {
                    logger.trace(1, this.getClass(), "Certificate revocation response is OK");
                    return true;
                }
                if (n2 == 1) {
                    logger.trace(1, this.getClass(), "Certificate has been revoked");
                    return false;
                }
                if (n2 == 2) {
                    logger.trace(1, this.getClass(), "Trusted Certificate has been revoked");
                    return false;
                }
            }
            catch (PkiClientException pkiClientException) {
                logger.info(this.getClass(), "Some problem in PKI client");
            }
        }
        return false;
    }

    protected X509Certificate getTrustedCert(X509Certificate[] x509CertificateArray, List list) {
        for (int i = 0; i <= x509CertificateArray.length - 1; ++i) {
            for (int j = 0; j <= list.size() - 1; ++j) {
                try {
                    if (x509CertificateArray[i].equals(list.get(j))) {
                        return (X509Certificate)list.get(j);
                    }
                    x509CertificateArray[i].verify(((X509Certificate)list.get(j)).getPublicKey());
                    return (X509Certificate)list.get(j);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        logger.info(this.getClass(), "No trusted certificate found");
        return null;
    }

    protected boolean validateCertificate(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        if (x509CertificateArray2.length != x509CertificateArray.length) {
            return false;
        }
        try {
            long l = System.currentTimeMillis();
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (l > 3599000L) {
                    x509CertificateArray[i].checkValidity();
                }
                x509CertificateArray[i].verify(x509CertificateArray2[i + 1 < x509CertificateArray.length ? i + 1 : x509CertificateArray.length - 1].getPublicKey());
            }
            return true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            logger.traceStack(1, this.getClass(), "", certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            logger.traceStack(1, this.getClass(), "", certificateNotYetValidException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.traceStack(1, this.getClass(), "", invalidKeyException);
        }
        catch (CertificateException certificateException) {
            logger.traceStack(1, this.getClass(), "", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.traceStack(1, this.getClass(), "", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            logger.traceStack(1, this.getClass(), "", noSuchProviderException);
        }
        catch (SignatureException signatureException) {
            logger.traceStack(1, this.getClass(), "", signatureException);
        }
        return false;
    }

    private KeyStore prepareKeystore() {
        KeyStore keyStore = null;
        TraceErrorLogger traceErrorLogger = new TraceErrorLogger();
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            File file = new File(trustedCertsPath);
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".trustedCert");
                }
            });
            if (fileArray == null) {
                traceErrorLogger.trace(1, thisClass, "No trusted certificates found in " + trustedCertsPath);
                return keyStore;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                this.importCertificate(fileArray[i].getAbsolutePath(), keyStore);
            }
            traceErrorLogger.trace(1, thisClass, "Imported " + keyStore.size() + " trusted certificates from " + trustedCertsPath);
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            traceErrorLogger.traceStack(1, thisClass, "", keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            traceErrorLogger.traceStack(1, thisClass, "", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            traceErrorLogger.traceStack(1, thisClass, "", certificateException);
        }
        catch (IOException iOException) {
            traceErrorLogger.traceStack(1, thisClass, "", iOException);
        }
        return keyStore;
    }

    private void importCertificate(String string, KeyStore keyStore) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = 0;
            while (byteArrayInputStream.available() > 0) {
                Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                this.trustedCertList.add((X509Certificate)certificate);
                keyStore.setCertificateEntry(string + n, certificate);
                ++n;
                logger.trace(1, thisClass, "Imported certificate from " + string);
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.info(thisClass, "Could not find certificate file:" + fileNotFoundException.getMessage());
        }
        catch (CertificateException certificateException) {
            logger.info(thisClass, "Got CertificateException:" + certificateException.getMessage());
        }
        catch (IOException iOException) {
            logger.info(thisClass, "Got IOException: " + iOException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        logger.info(thisClass, "Could not import certificate: " + string);
    }

    private X509Certificate[] prepareLocalCertificate(String string, String string2) {
        logger.trace(1, thisClass, "prepareLocalCertificate for " + string);
        File file = new File(string);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        X509Certificate[] x509CertificateArray = null;
        try {
            KeyStore keyStore = CertificateUtil.getPKCS12KeyStore();
            FileInputStream fileInputStream = new FileInputStream(file);
            logger.trace(1, thisClass, "Loading KeyStore");
            keyStore.load(fileInputStream, string2.toCharArray());
            logger.trace(1, thisClass, "KeyStore Successfully loaded");
            Enumeration<String> enumeration = keyStore.aliases();
            logger.trace(1, thisClass, "Check aliases");
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                logger.trace(1, thisClass, "Found alias " + string3);
                Certificate[] certificateArray = keyStore.getCertificateChain(string3);
                if (certificateArray != null) {
                    logger.trace(1, thisClass, "Cert chain for alias " + string3 + " is length " + certificateArray.length);
                    for (int i = 0; i < certificateArray.length; ++i) {
                        logger.trace(1, thisClass, "Adding certificate " + certificateArray[i].getType());
                        arrayList.add(certificateArray[i]);
                    }
                    continue;
                }
                logger.trace(1, thisClass, "No certificate found for alias " + string3);
            }
            logger.trace(1, this.getClass(), string + " - Closing file");
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            logger.trace(1, this.getClass(), string + " - File closed");
            logger.trace(1, this.getClass(), "Creating X509Certificate");
            x509CertificateArray = new X509Certificate[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                x509CertificateArray[i] = (X509Certificate)arrayList.get(i);
            }
            logger.trace(1, this.getClass(), "Returning X509Certificate");
            return x509CertificateArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.traceStack(1, this.getClass(), "", fileNotFoundException);
            throw new INITIALIZE("The local p12 certificate file could not be found at: " + file);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.traceStack(1, this.getClass(), "", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            logger.traceStack(1, this.getClass(), "", certificateException);
        }
        catch (IOException iOException) {
            logger.traceStack(1, this.getClass(), "", iOException);
        }
        catch (KeyStoreException keyStoreException) {
            logger.traceStack(1, thisClass, "", keyStoreException);
            throw new INITIALIZE("Could not get certificate chain. " + keyStoreException.getMessage());
        }
        throw new INITIALIZE("The local p12 certificate file: " + file + " is broken. ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperties().containsKey("JAVASIM")) {
            String string = System.getProperty("CPP_SYS_ROOT");
            trustedCertsPath = System.getProperty("javasim.trustedCertsPath", string + "/control/OAM_CRX10115_1/OAM-SIMCELLO_CNX9010224/test/simcello_example/security/trustedCerts/corba_peers");
        } else if (System.getProperties().containsKey("SIM")) {
            trustedCertsPath = "/host/security/trustedCerts/corba_peers/";
        } else {
            String string = System.getProperty("se.ericsson.security.Testing");
            trustedCertsPath = System.getProperty("os.name").toUpperCase().indexOf("WIN") == -1 && string != null && string.equals("ON") ? "/home/" + System.getProperty("user.name") + "/c/security/trustedCerts/corba_peers/" : "/c/security/trustedCerts/corba_peers/";
        }
        logger = new TraceErrorLogger();
        thisClass = class$se$ericsson$security$corba$X509TrustManager == null ? (class$se$ericsson$security$corba$X509TrustManager = X509TrustManager.class$("se.ericsson.security.corba.X509TrustManager")) : class$se$ericsson$security$corba$X509TrustManager;
    }
}

