/*
 * Decompiled with CFR 0.152.
 */
package com.jtheory.jdring;

import com.jtheory.jdring.AlarmListener;
import com.jtheory.jdring.PastDateException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class AlarmEntry
implements Comparable,
Serializable {
    private int[] minutes = new int[]{-1};
    private static int minMinute = 0;
    private static int maxMinute = 59;
    private int[] hours = new int[]{-1};
    private static int minHour = 0;
    private static int maxHour = 23;
    private int[] daysOfMonth = new int[]{-1};
    private static int minDayOfMonth = 1;
    private int[] months = new int[]{-1};
    private static int minMonth = 0;
    private static int maxMonth = 11;
    private int[] daysOfWeek = new int[]{-1};
    private static int minDayOfWeek = 1;
    private static int maxDayOfWeek = 7;
    private int year = -1;
    private String name;
    private static int UNIQUE = 0;
    private boolean ringInNewThread = false;
    private boolean isRelative;
    public boolean isRepeating;
    public long alarmTime;
    private long lastUpdateTime;
    private transient AlarmListener listener;
    private transient boolean debug = false;

    private void debug(String string) {
        if (this.debug) {
            System.out.println("[" + Thread.currentThread().getName() + "] AlarmEntry " + this.name + ": " + string);
        }
    }

    public AlarmEntry(String string, Date date, AlarmListener alarmListener) throws PastDateException {
        this.setName(string);
        this.listener = alarmListener;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.minutes = new int[]{calendar.get(12)};
        this.hours = new int[]{calendar.get(11)};
        this.daysOfMonth = new int[]{calendar.get(5)};
        this.months = new int[]{calendar.get(2)};
        this.year = calendar.get(1);
        this.isRepeating = false;
        this.isRelative = false;
        this.alarmTime = date.getTime();
        this.checkAlarmTime();
    }

    public AlarmEntry(Date date, AlarmListener alarmListener) throws PastDateException {
        this(null, date, alarmListener);
    }

    public AlarmEntry(String string, int n, boolean bl, AlarmListener alarmListener) throws PastDateException {
        if (n < 1) {
            throw new PastDateException();
        }
        this.setName(string);
        this.minutes = new int[]{n};
        this.listener = alarmListener;
        this.isRepeating = bl;
        this.isRelative = true;
        this.updateAlarmTime();
    }

    public AlarmEntry(int n, boolean bl, AlarmListener alarmListener) throws PastDateException {
        this(null, n, bl, alarmListener);
    }

    public AlarmEntry(String string, int n, int n2, int n3, int n4, int n5, int n6, AlarmListener alarmListener) throws PastDateException {
        this(string, new int[]{n}, new int[]{n2}, new int[]{n3}, new int[]{n4}, new int[]{n5}, n6, alarmListener);
    }

    public AlarmEntry(int n, int n2, int n3, int n4, int n5, int n6, AlarmListener alarmListener) throws PastDateException {
        this(null, n, n2, n3, n4, n5, n6, alarmListener);
    }

    public AlarmEntry(String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, AlarmListener alarmListener) throws PastDateException {
        this.setName(string);
        this.minutes = nArray;
        this.hours = nArray2;
        this.daysOfMonth = nArray3;
        this.months = nArray4;
        this.daysOfWeek = nArray5;
        this.year = n;
        this.listener = alarmListener;
        this.isRepeating = n == -1;
        this.isRelative = false;
        this.updateAlarmTime();
        this.checkAlarmTime();
    }

    public AlarmEntry(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, AlarmListener alarmListener) throws PastDateException {
        this(null, nArray, nArray2, nArray3, nArray4, nArray5, n, alarmListener);
    }

    private void setName(String string) {
        this.name = string;
        if (this.name == null) {
            this.name = "alarm" + UNIQUE++;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setRingInNewThead() {
        this.ringInNewThread = true;
    }

    public boolean isRingInNewThread() {
        return this.ringInNewThread;
    }

    void checkAlarmTime() throws PastDateException {
        if (System.currentTimeMillis() > this.alarmTime) {
            this.alarmTime = System.currentTimeMillis() + 2000L;
        }
    }

    public void ringAlarm() {
        this.listener.handleAlarm(this);
    }

    public void updateAlarmTime() {
        Calendar calendar = Calendar.getInstance();
        if (this.isRelative) {
            this.alarmTime = calendar.getTime().getTime() + (long)(this.minutes[0] * 60000);
            return;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(13, 0);
        this.debug("now: " + calendar.getTime());
        int n = calendar2.get(12);
        int n2 = 0;
        n2 = AlarmEntry.getOffsetToNext(n, minMinute, maxMinute, this.minutes);
        calendar2.add(12, n2);
        this.debug("after min: " + calendar2.getTime());
        n = calendar2.get(11);
        n2 = AlarmEntry.getOffsetToNextOrEqual(n, minHour, maxHour, this.hours);
        calendar2.add(11, n2);
        this.debug("after hour (current:" + n + "): " + calendar2.getTime());
        if (this.daysOfMonth[0] != -1 && this.daysOfWeek[0] != -1) {
            Calendar calendar3 = (Calendar)calendar2.clone();
            this.updateDayOfWeekAndMonth(calendar3);
            Calendar calendar4 = (Calendar)calendar2.clone();
            this.updateDayOfMonthAndMonth(calendar4);
            if (calendar4.getTime().getTime() < calendar3.getTime().getTime()) {
                calendar2 = calendar4;
                this.debug("after dayOfMonth CLOSER: " + calendar2.getTime());
            } else {
                calendar2 = calendar3;
                this.debug("after dayOfWeek CLOSER: " + calendar2.getTime());
            }
        } else if (this.daysOfWeek[0] != -1) {
            this.updateDayOfWeekAndMonth(calendar2);
            this.debug("after dayOfWeek: " + calendar2.getTime());
        } else if (this.daysOfMonth[0] != -1) {
            this.updateDayOfMonthAndMonth(calendar2);
            this.debug("after dayOfMonth: " + calendar2.getTime());
        }
        this.debug("alarm: " + calendar2.getTime());
        this.alarmTime = calendar2.getTime().getTime();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    void updateDayOfMonthAndMonth(Calendar calendar) {
        int n = calendar.get(2);
        int n2 = calendar.get(5);
        int n3 = 0;
        while (!AlarmEntry.isIn(n, this.months) || !AlarmEntry.isIn(n2, this.daysOfMonth)) {
            if (!AlarmEntry.isIn(n, this.months)) {
                n3 = AlarmEntry.getOffsetToNextOrEqual(n, minMonth, maxMonth, this.months);
                calendar.add(2, n3);
                calendar.set(5, 1);
                n2 = 1;
            }
            if (!AlarmEntry.isIn(n2, this.daysOfMonth)) {
                int n4 = calendar.getActualMaximum(5);
                n3 = AlarmEntry.getOffsetToNextOrEqual(n2, minDayOfMonth, n4, this.daysOfMonth);
                calendar.add(5, n3);
            }
            n = calendar.get(2);
            n2 = calendar.get(5);
        }
    }

    void updateDayOfWeekAndMonth(Calendar calendar) {
        int n = calendar.get(2);
        int n2 = calendar.get(7);
        int n3 = 0;
        while (!AlarmEntry.isIn(n, this.months) || !AlarmEntry.isIn(n2, this.daysOfWeek)) {
            if (!AlarmEntry.isIn(n, this.months)) {
                n3 = AlarmEntry.getOffsetToNextOrEqual(n, minMonth, maxMonth, this.months);
                calendar.add(2, n3);
                calendar.set(5, 1);
                n2 = calendar.get(7);
            }
            if (!AlarmEntry.isIn(n2, this.daysOfWeek)) {
                n3 = AlarmEntry.getOffsetToNextOrEqual(n2, minDayOfWeek, maxDayOfWeek, this.daysOfWeek);
                calendar.add(6, n3);
            }
            n2 = calendar.get(7);
            n = calendar.get(2);
        }
    }

    static int getOffsetToNext(int n, int n2, int n3, int[] nArray) {
        int n4 = 0;
        if (nArray[0] == -1) {
            n4 = 1;
        } else if (n >= AlarmEntry.last(nArray)) {
            int n5 = nArray[0];
            n4 = n3 - n + 1 + (n5 - n2);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (n >= nArray[i]) continue;
                n4 = nArray[i] - n;
                break;
            }
        }
        return n4;
    }

    static int getOffsetToNextOrEqual(int n, int n2, int n3, int[] nArray) {
        int n4 = 0;
        int[] nArray2 = null;
        if (nArray[0] == -1 || AlarmEntry.isIn(n, nArray)) {
            n4 = 0;
        } else {
            nArray2 = AlarmEntry.discardValuesOverMax(nArray, n3);
            if (n > AlarmEntry.last(nArray2)) {
                int n5 = nArray2[0];
                n4 = n3 - n + 1 + (n5 - n2);
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (n >= nArray2[i]) continue;
                    n4 = nArray2[i] - n;
                    break;
                }
            }
        }
        return n4;
    }

    static boolean isIn(int n, int[] nArray) {
        if (nArray[0] == -1) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    static int last(int[] nArray) {
        return nArray[nArray.length - 1];
    }

    static int[] discardValuesOverMax(int[] nArray, int n) {
        int[] nArray2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            nArray2 = new int[i];
            System.arraycopy(nArray, 0, nArray2, 0, i);
            return nArray2;
        }
        return nArray;
    }

    private static String arrToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "{}";
        }
        String string = "{";
        for (int i = 0; i < nArray.length - 1; ++i) {
            string = string + nArray[i] + ", ";
        }
        string = string + nArray[nArray.length - 1] + "}";
        return string;
    }

    public int compareTo(Object object) {
        AlarmEntry alarmEntry = (AlarmEntry)object;
        if (this.alarmTime < alarmEntry.alarmTime) {
            return -1;
        }
        if (this.alarmTime > alarmEntry.alarmTime) {
            return 1;
        }
        if (this.lastUpdateTime < alarmEntry.lastUpdateTime) {
            return -1;
        }
        if (this.lastUpdateTime > alarmEntry.lastUpdateTime) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        AlarmEntry alarmEntry = null;
        if (object == null || !(object instanceof AlarmEntry)) {
            return false;
        }
        alarmEntry = (AlarmEntry)object;
        return this.name.equals(alarmEntry.name) && this.alarmTime == alarmEntry.alarmTime && this.isRelative == alarmEntry.isRelative && this.isRepeating == alarmEntry.isRepeating && Arrays.equals(this.minutes, alarmEntry.minutes) && Arrays.equals(this.hours, alarmEntry.hours) && Arrays.equals(this.daysOfMonth, alarmEntry.daysOfMonth) && Arrays.equals(this.months, alarmEntry.months) && Arrays.equals(this.daysOfWeek, alarmEntry.daysOfWeek);
    }

    public String toString() {
        if (this.year != -1) {
            return "Alarm (" + this.name + ") at " + new Date(this.alarmTime);
        }
        StringBuffer stringBuffer = new StringBuffer("Alarm (" + this.name + ") params");
        stringBuffer.append(" minute=");
        stringBuffer.append(AlarmEntry.arrToString(this.minutes));
        stringBuffer.append(" hour=");
        stringBuffer.append(AlarmEntry.arrToString(this.hours));
        stringBuffer.append(" dayOfMonth=");
        stringBuffer.append(AlarmEntry.arrToString(this.daysOfMonth));
        stringBuffer.append(" month=");
        stringBuffer.append(AlarmEntry.arrToString(this.months));
        stringBuffer.append(" dayOfWeek=");
        stringBuffer.append(AlarmEntry.arrToString(this.daysOfWeek));
        stringBuffer.append(" (next alarm date=" + new Date(this.alarmTime) + ")");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("GETTING OFFSETS");
        System.out.println("getOffsetToNext(3, 0, 11, new int[]{3,5,7,9}) = " + AlarmEntry.getOffsetToNext(3, 0, 11, new int[]{3, 5, 7, 9}));
        System.out.println("getOffsetToNextOrEqual(3, 0, 11, new int[]{3,5,7,9}) = " + AlarmEntry.getOffsetToNextOrEqual(3, 0, 11, new int[]{3, 5, 7, 9}));
        System.out.println();
        System.out.println("getOffsetToNext(9, 0, 11, new int[]{3,5,7,9}) = " + AlarmEntry.getOffsetToNext(9, 0, 11, new int[]{3, 5, 7, 9}));
        System.out.println("getOffsetToNextOrEqual(9, 0, 11, new int[]{3,5,7,9}) = " + AlarmEntry.getOffsetToNextOrEqual(9, 0, 11, new int[]{3, 5, 7, 9}));
        System.out.println();
        System.out.println("getOffsetToNext(0, 0, 11, new int[]{0}) = " + AlarmEntry.getOffsetToNext(0, 0, 11, new int[]{0}));
        System.out.println("getOffsetToNextOrEqual(0, 0, 11, new int[]{0}) = " + AlarmEntry.getOffsetToNextOrEqual(0, 0, 11, new int[]{0}));
        System.out.println();
        System.out.println("getOffsetToNext(5, 0, 11, new int[]{5}) = " + AlarmEntry.getOffsetToNext(5, 0, 11, new int[]{5}));
        System.out.println("getOffsetToNextOrEqual(5, 0, 11, new int[]{5}) = " + AlarmEntry.getOffsetToNextOrEqual(5, 0, 11, new int[]{5}));
        System.out.println();
        System.out.println("getOffsetToNext(0, 0, 11, new int[]{-1}) = " + AlarmEntry.getOffsetToNext(0, 0, 11, new int[]{-1}));
        System.out.println("getOffsetToNextOrEqual(0, 0, 11, new int[]{-1}) = " + AlarmEntry.getOffsetToNextOrEqual(0, 0, 11, new int[]{-1}));
        System.out.println();
        System.out.println();
        System.out.println("discardValuesOverMax(new int[]{0,1,2,3,4,5,6}, 4)) = " + AlarmEntry.arrToString(AlarmEntry.discardValuesOverMax(new int[]{0, 1, 2, 3, 4, 5, 6}, 4)));
        System.out.println("discardValuesOverMax(new int[]{0,1,2,3,4,5,6}, 6)) = " + AlarmEntry.arrToString(AlarmEntry.discardValuesOverMax(new int[]{0, 1, 2, 3, 4, 5, 6}, 6)));
        System.out.println("discardValuesOverMax(new int[]{0,1,2,3,4,5,6}, 0)) = " + AlarmEntry.arrToString(AlarmEntry.discardValuesOverMax(new int[]{0, 1, 2, 3, 4, 5, 6}, 0)));
        System.out.println("discardValuesOverMax(new int[]{0,1,2,3,4,5,6}, 7)) = " + AlarmEntry.arrToString(AlarmEntry.discardValuesOverMax(new int[]{0, 1, 2, 3, 4, 5, 6}, 7)));
    }
}

